import json
from typing import Any, Dict, Optional

from common.llm_assist.logging import logger


def append_user_profile_to_prompt(
    system_prompt: str, user_profile: Optional[Dict[str, Any]] = None, include_full_user_profile: Optional[bool] = True
) -> str:
    if not user_profile:
        return system_prompt

    if language := user_profile.get("language", {}).get("value"):
        system_prompt += "\n The user prefers to communicate in " + str(language) + ". Adjust your answer accordingly."
    if include_full_user_profile:
        try:
            user_profile_without_language = {k: v for k, v in user_profile.items() if k != "language"}
            user_profile_json = json.dumps(user_profile_without_language)
            system_prompt = f"{system_prompt}. \n The user profile is the following: \n # USER PROFILE: \n {user_profile_json} \n # --- END OF USER PROFILE ---\n Consider information provided in the USER PROFILE if meaningful, take it into account."
        except json.JSONDecodeError:
            logger.error("Failed to append user profile to prompt due to JSON decoding error.")
    return system_prompt
