import os

from common.llm_assist.logging import logger
from dotenv import load_dotenv
from flask import Flask

load_dotenv()

from portal.backend.local_config import setup_dataiku_client # noqa
from portal.backend.utils.launch_utils import setup_app # noqa


def register_blueprints(app):
    from portal.backend.routes import api
    app.register_blueprint(blueprint=api)


def setup_local_app():
    app = Flask(__name__)
    from flask_cors import CORS
    CORS(app)
    logger.info("Creating Flask Application")
    setup_dataiku_client()
    socketio = setup_app(app)

    register_blueprints(app)

    app.debug = True
    return app, socketio


if __name__ == "__main__":
    os.environ['FLASK_ENV'] = 'development'
    app, socketio = setup_local_app()
    logger.info("Running Application")
    socketio.run(app, host="127.0.0.1", port=5000, debug=True)
    # app.run(host="127.0.0.1", port=int(os.getenv("VITE_API_PORT")), debug=True)