from typing import Any, Dict, List, Optional, TypedDict, Union

from common.backend.models.base import Feedback, GeneratedMedia, RecordState
from common.backend.models.source import Source


class MessageInfo(TypedDict):
    message_id: str
    query: str
    answer: str
    platform: str
    filters: Optional[Dict[str, List[Union[str, float, int]]]]
    sources: Optional[List[Source]]
    created_at: float
    updated_at: float
    llm_context: Optional[Dict[str, Any]]
    generated_media: Optional[Dict[str, List[GeneratedMedia]]]
    feedback: Optional[Feedback]
    conversation_id: Optional[str]
    state: RecordState
    user: Optional[str]
    llm_name: Optional[str]
    # HISTORY?

