from common.backend.schemas.ui_settings import UISettingsSchema
from common.backend.services.ui_settings import UISettingsService
from common.llm_assist.log_decorators import log_http_request
from flask import Blueprint, jsonify

# Create a Blueprint for settings
settings_bp = Blueprint("settings", __name__)

@settings_bp.route("/settings/ui", methods=["GET"])
@log_http_request
def get_ui_settings():
    """
    API to fetch UI settings.
    """
    # Retrieve UI settings from the service
    ui_settings = UISettingsService.get_ui_settings()

    # Validate and serialize the data using the schema
    schema = UISettingsSchema()
    validated_data = schema.dump(ui_settings)

    # Return the response
    return jsonify({
        "status": "ok",
        "data": {"uiSettings": validated_data}
    })