
from dataikuapi.dss.llm import DSSLLMCompletionResponse

NEW_DB_FORMAT = [
    {
        "toolCallDescription": "Used database kitchen_history",
        "items": [
            {
                "type": "RECORDS",
                "records": {
                    "rows": [{"total_questions": 45}],
                    "columns": [
                        {
                            "name": "total_questions",
                            "label": "total_questions",
                            "field": "total_questions",
                            "align": "left",
                        }
                    ],
                    "query": 'SELECT COUNT("question") AS "total_questions"\n  FROM "ANSWERS_kitchen_history"\n  LIMIT 50',
                },
                "generatedSqlQuery": 'SELECT COUNT("question") AS "total_questions"\n  FROM "ANSWERS_kitchen_history"\n  LIMIT 50',
                "usedTables": "kitchen_history",
                'tool_name_used': 'kitchen_history'
            }
        ],
    }
]
    
OLD_DB_FORMAT = [{
    'sample': {
        'rows': [{
            'total_questions': 45
        }],
        'columns': [{
            'name': 'total_questions',
            'label': 'total_questions',
            'field': 'total_questions',
            'align': 'left'
        }],
        'query': 'SELECT COUNT("question") AS "total_questions"\n  FROM "ANSWERS_kitchen_history"\n  LIMIT 50'
    },
    'metadata': {
        'source_title': 'kitchen_history'
    },
    'tool_name_used': 'kitchen_history'
}]

NEW_KB_FORMAT = [{
    'toolCallDescription': 'Used knowledge bank kb_cooking_stuff_embedded',
    'items': [{
        'type': 'SIMPLE_DOCUMENT',
        'metadata': {
            'source_title': 'Curry Spices and Their Combinations',
            'source_url': 'https://example.com/curry',
            'source_thumbnail_url': '',
            'tags': [{
                'name': 'Category',
                'value': 'Ingredients & Flavors',
                'type': 'string'
            }, {
                'name': 'Source',
                'value': 'https://example.com/curry',
                'type': 'string'
            }, {
                'name': 'Title',
                'value': 'Curry Spices and Their Combinations',
                'type': 'string'
            }]
        },
        'title': 'Curry Spices and Their Combinations',
        'url': 'https://example.com/curry',
        'textSnippet': 'Curry pairs well with coconut, ginger, and chicken in sauces.',
        'images': [],
        'tool_name_used': 'kb_cooking_stuff_embedded'
    }, {
        'type': 'SIMPLE_DOCUMENT',
        'metadata': {
            'source_title': 'Indian Spices: Curry, Turmeric, Cumin',
            'source_url': 'https://example.com/indian-spices',
            'source_thumbnail_url': '',
            'tags': [{
                'name': 'Category',
                'value': 'Ingredients & Flavors',
                'type': 'string'
            }, {
                'name': 'Source',
                'value': 'https://example.com/indian-spices',
                'type': 'string'
            }, {
                'name': 'Title',
                'value': 'Indian Spices: Curry, Turmeric, Cumin',
                'type': 'string'
            }]
        },
        'title': 'Indian Spices: Curry, Turmeric, Cumin',
        'url': 'https://example.com/indian-spices',
        'textSnippet': 'Indian spices such as curry, turmeric, and cumin add depth and warmth to curries and rice dishes.',
        'images': [],
        'tool_name_used': 'kb_cooking_stuff_embedded'
    }, {
        'type': 'SIMPLE_DOCUMENT',
        'metadata': {
            'source_title': 'Dry Spices in Cakes',
            'source_url': 'https://example.com/dry-spices',
            'source_thumbnail_url': '',
            'tags': [{
                'name': 'Category',
                'value': 'Ingredients & Flavors',
                'type': 'string'
            }, {
                'name': 'Source',
                'value': 'https://example.com/dry-spices',
                'type': 'string'
            }, {
                'name': 'Title',
                'value': 'Dry Spices in Cakes',
                'type': 'string'
            }]
        },
        'title': 'Dry Spices in Cakes',
        'url': 'https://example.com/dry-spices',
        'textSnippet': 'Sweet spices such as cinnamon, nutmeg, and ginger bring warmth and depth to cakes and desserts.',
        'images': [],
        'tool_name_used': 'kb_cooking_stuff_embedded'
    }]
}]

OLD_KB_FORMAT = [{
    'excerpt': 'Curry pairs well with coconut, ginger, and chicken in sauces.',
    'metadata': {
        'source_title': 'Curry Spices and Their Combinations',
        'source_url': 'https://example.com/curry',
        'source_thumbnail_url': '',
        'tags': [{
            'name': 'Category',
            'value': 'Ingredients & Flavors',
            'type': 'string'
        }, {
            'name': 'Source',
            'value': 'https://example.com/curry',
            'type': 'string'
        }, {
            'name': 'Title',
            'value': 'Curry Spices and Their Combinations',
            'type': 'string'
        }]
    },
    'images': [],
    'tool_name_used': 'kb_cooking_stuff_embedded'
}, {
    'excerpt': 'Indian spices such as curry, turmeric, and cumin add depth and warmth to curries and rice dishes.',
    'metadata': {
        'source_title': 'Indian Spices: Curry, Turmeric, Cumin',
        'source_url': 'https://example.com/indian-spices',
        'source_thumbnail_url': '',
        'tags': [{
            'name': 'Category',
            'value': 'Ingredients & Flavors',
            'type': 'string'
        }, {
            'name': 'Source',
            'value': 'https://example.com/indian-spices',
            'type': 'string'
        }, {
            'name': 'Title',
            'value': 'Indian Spices: Curry, Turmeric, Cumin',
            'type': 'string'
        }]
    },
    'images': [],
    'tool_name_used': 'kb_cooking_stuff_embedded'
}, {
    'excerpt': 'Sweet spices such as cinnamon, nutmeg, and ginger bring warmth and depth to cakes and desserts.',
    'metadata': {
        'source_title': 'Dry Spices in Cakes',
        'source_url': 'https://example.com/dry-spices',
        'source_thumbnail_url': '',
        'tags': [{
            'name': 'Category',
            'value': 'Ingredients & Flavors',
            'type': 'string'
        }, {
            'name': 'Source',
            'value': 'https://example.com/dry-spices',
            'type': 'string'
        }, {
            'name': 'Title',
            'value': 'Dry Spices in Cakes',
            'type': 'string'
        }]
    },
    'images': [],
    'tool_name_used': 'kb_cooking_stuff_embedded'
}]

EXPECTED_SERIALIZED_DB_SOURCES = [
    {
        "toolCallDescription": "Used database kitchen_history",
        "items": [
            {
                "type": "RECORDS",
                "records": {
                    "rows": [{"total_questions": 45}],
                    "columns": [
                        {
                            "name": "total_questions",
                            "label": "total_questions",
                            "field": "total_questions",
                            "align": "left",
                        }
                    ],
                    "query": 'SELECT COUNT("question") AS "total_questions"\n  FROM "ANSWERS_kitchen_history"\n  LIMIT 50',
                },
                "generatedSqlQuery": 'SELECT COUNT("question") AS "total_questions"\n  FROM "ANSWERS_kitchen_history"\n  LIMIT 50',
                "usedTables": "kitchen_history",
            }
        ],
    }
]

EXPECTED_SERIALIZED_KB_SOURCES = [
    {
        "toolCallDescription": "Used knowledge bank kb_cooking_stuff_embedded",
        "items": [
            {
                "metadata": {
                    "source_title": "Curry Spices and Their Combinations",
                    "source_url": "https://example.com/curry",
                    "source_thumbnail_url": "",
                    "tags": [
                        {"name": "Category", "value": "Ingredients & Flavors", "type": "string"},
                        {"name": "Source", "value": "https://example.com/curry", "type": "string"},
                        {"name": "Title", "value": "Curry Spices and Their Combinations", "type": "string"},
                    ],
                },
                "images": [],
                "type": "SIMPLE_DOCUMENT",
                "title": "Curry Spices and Their Combinations",
                "url": "https://example.com/curry",
                "textSnippet": "Curry pairs well with coconut, ginger, and chicken in sauces.",
            },
            {
                "metadata": {
                    "source_title": "Indian Spices: Curry, Turmeric, Cumin",
                    "source_url": "https://example.com/indian-spices",
                    "source_thumbnail_url": "",
                    "tags": [
                        {"name": "Category", "value": "Ingredients & Flavors", "type": "string"},
                        {"name": "Source", "value": "https://example.com/indian-spices", "type": "string"},
                        {"name": "Title", "value": "Indian Spices: Curry, Turmeric, Cumin", "type": "string"},
                    ],
                },
                "images": [],
                "type": "SIMPLE_DOCUMENT",
                "title": "Indian Spices: Curry, Turmeric, Cumin",
                "url": "https://example.com/indian-spices",
                "textSnippet": "Indian spices such as curry, turmeric, and cumin add depth and warmth to curries and rice dishes.",
            },
            {
                "metadata": {
                    "source_title": "Dry Spices in Cakes",
                    "source_url": "https://example.com/dry-spices",
                    "source_thumbnail_url": "",
                    "tags": [
                        {"name": "Category", "value": "Ingredients & Flavors", "type": "string"},
                        {"name": "Source", "value": "https://example.com/dry-spices", "type": "string"},
                        {"name": "Title", "value": "Dry Spices in Cakes", "type": "string"},
                    ],
                },
                "images": [],
                "type": "SIMPLE_DOCUMENT",
                "title": "Dry Spices in Cakes",
                "url": "https://example.com/dry-spices",
                "textSnippet": "Sweet spices such as cinnamon, nutmeg, and ginger bring warmth and depth to cakes and desserts.",
            },
        ],
    }
]

AUGMENTED_LLM_RESPONSE = DSSLLMCompletionResponse(
    raw_resp={
        "ok": True,
        "text": "Kitsune are a type of legendary creature from Japanese folklore, known for being intelligent foxes with the ability to shape-shift into human forms. They are often depicted as both protectors and tricksters. Kitsune are believed to possess paranormal abilities that increase with their age and wisdom. They are associated with the Shinto deity Inari, the god of rice, and are often considered messenger spirits or guardians. While they can be benevolent and helpful, they are also known for their mischievous side, playing tricks on humans. Kitsune are an integral part of Japanese culture and folklore, frequently appearing in stories, myths, and art.",
        "finishReason": "stop",
        "sources": [
            {
                "excerpt": {
                    "type": "TEXT",
                    "text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.",
                },
                "metadata": {
                    "Category": "Folklore Japonais",
                    "Source": "https://example.com/kitsune",
                    "Title": "Kitsune: The Fox Spirits of Japan",
                },
            },
            {
                "excerpt": {
                    "type": "TEXT",
                    "text": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.",
                },
                "metadata": {
                    "Category": "Folklore Japonais",
                    "Source": "https://example.com/tengu",
                    "Title": "The Tengu: The Heavenly Dog of Japan",
                },
            },
            {
                "excerpt": {
                    "type": "TEXT",
                    "text": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.",
                },
                "metadata": {
                    "Category": "Folklore Japonais",
                    "Source": "https://example.com/kappa",
                    "Title": "The Kappa: The River Child of Japan",
                },
            },
            {
                "excerpt": {
                    "type": "TEXT",
                    "text": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.",
                },
                "metadata": {
                    "Category": "Folklore Japonais",
                    "Source": "https://example.com/kamaitachi",
                    "Title": "The Kamaitachi: The Weasel Sickle",
                },
            },
        ],
        "predictedClassProbas": [],
        "fromCache": False,
        "additionalInformation": {
            "sources": [
                {
                    "items": [
                        {
                            "metadata": {
                                "Category": "Folklore Japonais",
                                "Source": "https://example.com/kitsune",
                                "Title": "Kitsune: The Fox Spirits of Japan",
                            },
                            "type": "SIMPLE_DOCUMENT",
                            "textSnippet": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.",
                        },
                        {
                            "metadata": {
                                "Category": "Folklore Japonais",
                                "Source": "https://example.com/tengu",
                                "Title": "The Tengu: The Heavenly Dog of Japan",
                            },
                            "type": "SIMPLE_DOCUMENT",
                            "textSnippet": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.",
                        },
                        {
                            "metadata": {
                                "Category": "Folklore Japonais",
                                "Source": "https://example.com/kappa",
                                "Title": "The Kappa: The River Child of Japan",
                            },
                            "type": "SIMPLE_DOCUMENT",
                            "textSnippet": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.",
                        },
                        {
                            "metadata": {
                                "Category": "Folklore Japonais",
                                "Source": "https://example.com/kamaitachi",
                                "Title": "The Kamaitachi: The Weasel Sickle",
                            },
                            "type": "SIMPLE_DOCUMENT",
                            "textSnippet": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.",
                        },
                    ]
                }
            ]
        },
        "reportedUsageMetadata": {
            "promptTokens": 192,
            "completionTokens": 130,
            "totalTokens": 322,
            "estimatedCost": 0.00178,
        },
        "trace": {
            "type": "span",
            "begin": "2025-08-29T09:31:52.824Z",
            "end": "2025-08-29T09:32:07.842Z",
            "duration": 15018,
            "name": "DKU_LLM_MESH_COMPLETION_QUERY",
            "children": [
                {
                    "type": "span",
                    "begin": "2025-08-29T09:31:52.825Z",
                    "end": "2025-08-29T09:31:52.825Z",
                    "duration": 0,
                    "name": "DKU_LLM_MESH_QUERY_ENFORCEMENT",
                    "children": [],
                    "attributes": {},
                },
                {
                    "type": "span",
                    "begin": "2025-08-29T09:31:52.825Z",
                    "end": "2025-08-29T09:32:07.841Z",
                    "duration": 15016,
                    "usageMetadata": {},
                    "name": "DKU_LLM_MESH_LLM_CALL",
                    "children": [
                        {
                            "type": "span",
                            "begin": "2025-08-29T09:32:02.477000Z",
                            "end": "2025-08-29T09:32:07.839000Z",
                            "duration": 5362,
                            "name": "DKU_BUILTIN_RAG",
                            "children": [
                                {
                                    "type": "span",
                                    "begin": "2025-08-29T09:32:02.477000Z",
                                    "end": "2025-08-29T09:32:03.684000Z",
                                    "duration": 1207,
                                    "name": "RAG_RETRIEVE_DOCUMENTS",
                                    "children": [
                                        {
                                            "type": "span",
                                            "begin": "2025-08-29T09:32:03.623000Z",
                                            "end": "2025-08-29T09:32:03.639000Z",
                                            "duration": 16,
                                            "name": "DKUEmbeddings",
                                            "children": [
                                                {
                                                    "type": "span",
                                                    "begin": "2025-08-29T09:32:03.634Z",
                                                    "end": "2025-08-29T09:32:03.635Z",
                                                    "duration": 1,
                                                    "name": "DKU_LLM_MESH_EMBEDDING_QUERY",
                                                    "children": [
                                                        {
                                                            "type": "span",
                                                            "begin": "2025-08-29T09:32:03.634Z",
                                                            "end": "2025-08-29T09:32:03.634Z",
                                                            "duration": 0,
                                                            "name": "DKU_LLM_MESH_QUERY_ENFORCEMENT",
                                                            "children": [],
                                                            "attributes": {},
                                                        },
                                                        {
                                                            "type": "event",
                                                            "timestamp": "2025-08-29T09:32:03.635Z",
                                                            "name": "DKU_LLM_MESH_CACHE_HIT",
                                                            "children": [],
                                                            "attributes": {},
                                                        },
                                                    ],
                                                    "attributes": {
                                                        "llmId": "openai:bs-openai:text-embedding-3-small",
                                                        "llmProvider": "OPENAI",
                                                        "llmModel": "text-embedding-3-small",
                                                        "embeddingQuery": {"text": "What do you know about Kitsune ?"},
                                                        "embeddingQuerySettings": {"textOverflowMode": "FAIL"},
                                                        "embeddingResponse": {
                                                            "ok": True,
                                                            "promptTokens": 8,
                                                            "tokenCountsAreEstimated": False,
                                                            "estimatedCost": 0,
                                                        },
                                                    },
                                                    "inputs": {"text": "What do you know about Kitsune ?"},
                                                }
                                            ],
                                            "attributes": {},
                                            "inputs": {},
                                            "outputs": {},
                                        }
                                    ],
                                    "attributes": {"nbRetrievedDocuments": 4},
                                    "inputs": {},
                                    "outputs": {},
                                },
                                {
                                    "type": "span",
                                    "begin": "2025-08-29T09:32:03.684000Z",
                                    "end": "2025-08-29T09:32:07.839000Z",
                                    "duration": 4155,
                                    "name": "RAG_QUERY_ORIGINAL_LLM",
                                    "children": [
                                        {
                                            "type": "span",
                                            "begin": "2025-08-29T09:32:03.689Z",
                                            "end": "2025-08-29T09:32:07.837Z",
                                            "duration": 4148,
                                            "name": "DKU_LLM_MESH_COMPLETION_QUERY",
                                            "children": [
                                                {
                                                    "type": "span",
                                                    "begin": "2025-08-29T09:32:03.689Z",
                                                    "end": "2025-08-29T09:32:03.689Z",
                                                    "duration": 0,
                                                    "name": "DKU_LLM_MESH_QUERY_ENFORCEMENT",
                                                    "children": [],
                                                    "attributes": {},
                                                },
                                                {
                                                    "type": "span",
                                                    "begin": "2025-08-29T09:32:03.689Z",
                                                    "end": "2025-08-29T09:32:07.837Z",
                                                    "duration": 4148,
                                                    "usageMetadata": {
                                                        "promptTokens": 192,
                                                        "completionTokens": 130,
                                                        "totalTokens": 322,
                                                        "estimatedCost": 0.00178,
                                                    },
                                                    "name": "DKU_LLM_MESH_LLM_CALL",
                                                    "children": [],
                                                    "attributes": {
                                                        "llmId": "openai:bs-openai:gpt-4o",
                                                        "llmProvider": "OPENAI",
                                                        "llmModel": "gpt-4o",
                                                        "completionQuery": {
                                                            "messages": [
                                                                {
                                                                    "role": "system",
                                                                    "content": "Use the following pieces of context to answer the question at the end.\nIf you do not know the answer, just say that you do not know, do not try to make up an answer.",
                                                                },
                                                                {
                                                                    "role": "user",
                                                                    "parts": [
                                                                        {
                                                                            "type": "TEXT",
                                                                            "text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.",
                                                                        },
                                                                        {
                                                                            "type": "TEXT",
                                                                            "text": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.",
                                                                        },
                                                                        {
                                                                            "type": "TEXT",
                                                                            "text": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.",
                                                                        },
                                                                        {
                                                                            "type": "TEXT",
                                                                            "text": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.",
                                                                        },
                                                                    ],
                                                                },
                                                                {
                                                                    "role": "user",
                                                                    "content": "What do you know about Kitsune ?",
                                                                },
                                                            ]
                                                        },
                                                        "completionQuerySettings": {
                                                            "maxOutputTokens": 1024,
                                                            "stopSequences": [],
                                                        },
                                                        "completionResponse": {
                                                            "ok": True,
                                                            "text": "Kitsune are a type of legendary creature from Japanese folklore, known for being intelligent foxes with the ability to shape-shift into human forms. They are often depicted as both protectors and tricksters. Kitsune are believed to possess paranormal abilities that increase with their age and wisdom. They are associated with the Shinto deity Inari, the god of rice, and are often considered messenger spirits or guardians. While they can be benevolent and helpful, they are also known for their mischievous side, playing tricks on humans. Kitsune are an integral part of Japanese culture and folklore, frequently appearing in stories, myths, and art.",
                                                            "finishReason": "stop",
                                                            "predictedClassProbas": [],
                                                            "fromCache": False,
                                                            "promptTokens": 192,
                                                            "completionTokens": 130,
                                                            "totalTokens": 322,
                                                            "estimatedCost": 0.00178,
                                                        },
                                                    },
                                                    "inputs": {
                                                        "messages": [
                                                            {
                                                                "role": "system",
                                                                "text": "Use the following pieces of context to answer the question at the end.\nIf you do not know the answer, just say that you do not know, do not try to make up an answer.",
                                                            },
                                                            {
                                                                "role": "user",
                                                                "text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.\nA type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.\nA yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.\nA Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.",
                                                            },
                                                            {
                                                                "role": "user",
                                                                "text": "What do you know about Kitsune ?",
                                                            },
                                                        ]
                                                    },
                                                    "outputs": {
                                                        "text": "Kitsune are a type of legendary creature from Japanese folklore, known for being intelligent foxes with the ability to shape-shift into human forms. They are often depicted as both protectors and tricksters. Kitsune are believed to possess paranormal abilities that increase with their age and wisdom. They are associated with the Shinto deity Inari, the god of rice, and are often considered messenger spirits or guardians. While they can be benevolent and helpful, they are also known for their mischievous side, playing tricks on humans. Kitsune are an integral part of Japanese culture and folklore, frequently appearing in stories, myths, and art."
                                                    },
                                                },
                                                {
                                                    "type": "span",
                                                    "begin": "2025-08-29T09:32:07.837Z",
                                                    "end": "2025-08-29T09:32:07.837Z",
                                                    "duration": 0,
                                                    "name": "DKU_LLM_MESH_RESPONSE_ENFORCEMENT",
                                                    "children": [],
                                                    "attributes": {},
                                                },
                                            ],
                                            "attributes": {
                                                "llmId": "openai:bs-openai:gpt-4o",
                                                "llmProvider": "OPENAI",
                                                "llmModel": "gpt-4o",
                                                "completionQuery": {
                                                    "messages": [
                                                        {
                                                            "role": "system",
                                                            "content": "Use the following pieces of context to answer the question at the end.\nIf you do not know the answer, just say that you do not know, do not try to make up an answer.",
                                                        },
                                                        {
                                                            "role": "user",
                                                            "parts": [
                                                                {
                                                                    "type": "TEXT",
                                                                    "text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.",
                                                                },
                                                                {
                                                                    "type": "TEXT",
                                                                    "text": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.",
                                                                },
                                                                {
                                                                    "type": "TEXT",
                                                                    "text": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.",
                                                                },
                                                                {
                                                                    "type": "TEXT",
                                                                    "text": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.",
                                                                },
                                                            ],
                                                        },
                                                        {
                                                            "role": "user",
                                                            "content": "What do you know about Kitsune ?",
                                                        },
                                                    ]
                                                },
                                                "completionQuerySettings": {
                                                    "maxOutputTokens": 1024,
                                                    "stopSequences": [],
                                                },
                                                "completionResponse": {
                                                    "ok": True,
                                                    "text": "Kitsune are a type of legendary creature from Japanese folklore, known for being intelligent foxes with the ability to shape-shift into human forms. They are often depicted as both protectors and tricksters. Kitsune are believed to possess paranormal abilities that increase with their age and wisdom. They are associated with the Shinto deity Inari, the god of rice, and are often considered messenger spirits or guardians. While they can be benevolent and helpful, they are also known for their mischievous side, playing tricks on humans. Kitsune are an integral part of Japanese culture and folklore, frequently appearing in stories, myths, and art.",
                                                    "finishReason": "stop",
                                                    "predictedClassProbas": [],
                                                    "fromCache": False,
                                                    "promptTokens": 192,
                                                    "completionTokens": 130,
                                                    "totalTokens": 322,
                                                    "estimatedCost": 0.00178,
                                                },
                                            },
                                            "inputs": {
                                                "messages": [
                                                    {
                                                        "role": "system",
                                                        "text": "Use the following pieces of context to answer the question at the end.\nIf you do not know the answer, just say that you do not know, do not try to make up an answer.",
                                                    },
                                                    {
                                                        "role": "user",
                                                        "text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.\nA type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.\nA yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.\nA Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.",
                                                    },
                                                    {"role": "user", "text": "What do you know about Kitsune ?"},
                                                ]
                                            },
                                            "outputs": {
                                                "text": "Kitsune are a type of legendary creature from Japanese folklore, known for being intelligent foxes with the ability to shape-shift into human forms. They are often depicted as both protectors and tricksters. Kitsune are believed to possess paranormal abilities that increase with their age and wisdom. They are associated with the Shinto deity Inari, the god of rice, and are often considered messenger spirits or guardians. While they can be benevolent and helpful, they are also known for their mischievous side, playing tricks on humans. Kitsune are an integral part of Japanese culture and folklore, frequently appearing in stories, myths, and art."
                                            },
                                        }
                                    ],
                                    "attributes": {},
                                    "inputs": {},
                                    "outputs": {},
                                },
                            ],
                            "attributes": {},
                            "inputs": {},
                            "outputs": {},
                        }
                    ],
                    "attributes": {
                        "llmId": "retrieval-augmented-llm:e342c30c",
                        "llmProvider": "RETRIEVAL_AUGMENTED",
                        "llmModel": "e342c30c",
                        "completionQuery": {
                            "messages": [{"role": "user", "content": "What do you know about Kitsune ?"}]
                        },
                        "completionQuerySettings": {"stopSequences": []},
                        "completionResponse": {
                            "ok": True,
                            "text": "Kitsune are a type of legendary creature from Japanese folklore, known for being intelligent foxes with the ability to shape-shift into human forms. They are often depicted as both protectors and tricksters. Kitsune are believed to possess paranormal abilities that increase with their age and wisdom. They are associated with the Shinto deity Inari, the god of rice, and are often considered messenger spirits or guardians. While they can be benevolent and helpful, they are also known for their mischievous side, playing tricks on humans. Kitsune are an integral part of Japanese culture and folklore, frequently appearing in stories, myths, and art.",
                            "finishReason": "stop",
                            "sources": [
                                {
                                    "excerpt": {
                                        "type": "TEXT",
                                        "text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.",
                                    },
                                    "metadata": {
                                        "Category": "Folklore Japonais",
                                        "Source": "https://example.com/kitsune",
                                        "Title": "Kitsune: The Fox Spirits of Japan",
                                    },
                                },
                                {
                                    "excerpt": {
                                        "type": "TEXT",
                                        "text": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.",
                                    },
                                    "metadata": {
                                        "Category": "Folklore Japonais",
                                        "Source": "https://example.com/tengu",
                                        "Title": "The Tengu: The Heavenly Dog of Japan",
                                    },
                                },
                                {
                                    "excerpt": {
                                        "type": "TEXT",
                                        "text": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.",
                                    },
                                    "metadata": {
                                        "Category": "Folklore Japonais",
                                        "Source": "https://example.com/kappa",
                                        "Title": "The Kappa: The River Child of Japan",
                                    },
                                },
                                {
                                    "excerpt": {
                                        "type": "TEXT",
                                        "text": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.",
                                    },
                                    "metadata": {
                                        "Category": "Folklore Japonais",
                                        "Source": "https://example.com/kamaitachi",
                                        "Title": "The Kamaitachi: The Weasel Sickle",
                                    },
                                },
                            ],
                            "predictedClassProbas": [],
                            "fromCache": False,
                            "additionalInformation": {
                                "sources": [
                                    {
                                        "items": [
                                            {
                                                "metadata": {
                                                    "Category": "Folklore Japonais",
                                                    "Source": "https://example.com/kitsune",
                                                    "Title": "Kitsune: The Fox Spirits of Japan",
                                                },
                                                "type": "SIMPLE_DOCUMENT",
                                                "textSnippet": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.",
                                            },
                                            {
                                                "metadata": {
                                                    "Category": "Folklore Japonais",
                                                    "Source": "https://example.com/tengu",
                                                    "Title": "The Tengu: The Heavenly Dog of Japan",
                                                },
                                                "type": "SIMPLE_DOCUMENT",
                                                "textSnippet": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.",
                                            },
                                            {
                                                "metadata": {
                                                    "Category": "Folklore Japonais",
                                                    "Source": "https://example.com/kappa",
                                                    "Title": "The Kappa: The River Child of Japan",
                                                },
                                                "type": "SIMPLE_DOCUMENT",
                                                "textSnippet": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.",
                                            },
                                            {
                                                "metadata": {
                                                    "Category": "Folklore Japonais",
                                                    "Source": "https://example.com/kamaitachi",
                                                    "Title": "The Kamaitachi: The Weasel Sickle",
                                                },
                                                "type": "SIMPLE_DOCUMENT",
                                                "textSnippet": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.",
                                            },
                                        ]
                                    }
                                ]
                            },
                            "reportedUsageMetadata": {
                                "promptTokens": 192,
                                "completionTokens": 130,
                                "totalTokens": 322,
                                "estimatedCost": 0.00178,
                            },
                        },
                    },
                    "inputs": {"messages": [{"role": "user", "text": "What do you know about Kitsune ?"}]},
                    "outputs": {
                        "text": "Kitsune are a type of legendary creature from Japanese folklore, known for being intelligent foxes with the ability to shape-shift into human forms. They are often depicted as both protectors and tricksters. Kitsune are believed to possess paranormal abilities that increase with their age and wisdom. They are associated with the Shinto deity Inari, the god of rice, and are often considered messenger spirits or guardians. While they can be benevolent and helpful, they are also known for their mischievous side, playing tricks on humans. Kitsune are an integral part of Japanese culture and folklore, frequently appearing in stories, myths, and art."
                    },
                },
                {
                    "type": "span",
                    "begin": "2025-08-29T09:32:07.841Z",
                    "end": "2025-08-29T09:32:07.841Z",
                    "duration": 0,
                    "name": "DKU_LLM_MESH_RESPONSE_ENFORCEMENT",
                    "children": [],
                    "attributes": {},
                },
            ],
            "attributes": {
                "llmId": "retrieval-augmented-llm:e342c30c",
                "llmProvider": "RETRIEVAL_AUGMENTED",
                "llmModel": "e342c30c",
                "completionQuery": {"messages": [{"role": "user", "content": "What do you know about Kitsune ?"}]},
                "completionQuerySettings": {"stopSequences": []},
                "completionResponse": {
                    "ok": True,
                    "text": "Kitsune are a type of legendary creature from Japanese folklore, known for being intelligent foxes with the ability to shape-shift into human forms. They are often depicted as both protectors and tricksters. Kitsune are believed to possess paranormal abilities that increase with their age and wisdom. They are associated with the Shinto deity Inari, the god of rice, and are often considered messenger spirits or guardians. While they can be benevolent and helpful, they are also known for their mischievous side, playing tricks on humans. Kitsune are an integral part of Japanese culture and folklore, frequently appearing in stories, myths, and art.",
                    "finishReason": "stop",
                    "sources": [
                        {
                            "excerpt": {
                                "type": "TEXT",
                                "text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.",
                            },
                            "metadata": {
                                "Category": "Folklore Japonais",
                                "Source": "https://example.com/kitsune",
                                "Title": "Kitsune: The Fox Spirits of Japan",
                            },
                        },
                        {
                            "excerpt": {
                                "type": "TEXT",
                                "text": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.",
                            },
                            "metadata": {
                                "Category": "Folklore Japonais",
                                "Source": "https://example.com/tengu",
                                "Title": "The Tengu: The Heavenly Dog of Japan",
                            },
                        },
                        {
                            "excerpt": {
                                "type": "TEXT",
                                "text": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.",
                            },
                            "metadata": {
                                "Category": "Folklore Japonais",
                                "Source": "https://example.com/kappa",
                                "Title": "The Kappa: The River Child of Japan",
                            },
                        },
                        {
                            "excerpt": {
                                "type": "TEXT",
                                "text": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.",
                            },
                            "metadata": {
                                "Category": "Folklore Japonais",
                                "Source": "https://example.com/kamaitachi",
                                "Title": "The Kamaitachi: The Weasel Sickle",
                            },
                        },
                    ],
                    "predictedClassProbas": [],
                    "fromCache": False,
                    "additionalInformation": {
                        "sources": [
                            {
                                "items": [
                                    {
                                        "metadata": {
                                            "Category": "Folklore Japonais",
                                            "Source": "https://example.com/kitsune",
                                            "Title": "Kitsune: The Fox Spirits of Japan",
                                        },
                                        "type": "SIMPLE_DOCUMENT",
                                        "textSnippet": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.",
                                    },
                                    {
                                        "metadata": {
                                            "Category": "Folklore Japonais",
                                            "Source": "https://example.com/tengu",
                                            "Title": "The Tengu: The Heavenly Dog of Japan",
                                        },
                                        "type": "SIMPLE_DOCUMENT",
                                        "textSnippet": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.",
                                    },
                                    {
                                        "metadata": {
                                            "Category": "Folklore Japonais",
                                            "Source": "https://example.com/kappa",
                                            "Title": "The Kappa: The River Child of Japan",
                                        },
                                        "type": "SIMPLE_DOCUMENT",
                                        "textSnippet": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.",
                                    },
                                    {
                                        "metadata": {
                                            "Category": "Folklore Japonais",
                                            "Source": "https://example.com/kamaitachi",
                                            "Title": "The Kamaitachi: The Weasel Sickle",
                                        },
                                        "type": "SIMPLE_DOCUMENT",
                                        "textSnippet": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.",
                                    },
                                ]
                            }
                        ]
                    },
                    "reportedUsageMetadata": {
                        "promptTokens": 192,
                        "completionTokens": 130,
                        "totalTokens": 322,
                        "estimatedCost": 0.00178,
                    },
                },
            },
            "inputs": {"messages": [{"role": "user", "text": "What do you know about Kitsune ?"}]},
            "outputs": {
                "text": "Kitsune are a type of legendary creature from Japanese folklore, known for being intelligent foxes with the ability to shape-shift into human forms. They are often depicted as both protectors and tricksters. Kitsune are believed to possess paranormal abilities that increase with their age and wisdom. They are associated with the Shinto deity Inari, the god of rice, and are often considered messenger spirits or guardians. While they can be benevolent and helpful, they are also known for their mischievous side, playing tricks on humans. Kitsune are an integral part of Japanese culture and folklore, frequently appearing in stories, myths, and art."
            },
        },
    }
)

EXPECTED_AUGMENTED_SOURCES = [
    {
        "toolCallDescription": "Used: mocked_augmented_llm",
        "items": [
            {
                "title": None,
                "type": "SIMPLE_DOCUMENT",
                "images": None,
                "textSnippet": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.",
                "htmlSnippet": None,
                "markdownSnippet": None,
                "url": "",
                "metadata": {
                    "Category": "Folklore Japonais",
                    "Source": "https://example.com/kitsune",
                    "Title": "Kitsune: The Fox Spirits of Japan",
                    "tags": [
                        {"name": "Category", "value": "Folklore Japonais", "type": "string"},
                        {"name": "Source", "value": "https://example.com/kitsune", "type": "string"},
                        {"name": "Title", "value": "Kitsune: The Fox Spirits of Japan", "type": "string"},
                    ],
                },
            },
            {
                "title": None,
                "type": "SIMPLE_DOCUMENT",
                "images": None,
                "textSnippet": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.",
                "htmlSnippet": None,
                "markdownSnippet": None,
                "url": "",
                "metadata": {
                    "Category": "Folklore Japonais",
                    "Source": "https://example.com/tengu",
                    "Title": "The Tengu: The Heavenly Dog of Japan",
                    "tags": [
                        {"name": "Category", "value": "Folklore Japonais", "type": "string"},
                        {"name": "Source", "value": "https://example.com/tengu", "type": "string"},
                        {"name": "Title", "value": "The Tengu: The Heavenly Dog of Japan", "type": "string"},
                    ],
                },
            },
            {
                "title": None,
                "type": "SIMPLE_DOCUMENT",
                "images": None,
                "textSnippet": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.",
                "htmlSnippet": None,
                "markdownSnippet": None,
                "url": "",
                "metadata": {
                    "Category": "Folklore Japonais",
                    "Source": "https://example.com/kappa",
                    "Title": "The Kappa: The River Child of Japan",
                    "tags": [
                        {"name": "Category", "value": "Folklore Japonais", "type": "string"},
                        {"name": "Source", "value": "https://example.com/kappa", "type": "string"},
                        {"name": "Title", "value": "The Kappa: The River Child of Japan", "type": "string"},
                    ],
                },
            },
            {
                "title": None,
                "type": "SIMPLE_DOCUMENT",
                "images": None,
                "textSnippet": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.",
                "htmlSnippet": None,
                "markdownSnippet": None,
                "url": "",
                "metadata": {
                    "Category": "Folklore Japonais",
                    "Source": "https://example.com/kamaitachi",
                    "Title": "The Kamaitachi: The Weasel Sickle",
                    "tags": [
                        {"name": "Category", "value": "Folklore Japonais", "type": "string"},
                        {"name": "Source", "value": "https://example.com/kamaitachi", "type": "string"},
                        {"name": "Title", "value": "The Kamaitachi: The Weasel Sickle", "type": "string"},
                    ],
                },
            },
        ],
    }
]

AGENT_LLM_RESPONSE = DSSLLMCompletionResponse(
    {
        "ok": True,
        "text": "Kitsune are intelligent foxes in Japanese folklore known for their ability to shape-shift into humans. They are depicted as both protectors and tricksters. These mythical creatures are part of the rich tapestry of Japanese folklore, embodying both benevolent and mischievous traits.\n\nFor more information, you can refer to the source: [Kitsune: The Fox Spirits of Japan](https://example.com/kitsune).\n\nIf you want to know more or explore other related entities in Japanese folklore, feel free to ask!",
        "finishReason": "unknown",
        "predictedClassProbas": [],
        "fromCache": False,
        "additionalInformation": {
            "sources": [
                {
                    "toolCallDescription": "Searched Knowledge Bank fake_mythologie_db_embedded for 'Kitsune'",
                    "items": [
                        {
                            "type": "SIMPLE_DOCUMENT",
                            "metadata": {},
                            "title": "Kitsune: The Fox Spirits of Japan",
                            "url": "https://example.com/kitsune",
                            "textSnippet": "Kitsune: The Fox Spirits of Japan",
                        },
                        {
                            "type": "SIMPLE_DOCUMENT",
                            "metadata": {},
                            "title": "The Tengu: The Heavenly Dog of Japan",
                            "url": "https://example.com/tengu",
                            "textSnippet": "The Tengu: The Heavenly Dog of Japan",
                        },
                        {
                            "type": "SIMPLE_DOCUMENT",
                            "metadata": {},
                            "title": "The Kappa: The River Child of Japan",
                            "url": "https://example.com/kappa",
                            "textSnippet": "The Kappa: The River Child of Japan",
                        },
                        {
                            "type": "SIMPLE_DOCUMENT",
                            "metadata": {},
                            "title": "The Kamaitachi: The Weasel Sickle",
                            "url": "https://example.com/kamaitachi",
                            "textSnippet": "The Kamaitachi: The Weasel Sickle",
                        },
                    ],
                }
            ]
        },
        "trace": {
            "type": "span",
            "begin": "2025-07-11T09:39:27.478Z",
            "end": "2025-07-11T09:39:38.101Z",
            "duration": 10623,
            "name": "DKU_LLM_MESH_COMPLETION_QUERY",
            "children": [
                {
                    "type": "span",
                    "begin": "2025-07-11T09:39:27.479Z",
                    "end": "2025-07-11T09:39:27.479Z",
                    "duration": 0,
                    "name": "DKU_LLM_MESH_QUERY_ENFORCEMENT",
                    "children": [],
                    "attributes": {},
                },
                {
                    "type": "span",
                    "begin": "2025-07-11T09:39:27.479Z",
                    "end": "2025-07-11T09:39:38.099Z",
                    "duration": 10620,
                    "usageMetadata": {},
                    "name": "DKU_LLM_MESH_LLM_CALL",
                    "children": [
                        {
                            "type": "span",
                            "begin": "2025-07-11T09:39:30.983000Z",
                            "end": "2025-07-11T09:39:38.095000Z",
                            "duration": 7112,
                            "name": "DKU_AGENT_CALL",
                            "children": [
                                {
                                    "type": "span",
                                    "begin": "2025-07-11T09:39:31.103166Z",
                                    "end": "2025-07-11T09:39:38.088220Z",
                                    "duration": 6985,
                                    "name": "LangGraph",
                                    "children": [
                                        {
                                            "type": "span",
                                            "begin": "2025-07-11T09:39:31.220909Z",
                                            "end": "2025-07-11T09:39:32.561141Z",
                                            "duration": 1340,
                                            "name": "agent",
                                            "children": [
                                                {
                                                    "type": "span",
                                                    "begin": "2025-07-11T09:39:31.227827Z",
                                                    "end": "2025-07-11T09:39:32.540431Z",
                                                    "duration": 1312,
                                                    "name": "call_model",
                                                    "children": [],
                                                    "attributes": {
                                                        "ls_run_id": "3ee3c687-4776-4954-a1b7-814a6ddfb445"
                                                    },
                                                    "inputs": {"is_last_step": False, "remaining_steps": 24},
                                                    "outputs": {},
                                                },
                                                {
                                                    "type": "span",
                                                    "begin": "2025-07-11T09:39:31.239442Z",
                                                    "end": "2025-07-11T09:39:32.538172Z",
                                                    "duration": 1298,
                                                    "name": "RunnableSequence",
                                                    "children": [
                                                        {
                                                            "type": "span",
                                                            "begin": "2025-07-11T09:39:31.240407Z",
                                                            "end": "2025-07-11T09:39:31.241280Z",
                                                            "duration": 0,
                                                            "name": "Prompt",
                                                            "children": [],
                                                            "attributes": {
                                                                "ls_run_id": "0d39228c-2a7e-41ff-b738-52607d829f6b"
                                                            },
                                                            "inputs": {
                                                                "is_last_step": False,
                                                                "remaining_steps": 24,
                                                            },
                                                            "outputs": {},
                                                        },
                                                        {
                                                            "type": "span",
                                                            "begin": "2025-07-11T09:39:31.248367Z",
                                                            "end": "2025-07-11T09:39:32.534780Z",
                                                            "duration": 1286,
                                                            "name": "DKUChatModel",
                                                            "children": [
                                                                {
                                                                    "type": "span",
                                                                    "begin": "2025-07-11T09:39:31.262Z",
                                                                    "end": "2025-07-11T09:39:32.520Z",
                                                                    "duration": 1258,
                                                                    "name": "DKU_LLM_MESH_COMPLETION_QUERY_STREAMED",
                                                                    "children": [
                                                                        {
                                                                            "type": "span",
                                                                            "begin": "2025-07-11T09:39:31.263Z",
                                                                            "end": "2025-07-11T09:39:31.263Z",
                                                                            "duration": 0,
                                                                            "name": "DKU_LLM_MESH_QUERY_ENFORCEMENT",
                                                                            "children": [],
                                                                            "attributes": {},
                                                                        },
                                                                        {
                                                                            "type": "span",
                                                                            "begin": "2025-07-11T09:39:31.263Z",
                                                                            "end": "2025-07-11T09:39:32.520Z",
                                                                            "duration": 1257,
                                                                            "usageMetadata": {
                                                                                "promptTokens": 119,
                                                                                "completionTokens": 25,
                                                                                "totalTokens": 144,
                                                                                "estimatedCost": 0.0005475,
                                                                            },
                                                                            "name": "DKU_LLM_MESH_LLM_CALL_STREAMED",
                                                                            "children": [
                                                                                {
                                                                                    "type": "event",
                                                                                    "timestamp": "2025-07-11T09:39:32.360Z",
                                                                                    "name": "DKU_LLM_MESH_LLM_CALL_STREAMED_FIRST_CHUNK",
                                                                                    "children": [],
                                                                                    "attributes": {},
                                                                                },
                                                                                {
                                                                                    "type": "event",
                                                                                    "timestamp": "2025-07-11T09:39:32.519Z",
                                                                                    "name": "DKU_LLM_MESH_LLM_CALL_STREAMED_STREAM_COMPLETE",
                                                                                    "children": [],
                                                                                    "attributes": {},
                                                                                },
                                                                            ],
                                                                            "attributes": {
                                                                                "llmId": "openai:bs-openai:gpt-4o",
                                                                                "llmProvider": "OPENAI",
                                                                                "llmModel": "gpt-4o",
                                                                                "completionQuery": {
                                                                                    "messages": [
                                                                                        {
                                                                                            "role": "system",
                                                                                            "content": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                                        },
                                                                                        {
                                                                                            "role": "user",
                                                                                            "content": "What do you know about Kitsune ?",
                                                                                        },
                                                                                    ]
                                                                                },
                                                                                "completionQuerySettings": {
                                                                                    "stopSequences": [],
                                                                                    "tools": [
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "name": "mythologie_kb_search_iBN2ko",
                                                                                                "description": "Searches for relevant documents in the knowledge bank (vector store) fake_mythologie_db_embedded\n\nThis knowledge bank contains informations about mythology facts\n\nTool to search into a mythology knowledge bank",
                                                                                                "parameters": {
                                                                                                    "$schema": "https://json-schema.org/draft/2020-12/schema",
                                                                                                    "$id": "https://dataiku.com/agents/tools/knowledge-banks/lookup/input",
                                                                                                    "type": "object",
                                                                                                    "properties": {
                                                                                                        "searchQuery": {
                                                                                                            "type": "string",
                                                                                                            "description": "The search query in the knowledge bank / vector store",
                                                                                                        }
                                                                                                    },
                                                                                                },
                                                                                            },
                                                                                        }
                                                                                    ],
                                                                                },
                                                                                "completionResponse": {
                                                                                    "ok": False,
                                                                                    "text": "",
                                                                                    "finishReason": "unknown",
                                                                                    "toolCalls": [
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "name": "mythologie_kb_search_iBN2ko",
                                                                                                "arguments": "",
                                                                                            },
                                                                                            "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": '{"'
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": "search"
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": "Query"
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": '":"'
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": "K"
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": "its"
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": "une"
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": '"}'
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                    ],
                                                                                    "predictedClassProbas": [],
                                                                                    "fromCache": False,
                                                                                },
                                                                            },
                                                                            "inputs": {
                                                                                "messages": [
                                                                                    {
                                                                                        "role": "system",
                                                                                        "text": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                                    },
                                                                                    {
                                                                                        "role": "user",
                                                                                        "text": "What do you know about Kitsune ?",
                                                                                    },
                                                                                ]
                                                                            },
                                                                            "outputs": {
                                                                                "toolCalls": [
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "name": "mythologie_kb_search_iBN2ko",
                                                                                            "arguments": "",
                                                                                        },
                                                                                        "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": '{"'
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": "search"
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": "Query"
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": '":"'
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": "K"
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": "its"
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": "une"
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": '"}'
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                ]
                                                                            },
                                                                        },
                                                                    ],
                                                                    "attributes": {
                                                                        "llmId": "openai:bs-openai:gpt-4o",
                                                                        "llmProvider": "OPENAI",
                                                                        "llmModel": "gpt-4o",
                                                                        "completionQuery": {
                                                                            "messages": [
                                                                                {
                                                                                    "role": "system",
                                                                                    "content": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                                },
                                                                                {
                                                                                    "role": "user",
                                                                                    "content": "What do you know about Kitsune ?",
                                                                                },
                                                                            ]
                                                                        },
                                                                        "completionQuerySettings": {
                                                                            "stopSequences": [],
                                                                            "tools": [
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "name": "mythologie_kb_search_iBN2ko",
                                                                                        "description": "Searches for relevant documents in the knowledge bank (vector store) fake_mythologie_db_embedded\n\nThis knowledge bank contains informations about mythology facts\n\nTool to search into a mythology knowledge bank",
                                                                                        "parameters": {
                                                                                            "$schema": "https://json-schema.org/draft/2020-12/schema",
                                                                                            "$id": "https://dataiku.com/agents/tools/knowledge-banks/lookup/input",
                                                                                            "type": "object",
                                                                                            "properties": {
                                                                                                "searchQuery": {
                                                                                                    "type": "string",
                                                                                                    "description": "The search query in the knowledge bank / vector store",
                                                                                                }
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                }
                                                                            ],
                                                                        },
                                                                        "completionResponse": {
                                                                            "ok": False,
                                                                            "text": "",
                                                                            "finishReason": "unknown",
                                                                            "toolCalls": [
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "name": "mythologie_kb_search_iBN2ko",
                                                                                        "arguments": "",
                                                                                    },
                                                                                    "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": '{"'
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": "search"
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": "Query"
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": '":"'
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": "K"
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": "its"
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": "une"
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": '"}'
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                            ],
                                                                            "predictedClassProbas": [],
                                                                            "fromCache": False,
                                                                        },
                                                                    },
                                                                    "inputs": {
                                                                        "messages": [
                                                                            {
                                                                                "role": "system",
                                                                                "text": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                            },
                                                                            {
                                                                                "role": "user",
                                                                                "text": "What do you know about Kitsune ?",
                                                                            },
                                                                        ]
                                                                    },
                                                                    "outputs": {
                                                                        "toolCalls": [
                                                                            {
                                                                                "type": "function",
                                                                                "function": {
                                                                                    "name": "mythologie_kb_search_iBN2ko",
                                                                                    "arguments": "",
                                                                                },
                                                                                "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {"arguments": '{"'},
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {
                                                                                    "arguments": "search"
                                                                                },
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {
                                                                                    "arguments": "Query"
                                                                                },
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {
                                                                                    "arguments": '":"'
                                                                                },
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {"arguments": "K"},
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {
                                                                                    "arguments": "its"
                                                                                },
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {
                                                                                    "arguments": "une"
                                                                                },
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {"arguments": '"}'},
                                                                                "index": 0,
                                                                            },
                                                                        ]
                                                                    },
                                                                }
                                                            ],
                                                            "attributes": {
                                                                "ls_run_id": "4e8debf3-67db-4681-81e8-28e830322eaa"
                                                            },
                                                            "inputs": {},
                                                            "outputs": {"type": "LLMResult"},
                                                        },
                                                    ],
                                                    "attributes": {
                                                        "ls_run_id": "cbd99599-3206-48b3-8097-c24f12319e16"
                                                    },
                                                    "inputs": {"is_last_step": False, "remaining_steps": 24},
                                                    "outputs": {
                                                        "output": {
                                                            "content": "",
                                                            "additional_kwargs": {
                                                                "tool_calls": [
                                                                    {
                                                                        "type": "function",
                                                                        "function": {
                                                                            "name": "mythologie_kb_search_iBN2ko",
                                                                            "arguments": '{"searchQuery":"Kitsune"}',
                                                                        },
                                                                        "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                        "index": 0,
                                                                    }
                                                                ]
                                                            },
                                                            "response_metadata": {
                                                                "type": "contentcontentcontentcontentcontentcontentcontentcontentcontentfooter",
                                                                "toolCalls": [
                                                                    {
                                                                        "type": "function",
                                                                        "function": {
                                                                            "name": "mythologie_kb_search_iBN2ko",
                                                                            "arguments": '{"searchQuery":"Kitsune"}',
                                                                        },
                                                                        "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                        "index": 0,
                                                                    }
                                                                ],
                                                                "eventData": {},
                                                                "finishReason": "tool_calls",
                                                                "promptTokens": 119,
                                                                "completionTokens": 25,
                                                                "totalTokens": 144,
                                                                "estimatedCost": 0.0005475,
                                                                "trace": {
                                                                    "type": "span",
                                                                    "begin": "2025-07-11T09:39:31.262Z",
                                                                    "end": "2025-07-11T09:39:32.520Z",
                                                                    "duration": 1258,
                                                                    "name": "DKU_LLM_MESH_COMPLETION_QUERY_STREAMED",
                                                                    "children": [
                                                                        {
                                                                            "type": "span",
                                                                            "begin": "2025-07-11T09:39:31.263Z",
                                                                            "end": "2025-07-11T09:39:31.263Z",
                                                                            "duration": 0,
                                                                            "name": "DKU_LLM_MESH_QUERY_ENFORCEMENT",
                                                                            "children": [],
                                                                            "attributes": {},
                                                                        },
                                                                        {
                                                                            "type": "span",
                                                                            "begin": "2025-07-11T09:39:31.263Z",
                                                                            "end": "2025-07-11T09:39:32.520Z",
                                                                            "duration": 1257,
                                                                            "usageMetadata": {
                                                                                "promptTokens": 119,
                                                                                "completionTokens": 25,
                                                                                "totalTokens": 144,
                                                                                "estimatedCost": 0.0005475,
                                                                            },
                                                                            "name": "DKU_LLM_MESH_LLM_CALL_STREAMED",
                                                                            "children": [
                                                                                {
                                                                                    "type": "event",
                                                                                    "timestamp": "2025-07-11T09:39:32.360Z",
                                                                                    "name": "DKU_LLM_MESH_LLM_CALL_STREAMED_FIRST_CHUNK",
                                                                                    "children": [],
                                                                                    "attributes": {},
                                                                                },
                                                                                {
                                                                                    "type": "event",
                                                                                    "timestamp": "2025-07-11T09:39:32.519Z",
                                                                                    "name": "DKU_LLM_MESH_LLM_CALL_STREAMED_STREAM_COMPLETE",
                                                                                    "children": [],
                                                                                    "attributes": {},
                                                                                },
                                                                            ],
                                                                            "attributes": {
                                                                                "llmId": "openai:bs-openai:gpt-4o",
                                                                                "llmProvider": "OPENAI",
                                                                                "llmModel": "gpt-4o",
                                                                                "completionQuery": {
                                                                                    "messages": [
                                                                                        {
                                                                                            "role": "system",
                                                                                            "content": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                                        },
                                                                                        {
                                                                                            "role": "user",
                                                                                            "content": "What do you know about Kitsune ?",
                                                                                        },
                                                                                    ]
                                                                                },
                                                                                "completionQuerySettings": {
                                                                                    "stopSequences": [],
                                                                                    "tools": [
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "name": "mythologie_kb_search_iBN2ko",
                                                                                                "description": "Searches for relevant documents in the knowledge bank (vector store) fake_mythologie_db_embedded\n\nThis knowledge bank contains informations about mythology facts\n\nTool to search into a mythology knowledge bank",
                                                                                                "parameters": {
                                                                                                    "$schema": "https://json-schema.org/draft/2020-12/schema",
                                                                                                    "$id": "https://dataiku.com/agents/tools/knowledge-banks/lookup/input",
                                                                                                    "type": "object",
                                                                                                    "properties": {
                                                                                                        "searchQuery": {
                                                                                                            "type": "string",
                                                                                                            "description": "The search query in the knowledge bank / vector store",
                                                                                                        }
                                                                                                    },
                                                                                                },
                                                                                            },
                                                                                        }
                                                                                    ],
                                                                                },
                                                                                "completionResponse": {
                                                                                    "ok": False,
                                                                                    "text": "",
                                                                                    "finishReason": "unknown",
                                                                                    "toolCalls": [
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "name": "mythologie_kb_search_iBN2ko",
                                                                                                "arguments": "",
                                                                                            },
                                                                                            "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": '{"'
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": "search"
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": "Query"
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": '":"'
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": "K"
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": "its"
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": "une"
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "arguments": '"}'
                                                                                            },
                                                                                            "index": 0,
                                                                                        },
                                                                                    ],
                                                                                    "predictedClassProbas": [],
                                                                                    "fromCache": False,
                                                                                },
                                                                            },
                                                                            "inputs": {
                                                                                "messages": [
                                                                                    {
                                                                                        "role": "system",
                                                                                        "text": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                                    },
                                                                                    {
                                                                                        "role": "user",
                                                                                        "text": "What do you know about Kitsune ?",
                                                                                    },
                                                                                ]
                                                                            },
                                                                            "outputs": {
                                                                                "toolCalls": [
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "name": "mythologie_kb_search_iBN2ko",
                                                                                            "arguments": "",
                                                                                        },
                                                                                        "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": '{"'
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": "search"
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": "Query"
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": '":"'
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": "K"
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": "its"
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": "une"
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "arguments": '"}'
                                                                                        },
                                                                                        "index": 0,
                                                                                    },
                                                                                ]
                                                                            },
                                                                        },
                                                                    ],
                                                                    "attributes": {
                                                                        "llmId": "openai:bs-openai:gpt-4o",
                                                                        "llmProvider": "OPENAI",
                                                                        "llmModel": "gpt-4o",
                                                                        "completionQuery": {
                                                                            "messages": [
                                                                                {
                                                                                    "role": "system",
                                                                                    "content": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                                },
                                                                                {
                                                                                    "role": "user",
                                                                                    "content": "What do you know about Kitsune ?",
                                                                                },
                                                                            ]
                                                                        },
                                                                        "completionQuerySettings": {
                                                                            "stopSequences": [],
                                                                            "tools": [
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "name": "mythologie_kb_search_iBN2ko",
                                                                                        "description": "Searches for relevant documents in the knowledge bank (vector store) fake_mythologie_db_embedded\n\nThis knowledge bank contains informations about mythology facts\n\nTool to search into a mythology knowledge bank",
                                                                                        "parameters": {
                                                                                            "$schema": "https://json-schema.org/draft/2020-12/schema",
                                                                                            "$id": "https://dataiku.com/agents/tools/knowledge-banks/lookup/input",
                                                                                            "type": "object",
                                                                                            "properties": {
                                                                                                "searchQuery": {
                                                                                                    "type": "string",
                                                                                                    "description": "The search query in the knowledge bank / vector store",
                                                                                                }
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                }
                                                                            ],
                                                                        },
                                                                        "completionResponse": {
                                                                            "ok": False,
                                                                            "text": "",
                                                                            "finishReason": "unknown",
                                                                            "toolCalls": [
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "name": "mythologie_kb_search_iBN2ko",
                                                                                        "arguments": "",
                                                                                    },
                                                                                    "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": '{"'
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": "search"
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": "Query"
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": '":"'
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": "K"
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": "its"
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": "une"
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "arguments": '"}'
                                                                                    },
                                                                                    "index": 0,
                                                                                },
                                                                            ],
                                                                            "predictedClassProbas": [],
                                                                            "fromCache": False,
                                                                        },
                                                                    },
                                                                    "inputs": {
                                                                        "messages": [
                                                                            {
                                                                                "role": "system",
                                                                                "text": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                            },
                                                                            {
                                                                                "role": "user",
                                                                                "text": "What do you know about Kitsune ?",
                                                                            },
                                                                        ]
                                                                    },
                                                                    "outputs": {
                                                                        "toolCalls": [
                                                                            {
                                                                                "type": "function",
                                                                                "function": {
                                                                                    "name": "mythologie_kb_search_iBN2ko",
                                                                                    "arguments": "",
                                                                                },
                                                                                "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {"arguments": '{"'},
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {
                                                                                    "arguments": "search"
                                                                                },
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {
                                                                                    "arguments": "Query"
                                                                                },
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {
                                                                                    "arguments": '":"'
                                                                                },
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {"arguments": "K"},
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {
                                                                                    "arguments": "its"
                                                                                },
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {
                                                                                    "arguments": "une"
                                                                                },
                                                                                "index": 0,
                                                                            },
                                                                            {
                                                                                "type": "function",
                                                                                "function": {"arguments": '"}'},
                                                                                "index": 0,
                                                                            },
                                                                        ]
                                                                    },
                                                                },
                                                            },
                                                            "type": "ai",
                                                            "id": "run-4e8debf3-67db-4681-81e8-28e830322eaa",
                                                            "example": False,
                                                            "tool_calls": [
                                                                {
                                                                    "name": "mythologie_kb_search_iBN2ko",
                                                                    "args": {"searchQuery": "Kitsune"},
                                                                    "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                    "type": "tool_call",
                                                                }
                                                            ],
                                                            "invalid_tool_calls": [],
                                                        }
                                                    },
                                                },
                                                {
                                                    "type": "span",
                                                    "begin": "2025-07-11T09:39:32.557823Z",
                                                    "end": "2025-07-11T09:39:32.559619Z",
                                                    "duration": 1,
                                                    "name": "should_continue",
                                                    "children": [],
                                                    "attributes": {
                                                        "ls_run_id": "004a0855-b7f1-4357-8a07-302de1c6d273"
                                                    },
                                                    "inputs": {"is_last_step": False, "remaining_steps": 24},
                                                    "outputs": {"output": "tools"},
                                                },
                                            ],
                                            "attributes": {"ls_run_id": "53ef0c9b-2a74-45cc-a6e5-0383ae352496"},
                                            "inputs": {"is_last_step": False, "remaining_steps": 24},
                                            "outputs": {},
                                        },
                                        {
                                            "type": "span",
                                            "begin": "2025-07-11T09:39:32.564169Z",
                                            "end": "2025-07-11T09:39:35.489639Z",
                                            "duration": 2925,
                                            "name": "tools",
                                            "children": [
                                                {
                                                    "type": "span",
                                                    "begin": "2025-07-11T09:39:32.565000Z",
                                                    "end": "2025-07-11T09:39:35.488000Z",
                                                    "duration": 2923,
                                                    "name": "tu_toolcall",
                                                    "children": [],
                                                    "attributes": {
                                                        "tu_toolcall_sources": [
                                                            {
                                                                "toolCallDescription": "Searched Knowledge Bank fake_mythologie_db_embedded for 'Kitsune'",
                                                                "items": [
                                                                    {
                                                                        "type": "SIMPLE_DOCUMENT",
                                                                        "metadata": {},
                                                                        "title": "Kitsune: The Fox Spirits of Japan",
                                                                        "url": "https://example.com/kitsune",
                                                                        "textSnippet": "Kitsune: The Fox Spirits of Japan",
                                                                    },
                                                                    {
                                                                        "type": "SIMPLE_DOCUMENT",
                                                                        "metadata": {},
                                                                        "title": "The Tengu: The Heavenly Dog of Japan",
                                                                        "url": "https://example.com/tengu",
                                                                        "textSnippet": "The Tengu: The Heavenly Dog of Japan",
                                                                    },
                                                                    {
                                                                        "type": "SIMPLE_DOCUMENT",
                                                                        "metadata": {},
                                                                        "title": "The Kappa: The River Child of Japan",
                                                                        "url": "https://example.com/kappa",
                                                                        "textSnippet": "The Kappa: The River Child of Japan",
                                                                    },
                                                                    {
                                                                        "type": "SIMPLE_DOCUMENT",
                                                                        "metadata": {},
                                                                        "title": "The Kamaitachi: The Weasel Sickle",
                                                                        "url": "https://example.com/kamaitachi",
                                                                        "textSnippet": "The Kamaitachi: The Weasel Sickle",
                                                                    },
                                                                ],
                                                            }
                                                        ]
                                                    },
                                                    "inputs": {},
                                                    "outputs": {},
                                                },
                                                {
                                                    "type": "span",
                                                    "begin": "2025-07-11T09:39:32.565609Z",
                                                    "end": "2025-07-11T09:39:35.487817Z",
                                                    "duration": 2922,
                                                    "name": "mythologie_kb_search_iBN2ko",
                                                    "children": [
                                                        {
                                                            "type": "span",
                                                            "begin": "2025-07-11T09:39:32.566000Z",
                                                            "end": "2025-07-11T09:39:35.487000Z",
                                                            "duration": 2921,
                                                            "name": "DKUStructuredTool",
                                                            "children": [
                                                                {
                                                                    "type": "span",
                                                                    "begin": "2025-07-11T09:39:32.575Z",
                                                                    "end": "2025-07-11T09:39:35.486Z",
                                                                    "duration": 2911,
                                                                    "name": "DKU_MANAGED_TOOL_CALL",
                                                                    "children": [
                                                                        {
                                                                            "type": "span",
                                                                            "begin": "2025-07-11T09:39:35.036000Z",
                                                                            "end": "2025-07-11T09:39:35.483000Z",
                                                                            "duration": 447,
                                                                            "name": "DKU_VECTOR_STORE_SEARCH",
                                                                            "children": [
                                                                                {
                                                                                    "type": "span",
                                                                                    "begin": "2025-07-11T09:39:35.421000Z",
                                                                                    "end": "2025-07-11T09:39:35.433000Z",
                                                                                    "duration": 12,
                                                                                    "name": "DKUEmbeddings",
                                                                                    "children": [
                                                                                        {
                                                                                            "type": "span",
                                                                                            "begin": "2025-07-11T09:39:35.429Z",
                                                                                            "end": "2025-07-11T09:39:35.429Z",
                                                                                            "duration": 0,
                                                                                            "name": "DKU_LLM_MESH_EMBEDDING_QUERY",
                                                                                            "children": [
                                                                                                {
                                                                                                    "type": "span",
                                                                                                    "begin": "2025-07-11T09:39:35.429Z",
                                                                                                    "end": "2025-07-11T09:39:35.429Z",
                                                                                                    "duration": 0,
                                                                                                    "name": "DKU_LLM_MESH_QUERY_ENFORCEMENT",
                                                                                                    "children": [],
                                                                                                    "attributes": {},
                                                                                                },
                                                                                                {
                                                                                                    "type": "event",
                                                                                                    "timestamp": "2025-07-11T09:39:35.429Z",
                                                                                                    "name": "DKU_LLM_MESH_CACHE_HIT",
                                                                                                    "children": [],
                                                                                                    "attributes": {},
                                                                                                },
                                                                                            ],
                                                                                            "attributes": {
                                                                                                "llmId": "openai:bs-openai:text-embedding-3-small",
                                                                                                "llmProvider": "OPENAI",
                                                                                                "llmModel": "text-embedding-3-small",
                                                                                                "embeddingQuery": {
                                                                                                    "text": "Kitsune"
                                                                                                },
                                                                                                "embeddingQuerySettings": {
                                                                                                    "textOverflowMode": "FAIL"
                                                                                                },
                                                                                                "embeddingResponse": {
                                                                                                    "ok": True,
                                                                                                    "promptTokens": 3,
                                                                                                    "tokenCountsAreEstimated": False,
                                                                                                    "estimatedCost": 0,
                                                                                                },
                                                                                            },
                                                                                            "inputs": {
                                                                                                "text": "Kitsune"
                                                                                            },
                                                                                        }
                                                                                    ],
                                                                                    "attributes": {},
                                                                                    "inputs": {},
                                                                                    "outputs": {},
                                                                                }
                                                                            ],
                                                                            "attributes": {
                                                                                "nbRetrievedDocuments": 4
                                                                            },
                                                                            "inputs": {},
                                                                            "outputs": {},
                                                                        }
                                                                    ],
                                                                    "attributes": {
                                                                        "toolProjectKey": "ANSWERS",
                                                                        "toolId": "3hOtBAf",
                                                                        "toolType": "VectorStoreSearch",
                                                                    },
                                                                }
                                                            ],
                                                            "attributes": {},
                                                            "inputs": {},
                                                            "outputs": {},
                                                        }
                                                    ],
                                                    "attributes": {
                                                        "ls_run_id": "828bce00-87ff-4368-9008-8d41bcba71be"
                                                    },
                                                    "inputs": {"input": "{'searchQuery': 'Kitsune'}"},
                                                    "outputs": {
                                                        "output": {
                                                            "content": '{"documents": [{"text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kitsune", "Title": "Kitsune: The Fox Spirits of Japan"}}, {"text": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/tengu", "Title": "The Tengu: The Heavenly Dog of Japan"}}, {"text": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kappa", "Title": "The Kappa: The River Child of Japan"}}, {"text": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kamaitachi", "Title": "The Kamaitachi: The Weasel Sickle"}}]}',
                                                            "additional_kwargs": {},
                                                            "response_metadata": {},
                                                            "type": "tool",
                                                            "name": "mythologie_kb_search_iBN2ko",
                                                            "tool_call_id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                            "artifact": {
                                                                "sources": [
                                                                    {
                                                                        "toolCallDescription": "Searched Knowledge Bank fake_mythologie_db_embedded for 'Kitsune'",
                                                                        "items": [
                                                                            {
                                                                                "type": "SIMPLE_DOCUMENT",
                                                                                "metadata": {},
                                                                                "title": "Kitsune: The Fox Spirits of Japan",
                                                                                "url": "https://example.com/kitsune",
                                                                                "textSnippet": "Kitsune: The Fox Spirits of Japan",
                                                                            },
                                                                            {
                                                                                "type": "SIMPLE_DOCUMENT",
                                                                                "metadata": {},
                                                                                "title": "The Tengu: The Heavenly Dog of Japan",
                                                                                "url": "https://example.com/tengu",
                                                                                "textSnippet": "The Tengu: The Heavenly Dog of Japan",
                                                                            },
                                                                            {
                                                                                "type": "SIMPLE_DOCUMENT",
                                                                                "metadata": {},
                                                                                "title": "The Kappa: The River Child of Japan",
                                                                                "url": "https://example.com/kappa",
                                                                                "textSnippet": "The Kappa: The River Child of Japan",
                                                                            },
                                                                            {
                                                                                "type": "SIMPLE_DOCUMENT",
                                                                                "metadata": {},
                                                                                "title": "The Kamaitachi: The Weasel Sickle",
                                                                                "url": "https://example.com/kamaitachi",
                                                                                "textSnippet": "The Kamaitachi: The Weasel Sickle",
                                                                            },
                                                                        ],
                                                                    }
                                                                ]
                                                            },
                                                            "status": "success",
                                                        }
                                                    },
                                                },
                                            ],
                                            "attributes": {"ls_run_id": "c5ef731a-a854-4a75-861e-e00179b0a357"},
                                            "inputs": {"is_last_step": False, "remaining_steps": 23},
                                            "outputs": {},
                                        },
                                        {
                                            "type": "span",
                                            "begin": "2025-07-11T09:39:35.491640Z",
                                            "end": "2025-07-11T09:39:38.084668Z",
                                            "duration": 2593,
                                            "name": "agent",
                                            "children": [
                                                {
                                                    "type": "span",
                                                    "begin": "2025-07-11T09:39:35.492858Z",
                                                    "end": "2025-07-11T09:39:38.080310Z",
                                                    "duration": 2587,
                                                    "name": "call_model",
                                                    "children": [],
                                                    "attributes": {
                                                        "ls_run_id": "ed6a8e29-d391-4838-911f-f76d412c0281"
                                                    },
                                                    "inputs": {"is_last_step": False, "remaining_steps": 22},
                                                    "outputs": {},
                                                },
                                                {
                                                    "type": "span",
                                                    "begin": "2025-07-11T09:39:35.494200Z",
                                                    "end": "2025-07-11T09:39:38.077083Z",
                                                    "duration": 2582,
                                                    "name": "RunnableSequence",
                                                    "children": [
                                                        {
                                                            "type": "span",
                                                            "begin": "2025-07-11T09:39:35.495049Z",
                                                            "end": "2025-07-11T09:39:35.495696Z",
                                                            "duration": 0,
                                                            "name": "Prompt",
                                                            "children": [],
                                                            "attributes": {
                                                                "ls_run_id": "b1cc40a4-09e5-4a4d-95ae-7fa6a3c522d2"
                                                            },
                                                            "inputs": {
                                                                "is_last_step": False,
                                                                "remaining_steps": 22,
                                                            },
                                                            "outputs": {},
                                                        },
                                                        {
                                                            "type": "span",
                                                            "begin": "2025-07-11T09:39:35.496971Z",
                                                            "end": "2025-07-11T09:39:38.072930Z",
                                                            "duration": 2575,
                                                            "name": "DKUChatModel",
                                                            "children": [
                                                                {
                                                                    "type": "span",
                                                                    "begin": "2025-07-11T09:39:35.505Z",
                                                                    "end": "2025-07-11T09:39:38.058Z",
                                                                    "duration": 2553,
                                                                    "name": "DKU_LLM_MESH_COMPLETION_QUERY_STREAMED",
                                                                    "children": [
                                                                        {
                                                                            "type": "span",
                                                                            "begin": "2025-07-11T09:39:35.506Z",
                                                                            "end": "2025-07-11T09:39:35.506Z",
                                                                            "duration": 0,
                                                                            "name": "DKU_LLM_MESH_QUERY_ENFORCEMENT",
                                                                            "children": [],
                                                                            "attributes": {},
                                                                        },
                                                                        {
                                                                            "type": "span",
                                                                            "begin": "2025-07-11T09:39:35.506Z",
                                                                            "end": "2025-07-11T09:39:38.058Z",
                                                                            "duration": 2552,
                                                                            "usageMetadata": {
                                                                                "promptTokens": 469,
                                                                                "completionTokens": 107,
                                                                                "totalTokens": 576,
                                                                                "estimatedCost": 0.0022425,
                                                                            },
                                                                            "name": "DKU_LLM_MESH_LLM_CALL_STREAMED",
                                                                            "children": [
                                                                                {
                                                                                    "type": "event",
                                                                                    "timestamp": "2025-07-11T09:39:36.321Z",
                                                                                    "name": "DKU_LLM_MESH_LLM_CALL_STREAMED_FIRST_CHUNK",
                                                                                    "children": [],
                                                                                    "attributes": {},
                                                                                },
                                                                                {
                                                                                    "type": "event",
                                                                                    "timestamp": "2025-07-11T09:39:38.057Z",
                                                                                    "name": "DKU_LLM_MESH_LLM_CALL_STREAMED_STREAM_COMPLETE",
                                                                                    "children": [],
                                                                                    "attributes": {},
                                                                                },
                                                                            ],
                                                                            "attributes": {
                                                                                "llmId": "openai:bs-openai:gpt-4o",
                                                                                "llmProvider": "OPENAI",
                                                                                "llmModel": "gpt-4o",
                                                                                "completionQuery": {
                                                                                    "messages": [
                                                                                        {
                                                                                            "role": "system",
                                                                                            "content": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                                        },
                                                                                        {
                                                                                            "role": "user",
                                                                                            "content": "What do you know about Kitsune ?",
                                                                                        },
                                                                                        {
                                                                                            "role": "assistant",
                                                                                            "toolCalls": [
                                                                                                {
                                                                                                    "type": "function",
                                                                                                    "function": {
                                                                                                        "name": "mythologie_kb_search_iBN2ko",
                                                                                                        "arguments": '{"searchQuery": "Kitsune"}',
                                                                                                    },
                                                                                                    "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                                }
                                                                                            ],
                                                                                        },
                                                                                        {
                                                                                            "role": "tool",
                                                                                            "toolOutputs": [
                                                                                                {
                                                                                                    "callId": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                                    "output": '{"documents": [{"text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kitsune", "Title": "Kitsune: The Fox Spirits of Japan"}}, {"text": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/tengu", "Title": "The Tengu: The Heavenly Dog of Japan"}}, {"text": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kappa", "Title": "The Kappa: The River Child of Japan"}}, {"text": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kamaitachi", "Title": "The Kamaitachi: The Weasel Sickle"}}]}',
                                                                                                }
                                                                                            ],
                                                                                        },
                                                                                    ]
                                                                                },
                                                                                "completionQuerySettings": {
                                                                                    "stopSequences": [],
                                                                                    "tools": [
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "name": "mythologie_kb_search_iBN2ko",
                                                                                                "description": "Searches for relevant documents in the knowledge bank (vector store) fake_mythologie_db_embedded\n\nThis knowledge bank contains informations about mythology facts\n\nTool to search into a mythology knowledge bank",
                                                                                                "parameters": {
                                                                                                    "$schema": "https://json-schema.org/draft/2020-12/schema",
                                                                                                    "$id": "https://dataiku.com/agents/tools/knowledge-banks/lookup/input",
                                                                                                    "type": "object",
                                                                                                    "properties": {
                                                                                                        "searchQuery": {
                                                                                                            "type": "string",
                                                                                                            "description": "The search query in the knowledge bank / vector store",
                                                                                                        }
                                                                                                    },
                                                                                                },
                                                                                            },
                                                                                        }
                                                                                    ],
                                                                                },
                                                                                "completionResponse": {
                                                                                    "ok": False,
                                                                                    "text": "Kitsune are intelligent foxes in Japanese folklore known for their ability to shape-shift into humans. They are depicted as both protectors and tricksters. These mythical creatures are part of the rich tapestry of Japanese folklore, embodying both benevolent and mischievous traits.\n\nFor more information, you can refer to the source: [Kitsune: The Fox Spirits of Japan](https://example.com/kitsune).\n\nIf you want to know more or explore other related entities in Japanese folklore, feel free to ask!",
                                                                                    "finishReason": "unknown",
                                                                                    "toolCalls": [],
                                                                                    "predictedClassProbas": [],
                                                                                    "fromCache": False,
                                                                                },
                                                                            },
                                                                            "inputs": {
                                                                                "messages": [
                                                                                    {
                                                                                        "role": "system",
                                                                                        "text": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                                    },
                                                                                    {
                                                                                        "role": "user",
                                                                                        "text": "What do you know about Kitsune ?",
                                                                                    },
                                                                                    {
                                                                                        "role": "assistant",
                                                                                        "toolCalls": [
                                                                                            {
                                                                                                "type": "function",
                                                                                                "function": {
                                                                                                    "name": "mythologie_kb_search_iBN2ko",
                                                                                                    "arguments": '{"searchQuery": "Kitsune"}',
                                                                                                },
                                                                                                "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                            }
                                                                                        ],
                                                                                    },
                                                                                    {
                                                                                        "role": "tool",
                                                                                        "toolOutputs": [
                                                                                            {
                                                                                                "callId": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                                "output": '{"documents": [{"text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kitsune", "Title": "Kitsune: The Fox Spirits of Japan"}}, {"text": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/tengu", "Title": "The Tengu: The Heavenly Dog of Japan"}}, {"text": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kappa", "Title": "The Kappa: The River Child of Japan"}}, {"text": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kamaitachi", "Title": "The Kamaitachi: The Weasel Sickle"}}]}',
                                                                                            }
                                                                                        ],
                                                                                    },
                                                                                ]
                                                                            },
                                                                            "outputs": {
                                                                                "text": "Kitsune are intelligent foxes in Japanese folklore known for their ability to shape-shift into humans. They are depicted as both protectors and tricksters. These mythical creatures are part of the rich tapestry of Japanese folklore, embodying both benevolent and mischievous traits.\n\nFor more information, you can refer to the source: [Kitsune: The Fox Spirits of Japan](https://example.com/kitsune).\n\nIf you want to know more or explore other related entities in Japanese folklore, feel free to ask!"
                                                                            },
                                                                        },
                                                                    ],
                                                                    "attributes": {
                                                                        "llmId": "openai:bs-openai:gpt-4o",
                                                                        "llmProvider": "OPENAI",
                                                                        "llmModel": "gpt-4o",
                                                                        "completionQuery": {
                                                                            "messages": [
                                                                                {
                                                                                    "role": "system",
                                                                                    "content": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                                },
                                                                                {
                                                                                    "role": "user",
                                                                                    "content": "What do you know about Kitsune ?",
                                                                                },
                                                                                {
                                                                                    "role": "assistant",
                                                                                    "toolCalls": [
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "name": "mythologie_kb_search_iBN2ko",
                                                                                                "arguments": '{"searchQuery": "Kitsune"}',
                                                                                            },
                                                                                            "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                        }
                                                                                    ],
                                                                                },
                                                                                {
                                                                                    "role": "tool",
                                                                                    "toolOutputs": [
                                                                                        {
                                                                                            "callId": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                            "output": '{"documents": [{"text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kitsune", "Title": "Kitsune: The Fox Spirits of Japan"}}, {"text": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/tengu", "Title": "The Tengu: The Heavenly Dog of Japan"}}, {"text": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kappa", "Title": "The Kappa: The River Child of Japan"}}, {"text": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kamaitachi", "Title": "The Kamaitachi: The Weasel Sickle"}}]}',
                                                                                        }
                                                                                    ],
                                                                                },
                                                                            ]
                                                                        },
                                                                        "completionQuerySettings": {
                                                                            "stopSequences": [],
                                                                            "tools": [
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "name": "mythologie_kb_search_iBN2ko",
                                                                                        "description": "Searches for relevant documents in the knowledge bank (vector store) fake_mythologie_db_embedded\n\nThis knowledge bank contains informations about mythology facts\n\nTool to search into a mythology knowledge bank",
                                                                                        "parameters": {
                                                                                            "$schema": "https://json-schema.org/draft/2020-12/schema",
                                                                                            "$id": "https://dataiku.com/agents/tools/knowledge-banks/lookup/input",
                                                                                            "type": "object",
                                                                                            "properties": {
                                                                                                "searchQuery": {
                                                                                                    "type": "string",
                                                                                                    "description": "The search query in the knowledge bank / vector store",
                                                                                                }
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                }
                                                                            ],
                                                                        },
                                                                        "completionResponse": {
                                                                            "ok": False,
                                                                            "text": "Kitsune are intelligent foxes in Japanese folklore known for their ability to shape-shift into humans. They are depicted as both protectors and tricksters. These mythical creatures are part of the rich tapestry of Japanese folklore, embodying both benevolent and mischievous traits.\n\nFor more information, you can refer to the source: [Kitsune: The Fox Spirits of Japan](https://example.com/kitsune).\n\nIf you want to know more or explore other related entities in Japanese folklore, feel free to ask!",
                                                                            "finishReason": "unknown",
                                                                            "toolCalls": [],
                                                                            "predictedClassProbas": [],
                                                                            "fromCache": False,
                                                                        },
                                                                    },
                                                                    "inputs": {
                                                                        "messages": [
                                                                            {
                                                                                "role": "system",
                                                                                "text": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                            },
                                                                            {
                                                                                "role": "user",
                                                                                "text": "What do you know about Kitsune ?",
                                                                            },
                                                                            {
                                                                                "role": "assistant",
                                                                                "toolCalls": [
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "name": "mythologie_kb_search_iBN2ko",
                                                                                            "arguments": '{"searchQuery": "Kitsune"}',
                                                                                        },
                                                                                        "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                    }
                                                                                ],
                                                                            },
                                                                            {
                                                                                "role": "tool",
                                                                                "toolOutputs": [
                                                                                    {
                                                                                        "callId": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                        "output": '{"documents": [{"text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kitsune", "Title": "Kitsune: The Fox Spirits of Japan"}}, {"text": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/tengu", "Title": "The Tengu: The Heavenly Dog of Japan"}}, {"text": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kappa", "Title": "The Kappa: The River Child of Japan"}}, {"text": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kamaitachi", "Title": "The Kamaitachi: The Weasel Sickle"}}]}',
                                                                                    }
                                                                                ],
                                                                            },
                                                                        ]
                                                                    },
                                                                    "outputs": {
                                                                        "text": "Kitsune are intelligent foxes in Japanese folklore known for their ability to shape-shift into humans. They are depicted as both protectors and tricksters. These mythical creatures are part of the rich tapestry of Japanese folklore, embodying both benevolent and mischievous traits.\n\nFor more information, you can refer to the source: [Kitsune: The Fox Spirits of Japan](https://example.com/kitsune).\n\nIf you want to know more or explore other related entities in Japanese folklore, feel free to ask!"
                                                                    },
                                                                }
                                                            ],
                                                            "attributes": {
                                                                "ls_run_id": "7642daf8-4ccf-4d1d-95d4-c30cb9f2e2e4"
                                                            },
                                                            "inputs": {},
                                                            "outputs": {"type": "LLMResult"},
                                                        },
                                                    ],
                                                    "attributes": {
                                                        "ls_run_id": "67ac7f15-360a-439a-bfe9-8b3b83fc38d4"
                                                    },
                                                    "inputs": {"is_last_step": False, "remaining_steps": 22},
                                                    "outputs": {
                                                        "output": {
                                                            "content": "Kitsune are intelligent foxes in Japanese folklore known for their ability to shape-shift into humans. They are depicted as both protectors and tricksters. These mythical creatures are part of the rich tapestry of Japanese folklore, embodying both benevolent and mischievous traits.\n\nFor more information, you can refer to the source: [Kitsune: The Fox Spirits of Japan](https://example.com/kitsune).\n\nIf you want to know more or explore other related entities in Japanese folklore, feel free to ask!",
                                                            "additional_kwargs": {},
                                                            "response_metadata": {
                                                                "type": "contentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentcontentfooter",
                                                                "text": "Kitsune are intelligent foxes in Japanese folklore known for their ability to shape-shift into humans. They are depicted as both protectors and tricksters. These mythical creatures are part of the rich tapestry of Japanese folklore, embodying both benevolent and mischievous traits.\n\nFor more information, you can refer to the source: [Kitsune: The Fox Spirits of Japan](https://example.com/kitsune).\n\nIf you want to know more or explore other related entities in Japanese folklore, feel free to ask!",
                                                                "eventData": {},
                                                                "finishReason": "stop",
                                                                "promptTokens": 469,
                                                                "completionTokens": 107,
                                                                "totalTokens": 576,
                                                                "estimatedCost": 0.0022425,
                                                                "trace": {
                                                                    "type": "span",
                                                                    "begin": "2025-07-11T09:39:35.505Z",
                                                                    "end": "2025-07-11T09:39:38.058Z",
                                                                    "duration": 2553,
                                                                    "name": "DKU_LLM_MESH_COMPLETION_QUERY_STREAMED",
                                                                    "children": [
                                                                        {
                                                                            "type": "span",
                                                                            "begin": "2025-07-11T09:39:35.506Z",
                                                                            "end": "2025-07-11T09:39:35.506Z",
                                                                            "duration": 0,
                                                                            "name": "DKU_LLM_MESH_QUERY_ENFORCEMENT",
                                                                            "children": [],
                                                                            "attributes": {},
                                                                        },
                                                                        {
                                                                            "type": "span",
                                                                            "begin": "2025-07-11T09:39:35.506Z",
                                                                            "end": "2025-07-11T09:39:38.058Z",
                                                                            "duration": 2552,
                                                                            "usageMetadata": {
                                                                                "promptTokens": 469,
                                                                                "completionTokens": 107,
                                                                                "totalTokens": 576,
                                                                                "estimatedCost": 0.0022425,
                                                                            },
                                                                            "name": "DKU_LLM_MESH_LLM_CALL_STREAMED",
                                                                            "children": [
                                                                                {
                                                                                    "type": "event",
                                                                                    "timestamp": "2025-07-11T09:39:36.321Z",
                                                                                    "name": "DKU_LLM_MESH_LLM_CALL_STREAMED_FIRST_CHUNK",
                                                                                    "children": [],
                                                                                    "attributes": {},
                                                                                },
                                                                                {
                                                                                    "type": "event",
                                                                                    "timestamp": "2025-07-11T09:39:38.057Z",
                                                                                    "name": "DKU_LLM_MESH_LLM_CALL_STREAMED_STREAM_COMPLETE",
                                                                                    "children": [],
                                                                                    "attributes": {},
                                                                                },
                                                                            ],
                                                                            "attributes": {
                                                                                "llmId": "openai:bs-openai:gpt-4o",
                                                                                "llmProvider": "OPENAI",
                                                                                "llmModel": "gpt-4o",
                                                                                "completionQuery": {
                                                                                    "messages": [
                                                                                        {
                                                                                            "role": "system",
                                                                                            "content": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                                        },
                                                                                        {
                                                                                            "role": "user",
                                                                                            "content": "What do you know about Kitsune ?",
                                                                                        },
                                                                                        {
                                                                                            "role": "assistant",
                                                                                            "toolCalls": [
                                                                                                {
                                                                                                    "type": "function",
                                                                                                    "function": {
                                                                                                        "name": "mythologie_kb_search_iBN2ko",
                                                                                                        "arguments": '{"searchQuery": "Kitsune"}',
                                                                                                    },
                                                                                                    "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                                }
                                                                                            ],
                                                                                        },
                                                                                        {
                                                                                            "role": "tool",
                                                                                            "toolOutputs": [
                                                                                                {
                                                                                                    "callId": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                                    "output": '{"documents": [{"text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kitsune", "Title": "Kitsune: The Fox Spirits of Japan"}}, {"text": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/tengu", "Title": "The Tengu: The Heavenly Dog of Japan"}}, {"text": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kappa", "Title": "The Kappa: The River Child of Japan"}}, {"text": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kamaitachi", "Title": "The Kamaitachi: The Weasel Sickle"}}]}',
                                                                                                }
                                                                                            ],
                                                                                        },
                                                                                    ]
                                                                                },
                                                                                "completionQuerySettings": {
                                                                                    "stopSequences": [],
                                                                                    "tools": [
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "name": "mythologie_kb_search_iBN2ko",
                                                                                                "description": "Searches for relevant documents in the knowledge bank (vector store) fake_mythologie_db_embedded\n\nThis knowledge bank contains informations about mythology facts\n\nTool to search into a mythology knowledge bank",
                                                                                                "parameters": {
                                                                                                    "$schema": "https://json-schema.org/draft/2020-12/schema",
                                                                                                    "$id": "https://dataiku.com/agents/tools/knowledge-banks/lookup/input",
                                                                                                    "type": "object",
                                                                                                    "properties": {
                                                                                                        "searchQuery": {
                                                                                                            "type": "string",
                                                                                                            "description": "The search query in the knowledge bank / vector store",
                                                                                                        }
                                                                                                    },
                                                                                                },
                                                                                            },
                                                                                        }
                                                                                    ],
                                                                                },
                                                                                "completionResponse": {
                                                                                    "ok": False,
                                                                                    "text": "Kitsune are intelligent foxes in Japanese folklore known for their ability to shape-shift into humans. They are depicted as both protectors and tricksters. These mythical creatures are part of the rich tapestry of Japanese folklore, embodying both benevolent and mischievous traits.\n\nFor more information, you can refer to the source: [Kitsune: The Fox Spirits of Japan](https://example.com/kitsune).\n\nIf you want to know more or explore other related entities in Japanese folklore, feel free to ask!",
                                                                                    "finishReason": "unknown",
                                                                                    "toolCalls": [],
                                                                                    "predictedClassProbas": [],
                                                                                    "fromCache": False,
                                                                                },
                                                                            },
                                                                            "inputs": {
                                                                                "messages": [
                                                                                    {
                                                                                        "role": "system",
                                                                                        "text": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                                    },
                                                                                    {
                                                                                        "role": "user",
                                                                                        "text": "What do you know about Kitsune ?",
                                                                                    },
                                                                                    {
                                                                                        "role": "assistant",
                                                                                        "toolCalls": [
                                                                                            {
                                                                                                "type": "function",
                                                                                                "function": {
                                                                                                    "name": "mythologie_kb_search_iBN2ko",
                                                                                                    "arguments": '{"searchQuery": "Kitsune"}',
                                                                                                },
                                                                                                "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                            }
                                                                                        ],
                                                                                    },
                                                                                    {
                                                                                        "role": "tool",
                                                                                        "toolOutputs": [
                                                                                            {
                                                                                                "callId": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                                "output": '{"documents": [{"text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kitsune", "Title": "Kitsune: The Fox Spirits of Japan"}}, {"text": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/tengu", "Title": "The Tengu: The Heavenly Dog of Japan"}}, {"text": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kappa", "Title": "The Kappa: The River Child of Japan"}}, {"text": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kamaitachi", "Title": "The Kamaitachi: The Weasel Sickle"}}]}',
                                                                                            }
                                                                                        ],
                                                                                    },
                                                                                ]
                                                                            },
                                                                            "outputs": {
                                                                                "text": "Kitsune are intelligent foxes in Japanese folklore known for their ability to shape-shift into humans. They are depicted as both protectors and tricksters. These mythical creatures are part of the rich tapestry of Japanese folklore, embodying both benevolent and mischievous traits.\n\nFor more information, you can refer to the source: [Kitsune: The Fox Spirits of Japan](https://example.com/kitsune).\n\nIf you want to know more or explore other related entities in Japanese folklore, feel free to ask!"
                                                                            },
                                                                        },
                                                                    ],
                                                                    "attributes": {
                                                                        "llmId": "openai:bs-openai:gpt-4o",
                                                                        "llmProvider": "OPENAI",
                                                                        "llmModel": "gpt-4o",
                                                                        "completionQuery": {
                                                                            "messages": [
                                                                                {
                                                                                    "role": "system",
                                                                                    "content": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                                },
                                                                                {
                                                                                    "role": "user",
                                                                                    "content": "What do you know about Kitsune ?",
                                                                                },
                                                                                {
                                                                                    "role": "assistant",
                                                                                    "toolCalls": [
                                                                                        {
                                                                                            "type": "function",
                                                                                            "function": {
                                                                                                "name": "mythologie_kb_search_iBN2ko",
                                                                                                "arguments": '{"searchQuery": "Kitsune"}',
                                                                                            },
                                                                                            "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                        }
                                                                                    ],
                                                                                },
                                                                                {
                                                                                    "role": "tool",
                                                                                    "toolOutputs": [
                                                                                        {
                                                                                            "callId": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                            "output": '{"documents": [{"text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kitsune", "Title": "Kitsune: The Fox Spirits of Japan"}}, {"text": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/tengu", "Title": "The Tengu: The Heavenly Dog of Japan"}}, {"text": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kappa", "Title": "The Kappa: The River Child of Japan"}}, {"text": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kamaitachi", "Title": "The Kamaitachi: The Weasel Sickle"}}]}',
                                                                                        }
                                                                                    ],
                                                                                },
                                                                            ]
                                                                        },
                                                                        "completionQuerySettings": {
                                                                            "stopSequences": [],
                                                                            "tools": [
                                                                                {
                                                                                    "type": "function",
                                                                                    "function": {
                                                                                        "name": "mythologie_kb_search_iBN2ko",
                                                                                        "description": "Searches for relevant documents in the knowledge bank (vector store) fake_mythologie_db_embedded\n\nThis knowledge bank contains informations about mythology facts\n\nTool to search into a mythology knowledge bank",
                                                                                        "parameters": {
                                                                                            "$schema": "https://json-schema.org/draft/2020-12/schema",
                                                                                            "$id": "https://dataiku.com/agents/tools/knowledge-banks/lookup/input",
                                                                                            "type": "object",
                                                                                            "properties": {
                                                                                                "searchQuery": {
                                                                                                    "type": "string",
                                                                                                    "description": "The search query in the knowledge bank / vector store",
                                                                                                }
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                }
                                                                            ],
                                                                        },
                                                                        "completionResponse": {
                                                                            "ok": False,
                                                                            "text": "Kitsune are intelligent foxes in Japanese folklore known for their ability to shape-shift into humans. They are depicted as both protectors and tricksters. These mythical creatures are part of the rich tapestry of Japanese folklore, embodying both benevolent and mischievous traits.\n\nFor more information, you can refer to the source: [Kitsune: The Fox Spirits of Japan](https://example.com/kitsune).\n\nIf you want to know more or explore other related entities in Japanese folklore, feel free to ask!",
                                                                            "finishReason": "unknown",
                                                                            "toolCalls": [],
                                                                            "predictedClassProbas": [],
                                                                            "fromCache": False,
                                                                        },
                                                                    },
                                                                    "inputs": {
                                                                        "messages": [
                                                                            {
                                                                                "role": "system",
                                                                                "text": "You're an helpful assistant which can query a knowledge bank about mythology facts",
                                                                            },
                                                                            {
                                                                                "role": "user",
                                                                                "text": "What do you know about Kitsune ?",
                                                                            },
                                                                            {
                                                                                "role": "assistant",
                                                                                "toolCalls": [
                                                                                    {
                                                                                        "type": "function",
                                                                                        "function": {
                                                                                            "name": "mythologie_kb_search_iBN2ko",
                                                                                            "arguments": '{"searchQuery": "Kitsune"}',
                                                                                        },
                                                                                        "id": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                    }
                                                                                ],
                                                                            },
                                                                            {
                                                                                "role": "tool",
                                                                                "toolOutputs": [
                                                                                    {
                                                                                        "callId": "call_EIOXajjb7sAlyd0vP0h7jYiU",
                                                                                        "output": '{"documents": [{"text": "Kitsune are intelligent foxes in Japanese folklore with the ability to shape-shift into humans. They are both protectors and tricksters.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kitsune", "Title": "Kitsune: The Fox Spirits of Japan"}}, {"text": "A type of legendary creature found in Japanese folk religion. They are traditionally depicted with both human and avian characteristics.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/tengu", "Title": "The Tengu: The Heavenly Dog of Japan"}}, {"text": "A yōkai demon or imp found in traditional Japanese folklore. They are typically depicted as green, human-like beings with webbed hands and feet and a turtle-like carapace on their backs.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kappa", "Title": "The Kappa: The River Child of Japan"}}, {"text": "A Japanese yōkai that appears as a trio of weasels, riding on a gust of wind to cut people with their sickle-like claws, causing a sharp but painless wound.", "metadata": {"Category": "Folklore Japonais", "Source": "https://example.com/kamaitachi", "Title": "The Kamaitachi: The Weasel Sickle"}}]}',
                                                                                    }
                                                                                ],
                                                                            },
                                                                        ]
                                                                    },
                                                                    "outputs": {
                                                                        "text": "Kitsune are intelligent foxes in Japanese folklore known for their ability to shape-shift into humans. They are depicted as both protectors and tricksters. These mythical creatures are part of the rich tapestry of Japanese folklore, embodying both benevolent and mischievous traits.\n\nFor more information, you can refer to the source: [Kitsune: The Fox Spirits of Japan](https://example.com/kitsune).\n\nIf you want to know more or explore other related entities in Japanese folklore, feel free to ask!"
                                                                    },
                                                                },
                                                            },
                                                            "type": "ai",
                                                            "id": "run-7642daf8-4ccf-4d1d-95d4-c30cb9f2e2e4",
                                                            "example": False,
                                                            "tool_calls": [],
                                                            "invalid_tool_calls": [],
                                                        }
                                                    },
                                                },
                                                {
                                                    "type": "span",
                                                    "begin": "2025-07-11T09:39:38.081532Z",
                                                    "end": "2025-07-11T09:39:38.083392Z",
                                                    "duration": 1,
                                                    "name": "should_continue",
                                                    "children": [],
                                                    "attributes": {
                                                        "ls_run_id": "1b79825c-e708-40bd-8578-dac86d461982"
                                                    },
                                                    "inputs": {"is_last_step": False, "remaining_steps": 22},
                                                    "outputs": {"output": "__end__"},
                                                },
                                            ],
                                            "attributes": {"ls_run_id": "61c9df6c-87af-4677-8cec-418dcb1a1bd5"},
                                            "inputs": {"is_last_step": False, "remaining_steps": 22},
                                            "outputs": {},
                                        },
                                    ],
                                    "attributes": {"ls_run_id": "5bb0ac44-35e6-4849-b870-2e9e7e7635b5"},
                                    "inputs": {},
                                    "outputs": {},
                                }
                            ],
                            "attributes": {},
                            "inputs": {},
                            "outputs": {},
                        }
                    ],
                    "attributes": {
                        "llmId": "agent:H1gENgDg",
                        "llmProvider": "SAVED_MODEL_AGENT",
                        "llmModel": "H1gENgDg:v1",
                        "completionQuery": {
                            "messages": [{"role": "user", "content": "What do you know about Kitsune ?"}]
                        },
                        "completionQuerySettings": {"stopSequences": []},
                        "completionResponse": {
                            "ok": True,
                            "text": "Kitsune are intelligent foxes in Japanese folklore known for their ability to shape-shift into humans. They are depicted as both protectors and tricksters. These mythical creatures are part of the rich tapestry of Japanese folklore, embodying both benevolent and mischievous traits.\n\nFor more information, you can refer to the source: [Kitsune: The Fox Spirits of Japan](https://example.com/kitsune).\n\nIf you want to know more or explore other related entities in Japanese folklore, feel free to ask!",
                            "finishReason": "unknown",
                            "predictedClassProbas": [],
                            "fromCache": False,
                            "additionalInformation": {
                                "sources": [
                                    {
                                        "toolCallDescription": "Searched Knowledge Bank fake_mythologie_db_embedded for 'Kitsune'",
                                        "items": [
                                            {
                                                "type": "SIMPLE_DOCUMENT",
                                                "metadata": {},
                                                "title": "Kitsune: The Fox Spirits of Japan",
                                                "url": "https://example.com/kitsune",
                                                "textSnippet": "Kitsune: The Fox Spirits of Japan",
                                            },
                                            {
                                                "type": "SIMPLE_DOCUMENT",
                                                "metadata": {},
                                                "title": "The Tengu: The Heavenly Dog of Japan",
                                                "url": "https://example.com/tengu",
                                                "textSnippet": "The Tengu: The Heavenly Dog of Japan",
                                            },
                                            {
                                                "type": "SIMPLE_DOCUMENT",
                                                "metadata": {},
                                                "title": "The Kappa: The River Child of Japan",
                                                "url": "https://example.com/kappa",
                                                "textSnippet": "The Kappa: The River Child of Japan",
                                            },
                                            {
                                                "type": "SIMPLE_DOCUMENT",
                                                "metadata": {},
                                                "title": "The Kamaitachi: The Weasel Sickle",
                                                "url": "https://example.com/kamaitachi",
                                                "textSnippet": "The Kamaitachi: The Weasel Sickle",
                                            },
                                        ],
                                    }
                                ]
                            },
                        },
                    },
                    "inputs": {"messages": [{"role": "user", "text": "What do you know about Kitsune ?"}]},
                    "outputs": {
                        "text": "Kitsune are intelligent foxes in Japanese folklore known for their ability to shape-shift into humans. They are depicted as both protectors and tricksters. These mythical creatures are part of the rich tapestry of Japanese folklore, embodying both benevolent and mischievous traits.\n\nFor more information, you can refer to the source: [Kitsune: The Fox Spirits of Japan](https://example.com/kitsune).\n\nIf you want to know more or explore other related entities in Japanese folklore, feel free to ask!"
                    },
                },
                {
                    "type": "span",
                    "begin": "2025-07-11T09:39:38.100Z",
                    "end": "2025-07-11T09:39:38.100Z",
                    "duration": 0,
                    "name": "DKU_LLM_MESH_RESPONSE_ENFORCEMENT",
                    "children": [],
                    "attributes": {},
                },
            ],
            "attributes": {
                "llmId": "agent:H1gENgDg",
                "llmProvider": "SAVED_MODEL_AGENT",
                "llmModel": "H1gENgDg:v1",
                "completionQuery": {
                    "messages": [{"role": "user", "content": "What do you know about Kitsune ?"}]
                },
                "completionQuerySettings": {"stopSequences": []},
                "completionResponse": {
                    "ok": True,
                    "text": "Kitsune are intelligent foxes in Japanese folklore known for their ability to shape-shift into humans. They are depicted as both protectors and tricksters. These mythical creatures are part of the rich tapestry of Japanese folklore, embodying both benevolent and mischievous traits.\n\nFor more information, you can refer to the source: [Kitsune: The Fox Spirits of Japan](https://example.com/kitsune).\n\nIf you want to know more or explore other related entities in Japanese folklore, feel free to ask!",
                    "finishReason": "unknown",
                    "predictedClassProbas": [],
                    "fromCache": False,
                    "additionalInformation": {
                        "sources": [
                            {
                                "toolCallDescription": "Searched Knowledge Bank fake_mythologie_db_embedded for 'Kitsune'",
                                "items": [
                                    {
                                        "type": "SIMPLE_DOCUMENT",
                                        "metadata": {},
                                        "title": "Kitsune: The Fox Spirits of Japan",
                                        "url": "https://example.com/kitsune",
                                        "textSnippet": "Kitsune: The Fox Spirits of Japan",
                                    },
                                    {
                                        "type": "SIMPLE_DOCUMENT",
                                        "metadata": {},
                                        "title": "The Tengu: The Heavenly Dog of Japan",
                                        "url": "https://example.com/tengu",
                                        "textSnippet": "The Tengu: The Heavenly Dog of Japan",
                                    },
                                    {
                                        "type": "SIMPLE_DOCUMENT",
                                        "metadata": {},
                                        "title": "The Kappa: The River Child of Japan",
                                        "url": "https://example.com/kappa",
                                        "textSnippet": "The Kappa: The River Child of Japan",
                                    },
                                    {
                                        "type": "SIMPLE_DOCUMENT",
                                        "metadata": {},
                                        "title": "The Kamaitachi: The Weasel Sickle",
                                        "url": "https://example.com/kamaitachi",
                                        "textSnippet": "The Kamaitachi: The Weasel Sickle",
                                    },
                                ],
                            }
                        ]
                    },
                },
            },
            "inputs": {"messages": [{"role": "user", "text": "What do you know about Kitsune ?"}]},
            "outputs": {
                "text": "Kitsune are intelligent foxes in Japanese folklore known for their ability to shape-shift into humans. They are depicted as both protectors and tricksters. These mythical creatures are part of the rich tapestry of Japanese folklore, embodying both benevolent and mischievous traits.\n\nFor more information, you can refer to the source: [Kitsune: The Fox Spirits of Japan](https://example.com/kitsune).\n\nIf you want to know more or explore other related entities in Japanese folklore, feel free to ask!"
            },
        },
    }
)

EXPECTED_AGENT_SOURCES = [
    {
        "toolCallDescription": "Searched Knowledge Bank fake_mythologie_db_embedded for 'Kitsune'",
        "items": [
            {
                "title": "Kitsune: The Fox Spirits of Japan",
                "type": "SIMPLE_DOCUMENT",
                "images": None,
                "textSnippet": "Kitsune: The Fox Spirits of Japan",
                "htmlSnippet": None,
                "markdownSnippet": None,
                "url": "https://example.com/kitsune",
                "metadata": {"tags": []},
            },
            {
                "title": "The Tengu: The Heavenly Dog of Japan",
                "type": "SIMPLE_DOCUMENT",
                "images": None,
                "textSnippet": "The Tengu: The Heavenly Dog of Japan",
                "htmlSnippet": None,
                "markdownSnippet": None,
                "url": "https://example.com/tengu",
                "metadata": {"tags": []},
            },
            {
                "title": "The Kappa: The River Child of Japan",
                "type": "SIMPLE_DOCUMENT",
                "images": None,
                "textSnippet": "The Kappa: The River Child of Japan",
                "htmlSnippet": None,
                "markdownSnippet": None,
                "url": "https://example.com/kappa",
                "metadata": {"tags": []},
            },
            {
                "title": "The Kamaitachi: The Weasel Sickle",
                "type": "SIMPLE_DOCUMENT",
                "images": None,
                "textSnippet": "The Kamaitachi: The Weasel Sickle",
                "htmlSnippet": None,
                "markdownSnippet": None,
                "url": "https://example.com/kamaitachi",
                "metadata": {"tags": []},
            },
        ],
    }
]