import { setCssVar } from 'quasar'
import './index.scss'
import { ServerApi } from './api/server_api'
import { WebSocketApi } from './api/websocket_api'
import { default as md5 } from './common/md5'
import AnswerCard from './components/AnswerCard/AnswerCard.vue'
import BsFileDropZone from './components/BsFileDropZone/BsFileDropZone.vue'
import BsFileUploader from './components/BsFileUploader/BsFileUploader.vue'
import BsWarning from './components/BsWarning/BsWarning.vue'
import ConversationCard from './components/ConversationCard/ConversationCard.vue'
import DataTable from './components/DataTable/DataTable.vue'
import DeleteDialog from './components/DeleteDialog/DeleteDialog.vue'
import DisclaimerSection from './components/DisclaimerSection/DisclaimerSection.vue'
import FeedbackProxyPopup from './components/FeedbackProxyPopup/FeedbackProxyPopup.vue'
import FilePreview from './components/FilePreview/FilePreview.vue'
import GeneralFeedback from './components/GeneralFeedback/GeneralFeedback.vue'
import IconButton from './components/IconButton/IconButton.vue'
import AddSquareIcon from './components/icons/AddSquareIcon.vue'
import HistoryIcon from './components/icons/HistoryIcon.vue'
import TrashIcon from './components/icons/TrashIcon.vue'
import InfoCard from './components/InfoCard/InfoCard.vue'
import QuestionCard from './components/QuestionCard/QuestionCard.vue'
import SettingsDialog from './components/SettingsDialog/SettingsDialog.vue'
import SettingsDialogHeader from './components/SettingsDialogHeader/SettingsDialogHeader.vue'
import SourcesContainer from './components/SourcesContainer/SourcesContainer.vue'
import SourceTags from './components/SourceTags/SourceTags.vue'
import SummaryCard from './components/SummaryCard/SummaryCard.vue'
import SummaryCarousel from './components/SummaryCarousel/SummaryCarousel.vue'
import TagsContainer from './components/TagsContainer/TagsContainer.vue'
import UserInput from './components/UserInput/UserInput.vue'
import UserProfile from './components/UserProfile/UserProfile.vue'
import UserSettings from './components/UserSettings/UserSettings.vue'
import { registerDirectives } from './directives/register'
import { loadPrismDependencies } from './prism-config'
import ConversationView from './routes/ConversationView.vue'
import EmptyStateView from './routes/EmptyStateView.vue'
import HomeView from './routes/HomeView.vue'
import PageNotFound from './routes/PageNotFound.vue'
import QuasarPlugin from './quasar-plugin'
import i18n from './i18n'
function inIframe() {
  try {
    return window.self !== window.top
  } catch (e) {
    return true
  }
}

export {
  BsFileDropZone,
  BsFileUploader,
  SourceTags,
  UserProfile,
  UserSettings,
  TagsContainer,
  AnswerCard,
  DataTable,
  FilePreview,
  InfoCard,
  UserInput,
  SummaryCard,
  ConversationCard,
  SettingsDialogHeader,
  SourcesContainer,
  BsWarning,
  FeedbackProxyPopup,
  IconButton,
  SummaryCarousel,
  SettingsDialog,
  QuestionCard,
  DisclaimerSection,
  GeneralFeedback,
  ConversationView,
  HomeView,
  EmptyStateView,
  PageNotFound,
  AddSquareIcon,
  HistoryIcon,
  TrashIcon,
  DeleteDialog,
  ServerApi,
  WebSocketApi,
  registerDirectives,
  inIframe,
  setCssVar,
  loadPrismDependencies,
  md5,
  QuasarPlugin,
  i18n
}
