import type { ConversationType, MediaSummary, QuestionData } from "../models"

export interface ConversationInfo {
    id: string;
    name: string;
    timestamp: number;
    selected?: boolean; //Used for UI purposes when creating a new conversation
}

export interface Conversation extends ConversationInfo {
    auth_identifier: string;
    conversation_type: ConversationType.GENERAL | ConversationType.MEDIA_QA;
    media_summaries: MediaSummary[] | null;
    data: QuestionData[];
}
