import {
  Quasar,
  Notify,
  ClosePopup,
  QIcon,
  QMenu,
  QList,
  QItemSection,
  QItem,
  Loading,
  Dialog,
  QInput,
  QCardSection,
  QBtn,
  QSeparator,
  QCard,
  QDialog,
  QCardActions,
  QSpinner,
  QCarouselSlide,
  QPopupProxy,
  QAvatar,
  QChip,
  QCarousel,
  QScrollArea,
  QImg,
  QExpansionItem,
  QCheckbox
} from 'quasar'
import { QuasarBs } from 'quasar-ui-bs'

export default {
  install(app) {
    // Register Quasar Base
    app.use(QuasarBs)

    // Use Quasar with plugins, components, and directives
    app.use(Quasar, {
      plugins: {
        Notify,
        Loading,
        Dialog
      },
      components: {
        QIcon,
        QMenu,
        QList,
        QItemSection,
        QItem,
        QInput,
        QCardSection,
        QBtn,
        QSeparator,
        QCardSection,
        QCard,
        QDialog,
        QCardActions,
        QSpinner,
        QCarouselSlide,
        QPopupProxy,
        QAvatar,
        QChip,
        QCarousel,
        QScrollArea,
        QImg,
        QExpansionItem,
        QCheckbox
      },
      directives: {
        ClosePopup
      }
    })
  }
}
