import { defineConfig } from "vite";
import vue from "@vitejs/plugin-vue";
import { fileURLToPath, URL } from "node:url";
import dotenv from "dotenv";

dotenv.config({ path: "../../.env" });

const clientPort = String(process.env["VITE_CLIENT_PORT"]);
const apiPort = String(process.env["VITE_API_PORT"]);

const basePath = process.env[`DKU_CODE_STUDIO_BROWSER_PATH_${clientPort}`]
  ? String(process.env[`DKU_CODE_STUDIO_BROWSER_PATH_${clientPort}`]) + "/"
  : "";

export default defineConfig({
  server: {
    host: "127.0.0.1",
    port: Number(clientPort),
    proxy: {
      "/api": {
        target: `http://127.0.0.1:${apiPort}`,
        changeOrigin: true,
        secure: false,
        rewrite: (path) => path.replace(/^\/api/, "/api"),
      },
    },
  },
  plugins: [vue()],
  base: basePath,
  resolve: {
    alias: {
      "@": fileURLToPath(new URL("./src", import.meta.url)),
    },
    dedupe: ['vue']
  },
  css: {
    preprocessorOptions: {
      scss: {
        additionalData: `@use "quasar/src/css/index.sass" as *;`,
        quietDeps: true,
        silenceDeprecations: ['legacy-js-api', 'slash-div']

      },
      sass: {
        quietDeps: true,
        silenceDeprecations: ['legacy-js-api', 'slash-div']
      },
    },
  },
  optimizeDeps: {
    include: ["dss-answers-ui-components"],
  },
  build: {
    outDir: "../dist",
    emptyOutDir: true,
    rollupOptions: {
      output: {
        entryFileNames: `assets/[name].js`,
        chunkFileNames: `assets/[name].js`,
        assetFileNames: `assets/[name].[ext]`,
      },
    },
    // watch: {
    //   exclude: "node_modules/**",
    // },
  },
});
