import { createI18n } from 'vue-i18n'

const messages = {
  en: {
    examples: 'Examples',
    backHome: 'Back to home',
    questionPlaceholder: 'Ask a question',
    clearHistory: 'Clear History',
    sources: 'Sources',
    error_message: 'Unexpected Error, please try again',
    error_answer: 'Error Occurred',
    new_chat: 'New Chat',
    tooltip_upload_files: 'Upload files',
    select_files: 'Click to select',
    files_and_images: 'files and images',
    max_number_of_files_reached:
      'File upload limit reached: Maximum number of {maxFilesAllowed} files allowed.',
    drop_zone: 'Drag & drop your files and images here or',
    supported_files: 'Supported files',
    duplicate_files: 'Duplicate files uploaded',
    delete_all: 'Delete All',
    cancel: 'CANCEL',
    delete: 'DELETE',
    delete_all_conv_title: 'Delete All',
    delete_all_conv_warning:
      "You are about to delete all the conversation history, you can't undo this action later.",
    delete_item_title: 'Delete Conversation',
    delete_item_warning:
      'You are about to delete the conversation "{title}", you can\'t undo this action later.',
    delete_item_success: 'Conversation deleted successfully',
    delete_items_success: 'All conversations are deleted successfully',
    copy_raw_value_success: 'Copied',
    copy_raw_value_fail: 'Copy Failed',
    feedback_btn_general: 'Share Your Thoughts',
    feedback_title_positive: 'How was your experience ?',
    feedback_title_negative: 'How was your experience ?',
    feedback_title_general: 'We value your feedback!',
    feedback_success_message: 'Feedback logged successfully',
    feedback_dialog_placeholder_positive:
      'What do you like about the response ?',
    feedback_dialog_placeholder_negative:
      'What was the issue ? How can it be improved ?',
    feedback_dialog_placeholder_general:
      "How was your experience ? Whether it's a compliment, a suggestion, or a concern, we want to hear it all!",
    feedback_input_placeholder: 'Tell us more',
    feedback_input_placeholder_general: 'Enter your feedback',
    submit: 'Submit',
    all_conversations: 'All Conversations',
    clear_history_dialog_title: 'Clear History',
    clear_history_dialog_text:
      "You are about to delete all the conversation history, you can't undo this action later.",
    unknown: 'unknown',
    copy_code: 'Copy code',
    settings: 'Settings',
    filters: 'Filters',
    use_knowledge_bank: 'Use knowledge bank',
    use_dataset: 'Use dataset',
    use: 'Use',
    tags: 'Tags',
    no_filters_text: 'Filters require a specified Knowledge Bank ID',
    empty_filters_text: 'No filters were setup.',
    select_label: 'Select {item}',
    close: 'Close',
    applied_filters: 'Applied Filters',
    see_more_filters: 'See {count} more filters',
    see_less_filters: 'Show less filters',
    apply: 'APPLY',
    upload_successful: 'File uploaded successfully',
    generic_upload_error: 'File upload failed',
    no_selected_file: 'No file selected',
    context_excursion:
      'The text is too long to process by the LLM. Please try again with a shorter text.',
    file_too_large: 'File is too large. Maximum size is {size}MB.',
    invalid_file_type: ' Invalid file type.',
    parsing_error: 'Unable to extract data from the file',
    too_many_files: 'You have exceeded the maximum number of files allowed. The limit is {maxNUploadFiles} files.',
    summary: 'Summary',
    key_topics: 'Key topics',
    file_delete_successful: 'File deleted successfully',
    file_delete_failed: 'Failed to delete file',
    tooltip_file: 'Upload a file or an image',
    tooltip_send: 'Send',
    tooltip_copy: 'Copy',
    tooltip_knowledge_bank: 'Using knowledge bank',
    tooltip_with_filters: 'with filters',
    tooltip_thumbs_up: 'Good response',
    tooltip_thumbs_down: 'Bad response',
    tooltip_close_filedropzone: 'Close file upload',
    answer_generated_with_kb: 'Answer generated based on the knowledge bank',
    answer_generated_with_db: 'Answer generated based on the database query',
    answer_generated_with_agents:
      'Answer generated based on the agents responses',
    answer_generated_without_retriever: 'Answer generated based on the LLM',
    sample: 'Data Sample',
    sql_query: 'SQL query:',
    analyzing_kb: 'Querying knowledge bank',
    analyzing_db: 'Querying database',
    analyzing_no_retriever: 'Querying LLM',
    calling_agent: 'Calling Agents',
    retrieving_agent: 'Retrieving Available agents',
    no_agent: 'No agent available',
    agent_available: 'Found agents',
    synthesizing_agents_answers: 'Synthesizing agents answers',
    calling_default_chain: 'Calling default chain',
    preparing_agent: 'Preparing agents',
    tool_call:'Tool Call',
    streaming: 'Querying LLM',
    streaming_end: 'Finalizing LLM query',
    generating_image: 'Generating Image',
    tooltip_download_image: 'Download Image',
    tooltip_download_images: 'Download all images',
    loading: 'Analyzing',
    logout: 'Logout',
    history: 'History',
    user_settings: 'User Settings',
    language: 'Language',
    update_user_profile_success: "User's profile updated successfully",
    update_user_profile_failure: "Failed to update user's profile",
    image_generation_settings: 'Image Generation Settings',
    height: 'Height',
    width: 'Width',
    quality: 'Quality',
    nbr_images_to_generate: 'Number of images',
    height_description: 'Height of the generated image in pixels',
    width_description: 'Width of the generated image in pixels',
    quality_description:
      'Quality of the generated image, higher quality will take longer to generate.',
    nbr_images_to_generate_description: 'Number of images to generate.',
    image_generation_settings_disclaimer:
      'Please note that image generation settings depend on the capabilities of the selected language model. Some settings may not be supported, which could lead to errors during image creation. For detailed information, please refer to the documentation of the specific model you are using.',
    image_generation_model: 'Image generation model',
    image_generation_model_tooltip:
      'The language model used for image generation',
    extracting_data: 'Extracting data...',
    max_images_per_week: 'Weekly image quota',
    max_images_per_week_tooltip:
      'The number of images that you can generate per week until next reset',
    images_left_of: 'images left of',
    days: 'd',
    hours: 'h'
  },
  fr: {
    examples: 'Exemples',
    backHome: 'Retour à l’accueil',
    questionPlaceholder: 'Poser une question',
    clearHistory: 'Effacer l’historique',
    sources: 'Sources',
    error_message: 'Erreur inattendue, veuillez réessayer',
    error_answer: 'Erreur survenue',
    new_chat: 'Nouvelle conversation',
    tooltip_upload_files: 'Télécharger des fichiers',
    select_files: 'Cliquez pour sélectionner',
    files_and_images: 'fichiers et images',
    max_number_of_files_reached:
      'Limite d’envoi atteinte : Maximum de {maxFilesAllowed} fichiers autorisés.',
    drop_zone: 'Glissez-déposez vos fichiers et images ici ou',
    supported_files: 'Fichiers pris en charge',
    duplicate_files: 'Fichiers téléchargés en double',
    delete_all: 'Tout supprimer',
    cancel: 'ANNULER',
    delete: 'SUPPRIMER',
    delete_all_conv_title: 'Tout supprimer',
    delete_all_conv_warning:
      'Vous êtes sur le point de supprimer tout l’historique, vous ne pourrez pas annuler cette action plus tard.',
    delete_item_title: 'Supprimer la conversation',
    delete_item_warning:
      'Vous êtes sur le point de supprimer la conversation "{title}", vous ne pourrez pas annuler cette action plus tard.',
    delete_item_success: 'Conversation supprimée avec succès',
    delete_items_success:
      'Toutes les conversations ont été supprimées avec succès',
    copy_raw_value_success: 'Copié',
    copy_raw_value_fail: 'Échec lors la copie',
    feedback_btn_general: 'Partagez votre avis',
    feedback_title_positive: 'Comment avez-vous trouvé votre expérience ?',
    feedback_title_negative: 'Comment avez-vous trouvé votre expérience ?',
    feedback_title_general: 'Nous apprécions vos commentaires !',
    feedback_success_message: 'Retour enregistré avec succès',
    feedback_dialog_placeholder_positive:
      'Qu’avez-vous apprécié dans la réponse ?',
    feedback_dialog_placeholder_negative:
      'Quel était le problème ? Comment cela peut-il être amélioré ?',
    feedback_dialog_placeholder_general:
      'Comment avez-vous trouvé votre expérience ? Que ce soit un compliment, une suggestion, ou une préoccupation, nous voulons tout entendre !',
    feedback_input_placeholder: 'Dites-nous en plus',
    feedback_input_placeholder_general: 'Partagez votre avis',
    submit: 'Envoyer',
    all_conversations: 'Toutes les conversations',
    clear_history_dialog_title: 'Effacer l’historique',
    clear_history_dialog_text:
      'Vous êtes sur le point de supprimer tout l’historique, vous ne pourrez pas annuler cette action plus tard.',
    unknown: 'inconnu',
    copy_code: 'Copier le code',
    settings: 'Paramètres',
    filters: 'Filtres',
    use_knowledge_bank: 'Utiliser la banque de connaissances',
    use_dataset: 'Utiliser la base de données',
    use: 'Utiliser',
    tags: 'Étiquettes',
    no_filters_text:
      'Les filtres nécessitent une ID de banque de connaissances spécifiée',
    empty_filters_text: 'Aucun filtre n’a été configuré.',
    select_label: 'Sélectionnez {item}',
    close: 'Fermer',
    applied_filters: 'Filtres appliqués',
    see_more_filters: 'Voir {count} filtres supplémentaires',
    see_less_filters: 'Montrer moins de filtres',
    apply: 'APPLIQUER',
    upload_successful: 'Fichier téléchargé avec succès',
    generic_upload_error: 'Échec du téléchargement du fichier',
    no_selected_file: 'Aucun fichier sélectionné',
    context_excursion:
      'Le texte est trop long pour être traité par le LLM. Veuillez réessayer avec un texte plus court.',
    file_too_large:
      'Le fichier est trop volumineux. La taille maximale est {size}MB.',
    invalid_file_type: ' Type de fichier non valide.',
    parsing_error: "Impossible d'extraire les données du fichier",
    too_many_files: 'Vous avez dépassé le nombre maximal de fichiers autorisés. La limite est de {maxNUploadFiles} fichiers.',
    summary: 'Résumé',
    key_topics: 'Sujets clés',
    file_delete_successful: 'Fichier supprimé avec succès',
    file_delete_failed: 'Échec de la suppression du fichier',
    tooltip_file: 'Ajouter un fichier ou une image',
    tooltip_send: 'Envoyer',
    tooltip_copy: 'Copier',
    tooltip_knowledge_bank: 'En utilisant la banque de connaissances',
    tooltip_with_filters: 'avec filtres',
    tooltip_thumbs_up: 'Bonne réponse',
    tooltip_thumbs_down: 'Mauvaise réponse',
    tooltip_close_filedropzone: 'Fermer l’ajout de fichier',
    answer_generated_with_kb:
      'Réponse générée basée sur la banque de connaissances',
    answer_generated_with_db:
      'Réponse générée basée sur la requête de la base de données',
    answer_generated_with_agents:
      'Réponse générée basée sur les réponses des agents',
    answer_generated_without_retriever: 'Réponse générée basée sur le LLM',
    sample: 'Échantillon de données',
    sql_query: 'Requête SQL :',
    analyzing_kb: 'Requête à la banque de connaissances',
    analyzing_db: 'Requête à la base de données',
    analyzing_no_retriever: 'Requête au LLM',
    calling_agent: 'Appel des agents',
    retrieving_agent: 'Récupération des agents disponibles',
    no_agent: 'Aucun agent disponible',
    agent_available: 'Agents trouvés',
    synthesizing_agents_answers: 'Synthèse des réponses des agents',
    calling_default_chain: 'Appel de la chaîne par défaut',
    preparing_agent: 'Préparation des agents',
    tool_call:'Appel d’outil',
    streaming: 'Requête au LLM',
    streaming_end: 'Finalisation de la requête au LLM',
    generating_image: 'Génération d’image',
    tooltip_download_image: 'Télécharger l’image',
    tooltip_download_images: 'Télécharger toutes les images',
    loading: 'Analyse en cours',
    logout: 'Déconnexion',
    history: 'Historique',
    user_settings: 'Paramètres utilisateur',
    language: 'langage',
    update_user_profile_success:
      "Profil de l'utilisateur mis à jour avec succès",
    update_user_profile_failure:
      "Échec de la mise à jour du profil de l'utilisateur",
    image_generation_settings: 'Paramètres de génération d’image',
    height: 'Hauteur',
    width: 'Largeur',
    quality: 'Qualité',
    nbr_images_to_generate: 'Nombre d’images',
    height_description: 'Hauteur de l’image générée en pixels',
    width_description: 'Largeur de l’image générée en pixels',
    quality_description:
      'Qualité de l’image générée, une qualité plus élevée nécessitera plus de temps de génération.',
    nbr_images_to_generate_description: 'Nombre d’images à générer.',
    image_generation_settings_disclaimer:
      "Veuillez noter que les paramètres de génération d’images dépendent des capacités du modèle de langage sélectionné. Certains paramètres peuvent ne pas être pris en charge, ce qui pourrait entraîner des erreurs lors de la création de l'image. Pour des informations détaillées, veuillez vous référer à la documentation du modèle spécifique que vous utilisez.",
    image_generation_model: 'Modèle de génération d’image',
    image_generation_model_tooltip:
      'Le modèle de langage utilisé pour la génération d’image',
    extracting_data: 'Extraction des données...',
    max_images_per_week: "Quota d'images hebdomadaire",
    max_images_per_week_tooltip:
      "Nombre d'images que vous pouvez générer par semaine jusqu'à la prochaine réinitialisation",
    images_left_of: 'images restantes sur',
    days: 'j',
    hours: 'h'
  },
  es: {
    examples: 'Ejemplos',
    backHome: 'Volver a inicio',
    questionPlaceholder: 'Haz una pregunta',
    clearHistory: 'Borrar Historial',
    sources: 'Fuentes',
    error_message: 'Error inesperado, por favor inténtalo de nuevo',
    error_answer: 'Ocurrió un error',
    new_chat: 'Nueva Conversación',
    tooltip_upload_files: 'Subir archivos',
    select_files: 'Haz clic para seleccionar',
    files_and_images: 'archivos e imágenes',
    max_number_of_files_reached:
      'Límite de subida alcanzado: Máximo de {maxFilesAllowed} archivos permitidos.',
    drop_zone: 'Arrastra y suelta tus archivos e imágenes aquí o',
    supported_files: 'Archivos compatibles',
    duplicate_files: 'Archivos duplicados subidos',
    delete_all: 'Eliminar Todo',
    cancel: 'CANCELAR',
    delete: 'ELIMINAR',
    delete_all_conv_title: 'Eliminar Todo',
    delete_all_conv_warning:
      'Estás a punto de eliminar todo el historial de conversaciones, no podrás deshacer esta acción más tarde.',
    delete_item_title: 'Eliminar Conversación',
    delete_item_warning:
      'Estás a punto de eliminar la conversación "{title}", no podrás deshacer esta acción más tarde.',
    delete_item_success: 'Conversación eliminada con éxito',
    delete_items_success: 'Todas las conversaciones se han eliminado con éxito',
    copy_raw_value_success: 'Copiado',
    copy_raw_value_fail: 'Error al copiar',
    feedback_btn_general: 'Comparte Tu Opinión',
    feedback_title_positive: '¿Cómo fue tu experiencia?',
    feedback_title_negative: '¿Cómo fue tu experiencia?',
    feedback_title_general: '¡Valoramos tus comentarios!',
    feedback_success_message: 'Comentarios registrados con éxito',
    feedback_dialog_placeholder_positive: '¿Qué te gustó de la respuesta?',
    feedback_dialog_placeholder_negative:
      '¿Cuál fue el problema? ¿Cómo se puede mejorar?',
    feedback_dialog_placeholder_general:
      '¿Cómo fue tu experiencia? Ya sea un cumplido, una sugerencia o una inquietud, ¡queremos escucharlo todo!',
    feedback_input_placeholder: 'Cuéntanos más',
    feedback_input_placeholder_general: 'Ingresa tus comentarios',
    submit: 'Enviar',
    all_conversations: 'Todas las Conversaciones',
    clear_history_dialog_title: 'Borrar Historial',
    clear_history_dialog_text:
      'Estás a punto de borrar todo el historial de conversaciones, no podrás deshacer esta acción más tarde.',
    unknown: 'desconocido',
    copy_code: 'Copiar código',
    settings: 'Configuraciones',
    filters: 'Filtros',
    use_knowledge_bank: 'Usar banco de conocimiento',
    use_dataset: 'Usar conjunto de datos',
    use: 'Usar',
    tags: 'Etiquetas',
    no_filters_text:
      'Los filtros requieren un ID de Banco de Conocimiento especificado',
    empty_filters_text: 'No se configuraron filtros.',
    select_label: 'Seleccionar {item}',
    close: 'Cerrar',
    applied_filters: 'Filtros Aplicados',
    see_more_filters: 'Ver {count} más filtros',
    see_less_filters: 'Mostrar menos filtros',
    apply: 'APLICAR',
    upload_successful: 'Archivo subido con éxito',
    generic_upload_error: 'Error al subir el archivo',
    no_selected_file: 'Ningún archivo seleccionado',
    context_excursion:
      'El texto es demasiado largo para ser procesado por el LLM. Por favor, intenta de nuevo con un texto más corto.',
    file_too_large:
      'El archivo es demasiado grande. El tamaño máximo es {size}MB.',
    invalid_file_type: 'Tipo de archivo no válido.',
    parsing_error: 'No se pudo extraer datos del archivo',
    too_many_files: 'Has excedido el número máximo de archivos permitidos. El límite es de {maxNUploadFiles} archivos.',
    summary: 'Resumen',
    key_topics: 'Temas clave',
    file_delete_successful: 'Archivo eliminado con éxito',
    file_delete_failed: 'Error al eliminar el archivo',
    tooltip_file: 'Agregar un archivo o imagen',
    tooltip_send: 'Enviar',
    tooltip_copy: 'Copiar',
    tooltip_knowledge_bank: 'Usando banco de conocimiento',
    tooltip_with_filters: 'con filtros',
    tooltip_thumbs_up: 'Buena respuesta',
    tooltip_thumbs_down: 'Mala respuesta',
    tooltip_close_filedropzone: 'Cerrar la carga de archivos',
    answer_generated_with_kb:
      'Respuesta generada basada en el banco de conocimiento',
    answer_generated_with_db:
      'Respuesta generada basada en la consulta de la base de datos',
    answer_generated_with_agents:
      'Respuesta generada basada en las respuestas de los agentes',
    answer_generated_without_retriever: 'Respuesta generada basada en el LLM',
    sample: 'Muestra de datos',
    sql_query: 'Consulta SQL:',
    analyzing_kb: 'Consultando banco de conocimiento',
    analyzing_db: 'Consultando base de datos',
    analyzing_no_retriever: 'Consultando LLM',
    calling_agent: 'Llamando a los agentes',
    retrieving_agent: 'Recuperando agentes disponibles',
    no_agent: 'No hay agentes disponibles',
    agent_available: 'Agentes encontrados',
    synthesizing_agents_answers: 'Sintetizando respuestas de los agentes',
    calling_default_chain: 'Llamando a la cadena predeterminada',
    preparing_agent: 'Preparando agentes',
    tool_call:'Llamada de herramienta',
    streaming: 'Consultando LLM',
    streaming_end: 'Finalizando consulta LLM',
    generating_image: 'Generando imagen',
    tooltip_download_image: 'Descargar imagen',
    tooltip_download_images: 'Descargar todas las imágenes',
    loading: 'Analizando',
    logout: 'Cerrar sesión',
    history: 'Historial',
    user_settings: 'Configuración de usuario',
    language: 'Idioma',
    update_user_profile_success: 'Perfil del usuario actualizado con éxito',
    update_user_profile_failure: 'Error al actualizar el perfil del usuario',
    image_generation_settings: 'Configuraciones de generación de imágenes',
    height: 'Altura',
    width: 'Ancho',
    quality: 'Calidad',
    nbr_images_to_generate: 'Número de imágenes',
    height_description: 'Altura de la imagen generada en píxeles',
    width_description: 'Ancho de la imagen generada en píxeles',
    quality_description:
      'Calidad de la imagen generada, mayor calidad tomará más tiempo en generar.',
    nbr_images_to_generate_description: 'Número de imágenes a generar.',
    image_generation_settings_disclaimer:
      'Tenga en cuenta que las configuraciones de generación de imágenes dependen de las capacidades del modelo de lenguaje seleccionado. Algunas configuraciones pueden no ser compatibles, lo que podría provocar errores durante la creación de imágenes. Para información detallada, consulte la documentación del modelo específico que está utilizando.',
    image_generation_model: 'Modelo de generación de imágenes',
    image_generation_model_tooltip:
      'El modelo de lenguaje utilizado para la generación de imágenes',
    extracting_data: 'Extrayendo datos...',
    max_images_per_week: 'Cuota semanal de imágenes',
    max_images_per_week_tooltip:
      'Cantidad de imágenes que puedes generar por semana hasta el próximo reinicio',
    images_left_of: 'imágenes restantes de',
    days: 'd',
    hours: 'h'
  },
  de: {
    examples: 'Beispiele',
    backHome: 'Zurück zur Startseite',
    questionPlaceholder: 'Stelle eine Frage',
    clearHistory: 'Verlauf löschen',
    sources: 'Quellen',
    error_message: 'Unerwarteter Fehler, bitte versuchen Sie es erneut',
    error_answer: 'Fehler aufgetreten',
    new_chat: 'Neuer Chat',
    tooltip_upload_files: 'Dateien hochladen',
    select_files: 'Klicken Sie hier, um Dateien auszuwählen',
    files_and_images: 'Dateien und Bilder',
    max_number_of_files_reached:
      'Upload-Limit erreicht: Es sind maximal {maxFilesAllowed} Dateien erlaubt.',
    drop_zone: 'Ziehen Sie Ihre Dateien und Bilder hierher oder',
    supported_files: 'Unterstützte Dateien',
    duplicate_files: 'Doppelte Datei(en) hochgeladen',
    delete_all: 'Alles löschen',
    cancel: 'ABBRECHEN',
    delete: 'LÖSCHEN',
    delete_all_conv_title: 'Alles löschen',
    delete_all_conv_warning:
      'Sie sind dabei, den gesamten Verlauf zu löschen. Diese Aktion kann nicht rückgängig gemacht werden.',
    delete_item_title: 'Konversation löschen',
    delete_item_warning:
      'Sie sind dabei, die Konversation "{title}" zu löschen. Diese Aktion kann nicht rückgängig gemacht werden.',
    delete_item_success: 'Konversation erfolgreich gelöscht',
    delete_items_success: 'Alle Konversationen wurden erfolgreich gelöscht',
    copy_raw_value_success: 'Kopiert',
    copy_raw_value_fail: 'Kopieren fehlgeschlagen',
    feedback_btn_general: 'Feedback teilen',
    feedback_title_positive: 'Was hat Ihnen gefallen?',
    feedback_title_negative: 'Warum ist dies eine schlechte Antwort?',
    feedback_title_general: 'Wir schätzen Ihr Feedback!',
    feedback_success_message: 'Feedback erfolgreich erfasst',
    feedback_dialog_placeholder_positive:
      'Mehr Details helfen uns die Antworten weiter zu verbessern.',
    feedback_dialog_placeholder_negative:
      'Was genau war das Problem? Wie könnte dies verbessert werden?',
    feedback_dialog_placeholder_general:
      'Wie war Ihre Erfahrung? Ob Lob, Vorschlag oder Bedenken, wir möchten alles hören!',
    feedback_input_placeholder: 'Erzählen Sie uns mehr...',
    feedback_input_placeholder_general: 'Geben Sie uns Ihr Feedback...',
    submit: 'Absenden',
    all_conversations: 'Alle Konversationen',
    clear_history_dialog_title: 'Verlauf löschen',
    clear_history_dialog_text:
      'Sie sind dabei, den gesamten Verlauf zu löschen. Diese Aktion kann nicht rückgängig gemacht werden.',
    unknown: 'unbekannt',
    copy_code: 'Code kopieren',
    settings: 'Einstellungen',
    filters: 'Filter',
    use_knowledge_bank: 'Wissensdatenbank verwenden',
    use_dataset: 'Datensatz verwenden',
    use: 'Nutzung',
    tags: 'Tags',
    no_filters_text: 'Filter erfordern eine spezifizierte Knowledge Bank ID',
    empty_filters_text: 'Es wurden keine Filter eingerichtet.',
    select_label: 'Wählen Sie {item}',
    close: 'Schließen',
    applied_filters: 'Angewandte Filter',
    see_more_filters: '{count} weitere Filter anzeigen',
    see_less_filters: 'Weniger Filter anzeigen',
    apply: 'ANWENDEN',
    upload_successful: 'Datei erfolgreich hochgeladen',
    no_selected_file: 'Keine Datei ausgewählt',
    context_excursion:
      'Der Text ist zu lang, um vom LLM verarbeitet zu werden. Bitte versuchen Sie es erneut mit einem kürzeren Text.',
    generic_upload_error: 'Dateiupload fehlgeschlagen',
    file_too_large: 'Datei ist zu groß. Die maximale Größe beträgt {size}MB.',
    invalid_file_type: 'Ungültiger Dateityp.',
    parsing_error: 'Daten aus der Datei konnten nicht extrahiert werden',
    too_many_files: 'Sie haben die maximale Anzahl an Dateien überschritten. Das Limit beträgt {maxNUploadFiles} Dateien.',
    summary: 'Zusammenfassung',
    key_topics: 'Schlüsselthemen',
    file_delete_successful: 'Datei erfolgreich gelöscht',
    file_delete_failed: 'Löschen der Datei fehlgeschlagen',
    tooltip_file: 'Datei oder Bild hinzufügen',
    tooltip_send: 'Senden',
    tooltip_copy: 'Kopieren',
    tooltip_knowledge_bank: 'Wissensdatenbank verwenden',
    tooltip_with_filters: 'mit Filtern',
    tooltip_thumbs_up: 'Gute Antwort',
    tooltip_thumbs_down: 'Schlechte Antwort',
    tooltip_close_filedropzone: 'Datei-Upload schließen',
    answer_generated_with_kb:
      'Antwort basierend auf der Wissensdatenbank generiert',
    answer_generated_with_db:
      'Basierend auf der Datenbankabfrage generierte Antwort',
    answer_generated_with_agents:
      'Antwort basierend auf den Agentenantworten generiert',
    answer_generated_without_retriever:
      'Antwort basierend auf dem LLM generiert',
    sample: 'Datenbeispiel',
    sql_query: 'SQL-Abfrage:',
    analyzing_kb: 'Abfrage der Wissensbank',
    analyzing_db: 'Datenbank abfragen',
    analyzing_no_retriever: 'Abfrage LLM',
    calling_agent: 'Agenten anrufen',
    retrieving_agent: 'Verfügbare Agenten abrufen',
    no_agent: 'Kein Agent verfügbar',
    agent_available: 'Agenten gefunden',
    synthesizing_agents_answers: 'Agentenantworten synthetisieren',
    calling_default_chain: 'Standardkette aufrufen',
    preparing_agent: 'Agenten vorbereiten',
    tool_call:'Werkzeuganruf',
    streaming: 'Abfrage LLM',
    streaming_end: 'LLM-Abfrage abschließen',
    generating_image: 'Bild wird generiert',
    tooltip_download_image: 'Bild herunterladen',
    tooltip_download_images: 'Alle Bilder herunterladen',
    loading: 'Analysieren',
    logout: 'Ausloggen',
    history: 'Verlauf',
    user_settings: 'Benutzereinstellungen',
    language: 'Sprache',
    update_user_profile_success: 'Benutzerprofil erfolgreich aktualisiert',
    update_user_profile_failure:
      'Benutzerprofil konnte nicht aktualisiert werden',
    image_generation_settings: 'Bildeinstellungen',
    height: 'Höhe',
    width: 'Breite',
    quality: 'Qualität',
    nbr_images_to_generate: 'Anzahl der Bilder',
    height_description: 'Höhe des generierten Bildes in Pixel',
    width_description: 'Breite des generierten Bildes in Pixel',
    quality_description:
      'Qualität des generierten Bildes, höhere Qualität dauert länger zu generieren.',
    nbr_images_to_generate_description: 'Anzahl der zu generierenden Bilder',
    image_generation_settings_disclaimer:
      'Bitte beachten Sie, dass die Einstellungen zur Bilderzeugung von den Fähigkeiten des ausgewählten Sprachmodells abhängen. Einige Einstellungen werden möglicherweise nicht unterstützt, was zu Fehlern bei der Bildgenerierung führen kann. Für detaillierte Informationen konsultieren Sie bitte die Dokumentation des von Ihnen verwendeten Modells.',
    image_generation_model: 'Bildgenerierungsmodell',
    image_generation_model_tooltip:
      'Das für die Bildgenerierung verwendete Sprachmodell',
    extracting_data: 'Extrahiere Daten...',
    max_images_per_week: 'Wöchentliches Bildkontingent',
    max_images_per_week_tooltip:
      'Anzahl der Bilder, die Sie pro Woche bis zum nächsten Zurücksetzen erstellen können',
    images_left_of: 'verbleibende Bilder von',
    days: 'T',
    hours: 'Std'
  },
  ja: {
    examples: '質問の例',
    backHome: 'ホームに戻る',
    questionPlaceholder: '質問を入力',
    clearHistory: '履歴を削除',
    sources: '情報源',
    error_message: '予期せぬエラーが発生しました。もう一度お試しください',
    error_answer: 'エラーが発生しました',
    new_chat: '新規チャットを開始',
    tooltip_upload_files: 'ファイルをアップロード',
    select_files: 'クリックして選択',
    files_and_images: 'ファイルと画像',
    max_number_of_files_reached:
      'ファイルのアップロード制限に達しました：最大{maxFilesAllowed}つのファイルが許可されています。',
    drop_zone: 'ファイルや画像をここにドラッグ＆ドロップするか、',
    supported_files: '対応ファイル',
    duplicate_files: '重複したファイルがアップロードされました',
    delete_all: 'すべて削除',
    cancel: 'キャンセル',
    delete: '削除',
    delete_all_conv_title: 'すべて削除',
    delete_all_conv_warning:
      'すべての会話履歴を削除しようとしています。この操作は取り消しできません。',
    delete_item_title: '会話を削除',
    delete_item_warning:
      '会話 「{title}」 を削除しようとしています。この操作は取り消しできません。',
    delete_item_success: '会話は正常に削除されました',
    delete_items_success: 'すべての会話が正常に削除されました',
    copy_raw_value_success: 'コピーを完了しました',
    copy_raw_value_fail: 'コピーに失敗しました',
    feedback_btn_general: 'フィードバック送信',
    feedback_title_positive: 'ご意見をお聞かせください',
    feedback_title_negative: 'ご意見をお聞かせください',
    feedback_title_general: 'フィードバックありがとうございます！',
    feedback_success_message: 'フィードバックは正常に送信されました。',
    feedback_dialog_placeholder_positive: 'どのような点が良かったですか？',
    feedback_dialog_placeholder_negative:
      '問題・改善点について教えてください。',
    feedback_dialog_placeholder_general:
      '良い点、改善すべき点、ご提案・ご心配な点など、率直なご意見をお聞かせください！',
    feedback_input_placeholder: 'フィードバックを入力',
    feedback_input_placeholder_general: 'フィードバックを入力',
    submit: '送信',
    all_conversations: '全ての会話',
    clear_history_dialog_title: '履歴をクリア',
    clear_history_dialog_text:
      'すべての会話履歴を削除しようとしています。この操作は取り消しできません。',
    unknown: '不明な言語',
    copy_code: 'コードをコピー',
    settings: '設定',
    filters: 'フィルター',
    use_knowledge_bank: 'ナレッジバンクを利用',
    use_dataset: 'データセットを利用',
    use: 'RAGを利用：',
    tags: 'タグ',
    no_filters_text: '指定されたナレッジバンクにはフィルターが存在しません。',
    empty_filters_text: 'フィルターが設定されていません。',
    select_label: '選択：{item}',
    close: '閉じる',
    applied_filters: '適用済みのフィルター',
    see_more_filters: 'フィルター（{count}）をさらに表示',
    see_less_filters: '表示を少なく',
    apply: '適用',
    upload_successful: 'ファイルが正常にアップロードされました。',
    generic_upload_error: 'ファイルのアップロードに失敗しました。',
    no_selected_file: 'ファイルが選択されていません。',
    context_excursion:
      'テキストがLLMによって処理するには長すぎます。短いテキストで再',
    file_too_large: 'ファイルサイズが大きすぎます。最大ファイルは1MBです。',
    invalid_file_type: 'ファイルタイプが正しくありません。',
    parsing_error: 'ファイルからデータを抽出できませんでした。',
    too_many_files: '許可される最大ファイル数を超えました。上限は {maxNUploadFiles} 個です。',
    summary: 'サマリー',
    key_topics: 'キートピック',
    file_delete_successful: 'ファイルを削除しました。',
    file_delete_failed: 'ファイルの削除に失敗しました。',
    tooltip_file: 'ファイルまたは画像を追加',
    tooltip_send: '送信',
    tooltip_copy: 'コピー',
    tooltip_knowledge_bank: 'ナレッジバンクを利用',
    tooltip_with_filters: 'フィルター有効',
    tooltip_thumbs_up: '良い',
    tooltip_thumbs_down: '悪い',
    tooltip_close_filedropzone: 'ファイルアップロードを閉じる',
    answer_generated_with_kb: 'ナレッジバンクに基づいて生成された回答',
    answer_generated_with_db: 'データベースクエリに基づいて生成された回答',
    answer_generated_with_agents: 'エージェントの回答に基づいて生成された回答',
    answer_generated_without_retriever: 'LLMに基づいて生成された回答',
    sample: 'データサンプル',
    sql_query: 'SQLクエリ:',
    analyzing_kb: 'ナレッジバンクを照会しています',
    analyzing_db: 'データベースのクエリ',
    analyzing_no_retriever: 'LLMを照会しています',
    calling_agent: 'エージェントを呼び出し',
    retrieving_agent: '利用可能なエージェントを取得',
    no_agent: '利用可能なエージェントがありません',
    agent_available: 'エージェントを見つけました',
    synthesizing_agents_answers: 'エージェントの回答を統合中',
    calling_default_chain: 'デフォルトチェーンを呼び出し中',
    preparing_agent: 'エージェントを準備中',
    tool_call:'ツールの呼び出し',
    streaming: 'LLMを照会しています',
    streaming_end: 'LLMの照会を終了',
    generating_image: '画像を生成しています',
    tooltip_download_image: '画像をダウンロード',
    tooltip_download_images: 'すべての画像をダウンロード',
    loading: '分析中',
    logout: 'ログアウト',
    history: '履歴',
    user_settings: 'ユーザー設定',
    language: '言語',
    update_user_profile_success: 'ユーザープロファイルが正常に更新されました',
    update_user_profile_failure: 'ユーザープロファイルの更新に失敗しました',
    image_generation_settings: '画像生成設定',
    height: '高さ',
    width: '幅',
    quality: '品質',
    nbr_images_to_generate: '生成する画像の数',
    height_description: '生成される画像の高さ（ピクセル）',
    width_description: '生成される画像の幅（ピクセル）',
    quality_description:
      '生成される画像の品質。高品質は生成に時間がかかります。',
    nbr_images_to_generate_description: '生成する画像の数',
    image_generation_settings_disclaimer:
      '画像生成の設定は、選択した言語モデルの機能に依存します。一部の設定はサポートされていない場合があり、その場合は画像生成中にエラーが発生する可能性があります。詳細については、ご利用の特定のモデルのドキュメントを参照してください。',
    image_generation_model: '画像生成モデル',
    image_generation_model_tooltip: '画像生成に使用される言語モデル',
    extracting_data: 'データを抽出中...',
    max_images_per_week: '週間画像割り当て',
    max_images_per_week_tooltip: '次のリセットまで毎週生成できる画像の数',
    images_left_of: '残りの画像',
    days: '日',
    hours: '時間'
  },
  ko: {
    examples: '예시',
    backHome: '홈으로 돌아가기',
    questionPlaceholder: '질문을 보내세요',
    clearHistory: '기록 지우기',
    sources: '출처',
    error_message: '예상치 못한 오류가 발생했습니다. 다시 시도해 주세요.',
    error_answer: '오류가 발생했습니다.',
    new_chat: '새로운 채팅',
    tooltip_upload_files: '파일 업로드',
    select_files: '클릭하여 선택',
    files_and_images: '파일 및 이미지',
    max_number_of_files_reached:
      '파일 업로드 제한 도달: 최대 {maxFilesAllowed}개의 파일만 업로드할 수 있습니다.',
    drop_zone: '여기에 파일 및 이미지를 드래그 앤 드롭하거나',
    supported_files: '지원되는 파일',
    duplicate_files: '중복된 파일이 업로드되었습니다',
    delete_all: '모두 삭제',
    delete: '삭제',
    cancel: '취소',
    delete_all_conv_title: '모두 삭제',
    delete_all_conv_warning:
      '대화 기록을 모두 삭제하려고 합니다. 이 작업은 후에 되돌릴 수 없습니다.',
    delete_item_title: '대화 삭제',
    delete_item_warning:
      "대화 '{title}'를 삭제하려고 합니다. 이 작업은 후에 되돌릴 수 없습니다.",
    delete_item_success: '대화가 삭제되었습니다.',
    delete_items_success: '모든 대화가 삭제되었습니다.',
    copy_raw_value_success: '복사됨',
    copy_raw_value_fail: '복사 실패',
    feedback_btn_general: '의견 공유하기',
    feedback_title_positive: '추가 피드백을 제공하십시오',
    feedback_title_negative: '추가 피드백을 제공하십시오',
    feedback_title_general: '추가 피드백을 제공하십시오',
    feedback_success_message: '피드백이 성공적으로 기록되었습니다',
    feedback_dialog_placeholder_positive: '응답에서 무엇이 마음에 드세요 ?',
    feedback_dialog_placeholder_negative:
      '무슨 문제가 있었나요 ? 어떻게 개선될 수 있을까요 ?',
    feedback_dialog_placeholder_general:
      '어떤 경험이었나요? 칭찬이든, 제안이든, 우려사항이든, 모두 듣고 싶습니다!',
    feedback_input_placeholder: '더 말해주세요',
    feedback_input_placeholder_general: '피드백을 입력하세요',
    submit: '제출',
    all_conversations: '모든 대화',
    clear_history_dialog_title: '기록 지우기',
    clear_history_dialog_text:
      '당신은 모든 대화 기록을 삭제하려고 합니다. 이 작업은 후에 취소할 수 없습니다.',
    unknown: '미지의',
    copy_code: '코드 복사',
    settings: '설정',
    filters: '필터',
    use_knowledge_bank: '사용',
    use_dataset: '사용',
    use: '사용',
    tags: '태그',
    no_filters_text: '필터는 지정된 지식 은행 ID가 필요합니다',
    empty_filters_text: '설정된 필터가 없습니다.',
    select_label: '선택 {item}',
    close: '닫기',
    applied_filters: '적용된 필터',
    see_more_filters: '더 많은 필터 보기',
    see_less_filters: '필터 덜 보기',
    apply: '지원하다',
    upload_successful: '파일이 성공적으로 업로드됨',
    generic_upload_error: '파일 업로드 실패',
    no_selected_file: '선택된 파일이 없습니다',
    context_excursion: '텍스트가 너무 깁니다. 짧은 텍스트로 다시 시도하십시오.',
    file_too_large: '파일이 너무 큽니다. 최대 크기는 {size}MB입니다.',
    invalid_file_type: '잘못된 파일 유형입니다.',
    parsing_error: '파일에서 데이터를 추출할 수 없습니다',
    too_many_files: '허용된 파일 수를 초과했습니다. 최대 {maxNUploadFiles}개의 파일까지 업로드할 수 있습니다.',
    summary: '요약',
    key_topics: '주요 주제',
    file_delete_successful: '파일이 성공적으로 삭제됨',
    file_delete_failed: '파일 삭제 실패',
    tooltip_file: '파일 또는 이미지 추가',
    tooltip_send: '보내기',
    tooltip_copy: '복사',
    tooltip_knowledge_bank: '지식 은행 사용',
    tooltip_with_filters: '필터 사용',
    tooltip_thumbs_up: '좋은 응답',
    tooltip_thumbs_down: '나쁜 응답',
    tooltip_close_filedropzone: '파일 업로드 닫기',
    answer_generated_with_kb: '지식 뱅크를 기반으로 생성된 답변',
    answer_generated_with_db: '데이터베이스 쿼리를 기반으로 생성된 답변',
    answer_generated_with_agents: '에이전트 응답을 기반으로 생성된 답변',
    answer_generated_without_retriever: 'LLM을 기반으로 생성된 답변',
    sample: '데이터 샘플',
    sql_query: 'SQL 쿼리:',
    analyzing_kb: '지식 은행 조회 중',
    analyzing_db: '데이터베이스 쿼리 중',
    analyzing_no_retriever: 'LLM 조회 중',
    calling_agent: '에이전트 호출 중',
    retrieving_agent: '사용 가능한 에이전트 검색 중',
    no_agent: '사용 가능한 에이전트 없음',
    agent_available: '에이전트 발견',
    synthesizing_agents_answers: '에이전트 응답을 합성 중',
    calling_default_chain: '기본 체인 호출 중',
    preparing_agent: '에이전트 준비 중',
    tool_call:'도구 호출',
    streaming: 'LLM 조회 중',
    streaming_end: 'LLM 조회 완료',
    generating_image: '이미지 생성 중',
    tooltip_download_image: '이미지 다운로드',
    tooltip_download_images: '모든 이미지 다운로드',
    loading: '분석 중',
    logout: '로그아웃',
    history: '기록',
    user_settings: '사용자 설정',
    language: '언어',
    update_user_profile_success:
      '사용자 프로필이 성공적으로 업데이트되었습니다',
    update_user_profile_failure: '사용자 프로필 업데이트 실패',
    image_generation_settings: '이미지 생성 설정',
    height: '높이',
    width: '너비',
    quality: '품질',
    nbr_images_to_generate: '생성할 이미지 수',
    height_description: '픽셀로 생성된 이미지의 높이',
    width_description: '픽셀로 생성된 이미지의 너비',
    quality_description:
      '생성된 이미지의 품질, 높은 품질은 생성하는 데 더 오래 걸립니다.',
    nbr_images_to_generate_description: '생성할 이미지 수',
    image_generation_settings_disclaimer:
      '이미지 생성 설정은 선택한 언어 모델의 기능에 따라 달라질 수 있습니다. 일부 설정은 지원되지 않을 수 있으며, 이로 인해 이미지 생성 중 오류가 발생할 수 있습니다. 자세한 정보는 사용 중인 특정 모델의 문서를 참조하십시오.',
    image_generation_model: '이미지 생성 모델',
    image_generation_model_tooltip: '이미지 생성에 사용되는 언어 모델',
    extracting_data: '데이터 추출 중...',
    max_images_per_week: '주간 이미지 할당량',
    max_images_per_week_tooltip:
      '다음 초기화까지 매주 생성할 수 있는 이미지 수',
    images_left_of: '남은 이미지',
    days: '일',
    hours: '시간'
  }
  // ... other languages
}

const i18n = createI18n({
  legacy: false,
  locale: 'en', // default locale
  messages
})

export default i18n
