# Agent Hub

This project is a cookiecutter template that instantiates a webapp for DSS.

## Template Content

- **.github/**: Contains static checks for Python (linting and mypy) and frontend, as well as the execution of unit tests in GitHub Workflow.
- **.vscode/**: Contains settings for linting and launching the webapp from VSCode.
- **backend/**: Contains server files.
- **code-env/**: Contains backend requirements.
- **resource/**: Contains the frontend.
- **tests/**: Contains unit tests.
- **Makefile**: Contains commands to run static checks, linting, and unit tests.
- **pyproject.toml**: Contains linting rules for ruff and mypy.

## Installation with uv

1. Create a virtual environment with `uv`:
    ```sh
    uv venv --python <version>
    ```
2. Activate the virtual environment:
    ```sh
    source .venv/bin/activate
    ```
3. Install the dependencies:
    ```sh
    uv pip install -r code-env/python/spec/requirements.dev.txt
    ```
4. Create .env file and add, make sure to update the values:
    ```
    LOCAL_DEV="true"
    DKU_CURRENT_PROJECT_KEY="your_project_key"
    VITE_API_PORT="5000"
    VITE_CLIENT_PORT="4200"
    VITE_USER_PROFILE="READER"
    ```
5. Create symbolic links to `dataiku` and `dataikuapi` packages from your local DSS_INSTANCE:
    ```sh
    cd your_venv/lib/<PYTHON_VERSION>/site-packages
    ln -s ~/Library/DataScienceStudio/kits/dataiku-dss-<DSS_VERSION>-osx/python/dataikuapi .
    ln -s ~/Library/DataScienceStudio/kits/dataiku-dss-<DSS_VERSION>-osx/python/dataiku .
    ```
    Make sure to replace by your PYTHON and DSS versions .

6. Create a `local_config.json` in `python-lib/backend` and replace these settings with your config: 
```json
{
    "LLMs": [
        {
            "$$hashKey": "object:287",
            "llm_id": "openai:bs-openai:gpt-4o"
        },
    ],
    "tool_agent_configurations": [
        {
            "$$hashKey": "object:4005",
            "agent_id": "AGENTCONNECT:agent:rMtLeB1n",
            "tool_agent_description": "A specialised Dataiku ARR-2025 data assistant.\nInvoke this tool whenever the user’s question requires factual, numeric, or tabular insight drawn from Dataiku’s FY-2025 subscription-contract dataset (ARR, pipeline, seats, renewal probability, churn risk, usage hours, NPS, regions, industries, segments, tiers, dates, etc.).",
            "agent_system_instructions": "Tone \u0026 formatting guidelines\nProfessional, succinct, friendly."
        }
    ],
    "enable_agents_as_tools": false,
    "logLevel": "INFO",
    "projects_keys": [
        "AGENTCONNECT"
    ],
    "agents_ids": [
        "AGENTCONNECT:agent:rMtLeB1n"
    ],
    "tools": [
        "yGuEuEr", "DWV1vca"
    ],
    "augmented_llms_ids": [
      "PORTAL:retrieval-augmented-llm:cba1f221"
    ],
    "augmented_llms_configurations": [
      {
        "$$hashKey": "object:465",
        "augmented_llm_id": "PORTAL:retrieval-augmented-llm:cba1f221",
        "augmented_llm_description": "Knows everything about genai trends"
      }
    ],
    "db_folder_path":"local_folder_path_to_store_db_files",
    "default_fs_connection": "filesystem_managed"
}
```
7. `cd` into `python-lib` and run the backend

```sh
    cd python-lib
    python -m backend.wsgi
## Evolution

This template will evolve over time.