let llmApp=angular.module("agenthub.module",[]);llmApp.constant("PLUGIN_PATHS",{WEBAPP:"/plugins/agent-hub/resource/custom-ui-settings/"}),llmApp.controller("LLMConfigController",["$scope","$timeout","PythonService","DataikuAPI","DescParamsService","$q","$window","$stateParams","$http","PLUGIN_PATHS",function($scope,$timeout,PythonService,DataikuAPI,DescParamsService,$q,$window,$stateParams,$http,PLUGIN_PATHS){function processSections(sections){return sections.map(section=>{var id=function toCamelCase(str){return str.split(" ").map((word,index)=>0===index?word.toLowerCase():word.charAt(0).toUpperCase()+word.slice(1).toLowerCase()).join("")}(section.displayName);return{id:id,displayName:section.displayName,formName:id+"SubForm"}})}function checkScrollPosition(){var scrollTop,scrollPercent,scrollableElement=document.querySelector('[ng-controller="CustomWebAppEditController"]');scrollableElement&&(scrollTop=scrollableElement.scrollTop,scrollPercent=(scrollTop+scrollableElement.clientHeight)/scrollableElement.scrollHeight,$scope.$apply(function(){$scope.showScrollToTop=300<scrollTop&&.3<scrollPercent}))}$scope.sections=[],$scope.selectedSection=null,$http.get(PLUGIN_PATHS.WEBAPP+"sections.json").then(function(response){$scope.sections=processSections(response.data),$scope.selectedSection=$scope.sections[0].id}).catch(function(error){console.error("Error loading sections:",error)}),$scope.navigateToSectionAndError=function(sectionWithError){$location.hash(sectionWithError.id),$timeout(function(){sectionWithError.firstErrorId&&document.getElementById(sectionWithError.firstErrorId);var sectionContainerId="section-"+sectionWithError.id,sectionContainerId=document.getElementById(sectionContainerId);sectionContainerId?sectionContainerId.scrollIntoView({behavior:"smooth",block:"start"}):(sectionContainerId=document.getElementsByName("configForm")[0])?sectionContainerId.scrollIntoView({behavior:"smooth",block:"start"}):window.scrollTo({top:0,behavior:"smooth"})},100)},$scope.$watch(function(){return $location.hash()},function(newHash){$scope.selectedSection=newHash?newHash.replace("#",""):"baseModels"}),$scope.config=$scope.config||{},"function"==typeof $scope.callPythonDo?PythonService.registerCallPythonDoFunction($scope.callPythonDo):PythonService.registerCallPythonDoFunction(function(){return $q.reject("callPythonDo was not properly initialized in LLMConfigController for PythonService.")}),DescParamsService.registerDescParams($scope),$scope.descParams=DescParamsService.getDescParams(),$scope.showScrollToTop=!1,$scope.scrollToTop=function(){var controllerElement=document.querySelector('[ng-controller="LLMConfigController"]');controllerElement?controllerElement.scrollIntoView({behavior:"smooth"}):window.scrollTo({top:0,behavior:"smooth"})};var scrollableElement=document.querySelector('[ng-controller="CustomWebAppEditController"]');scrollableElement&&angular.element(scrollableElement).on("scroll",checkScrollPosition),$scope.$on("$destroy",function(){scrollableElement&&angular.element(scrollableElement).off("scroll",checkScrollPosition)})}]),llmApp.directive("listenForSaveAndView",function(){return{restrict:"A",link:function(scope){function validateForm(scope){scope.invalidSections=[];let isOverallFormInvalid=scope.showGlobalError=!1,form=scope.configForm;return!(!form||(angular.forEach(scope.sections,function(section){var sectionForm=scope.configForm[section.formName];sectionForm&&sectionForm.$invalid&&(scope.invalidSections.push(section),isOverallFormInvalid=!0)}),isOverallFormInvalid?scope.showGlobalError=!0:!form.$valid||(form.$setPristine(),form.$setUntouched(),0)))}function clickHandler(event){!function handleClick(event){for(var target=event.target;target&&target!==document;){if("BUTTON"===target.tagName||"A"===target.tagName){var elementText=target.textContent.trim().toLowerCase();if(elementText.includes("save and view webapp")||elementText.includes("save and view app")||elementText.includes("save & view")||elementText.includes("save"))return target.hasAttribute("data-bypassed")?target.removeAttribute("data-bypassed"):(event.stopPropagation(),event.preventDefault(),scope.$apply(function(){scope.configForm&&(scope.configForm.$submitted=!0),validateForm(scope)||(scope.showValidationError=!0,$timeout(function(){var controllerElement=document.querySelector('[ng-controller="LLMConfigController"]');controllerElement&&controllerElement.scrollIntoView({behavior:"smooth"})})),$timeout(function(){target.setAttribute("data-bypassed","true"),target.click()})}))}target=target.parentElement}}(event)}function keydownHandler(event){(event.ctrlKey||event.metaKey)&&"s"===event.key&&(event.preventDefault(),scope.$apply(function(){scope.configForm&&(scope.configForm.$submitted=!0),validateForm(scope)||(scope.showValidationError=!0,$timeout(function(){var controllerElement=document.querySelector('[ng-controller="LLMConfigController"]');controllerElement&&controllerElement.scrollIntoView({behavior:"smooth"})}))}))}document.addEventListener("click",clickHandler,!0),document.addEventListener("keydown",keydownHandler,{capture:!0,passive:!1}),scope.$on("$destroy",function(){document.removeEventListener("click",clickHandler,!0),document.removeEventListener("keydown",keydownHandler,!0)})}}}),llmApp.factory("DescParamsService",[function(){var service={},registeredDescParams=null;return service.registerDescParams=function(scope){scope&&scope.$parent&&scope.$parent.$parent&&scope.$parent.$parent.desc&&scope.$parent.$parent.desc.params&&(registeredDescParams=scope.$parent.$parent.desc.params)},service.getParamConfigByName=function(name){return registeredDescParams?registeredDescParams.find(p=>p.name===name)||null:(console.warn("DescParamsService: getParamConfigByName called before params were registered."),null)},service.getDescParams=function(){return registeredDescParams},service.getSelectChoices=function(fieldName){var field;return registeredDescParams?(field=registeredDescParams.find(item=>item.name===fieldName&&"SELECT"===item.type))?field.selectChoices:[]:null},service.setDescParams=function(params){registeredDescParams=params},service.getDefaultValue=function(paramName){return registeredDescParams&&(paramName=function findParamRecursive(params,name){for(var param of params){if(param.name===name)return param;if(param.subParams&&(param=findParamRecursive(param.subParams,name)))return param}return null}(registeredDescParams,paramName))&&paramName.hasOwnProperty("defaultValue")?paramName.defaultValue:null},service}]),llmApp.service("customFileUploaderService",["$q","$timeout",function($q,$timeout){let defaultIconURL=window.location.origin+"/plugins/agent-hub/resource/custom-ui-settings/No_image_available.png";this.generateAppFilename=function(){var match=window.location.href.match(/projects\/([^\/]+)\/webapps\/([^\/]+)\/edit/);if(match){var id,projectName=match[1],match=match[2].split("_");if(2<=match.length)return id=match[0],projectName+`_${match.slice(1).join("_")}_`+id}return"unknown-project_unknown-app_unknown-id"},this.isImageFile=function(file){return file&&file.type&&file.type.startsWith("image/")},this.isImageFileByName=function(fileName){fileName=(fileName||"").toLowerCase().substring(fileName.lastIndexOf("."));return[".jpg",".jpeg",".png",".gif",".svg",".webp",".bmp"].includes(fileName)},this.getDefaultIconUrl=function(){return defaultIconURL},this.ensureSubFolderExists=function(uploadTargetType,uploadTargetPath,subFolderName){let subFolderPath=uploadTargetPath.replace(/\/$/,"")+"/"+subFolderName;return DataikuAPI.admin.folderEdit.createContent(uploadTargetType,subFolderPath,!0).then(()=>subFolderPath).catch(error=>{if(error.data?.detailedMessage?.includes("already exists"))return subFolderPath;throw error})},this.ensureThemeFolderExists=function(uploadTargetType,themeName,uploadTargetPath){let themePath=uploadTargetPath+"/"+themeName;return DataikuAPI.admin.folderEdit.createContent(uploadTargetType,themePath,!0).then(()=>themePath).catch(error=>{if(error.data?.detailedMessage?.includes("already exists"))return themePath;throw error})},this.ensureSubFolderExists=function(uploadTargetType,themePath,folderName){let subFolderPath=themePath+"/"+folderName;return DataikuAPI.admin.folderEdit.createContent(uploadTargetType,subFolderPath,!0).then(()=>subFolderPath).catch(error=>{if(error.data?.detailedMessage?.includes("already exists"))return subFolderPath;throw error})},this.fetchUploadedFiles=function(uploadTargetType){return DataikuAPI.admin.folderEdit.listContents(uploadTargetType)},this.listSubFolders=function(folderName="answers"){return this.fetchUploadedFiles("LOCAL_STATIC").then(response=>{response=("string"==typeof response?JSON.parse(response):response).data.find(function(item){return item&&item.name===folderName});return response&&response.children?response.children.filter(function(child){return child&&child.children}).map(function(child){return{label:child.name,value:child.name}}):[]}).catch(error=>[])},this.uploadFile=function(uploadTargetType,targetPath,file){return new $q((resolve,reject)=>{DataikuAPI.admin.folderEdit.uploadContent(uploadTargetType,targetPath,file,(response,error)=>{error?reject({file:file.name,error:error}):resolve({file:file.name,path:targetPath+"/"+file.name})})})},this.deleteFile=function(uploadTargetType,filePath){return DataikuAPI.admin.folderEdit.deleteContent(uploadTargetType,filePath)},this.getAcceptedImageTypes=function(){return["image/jpeg","image/jpg","image/png"]},this.isAcceptedImageType=function(fileType){return this.getAcceptedImageTypes().includes(fileType)},this.getDefaultAllowedFiles=function(){return{"custom.css":{types:["text/css","application/css"],folder:""},"fonts.css":{types:["text/css","application/css"],folder:"fonts"},image:{types:["image/png","image/jpeg"],folder:"images"}}},this.createFolder=function(uploadTargetType,folderName,parentPath){return this.ensureSubFolderExists(uploadTargetType,parentPath,"answers").then(answersPath=>DataikuAPI.admin.folderEdit.createContent(uploadTargetType,answersPath+"/"+folderName,!0).then(()=>({label:folderName,value:folderName})))},this.getAllFilesForTheme=function(apiResponseData,themeName,parentFolderName="answers"){if(!apiResponseData||!themeName)return[];apiResponseData=apiResponseData.find(item=>item.name===parentFolderName);if(!apiResponseData||!apiResponseData.children)return[];apiResponseData=apiResponseData.children.find(child=>child.name===themeName);if(!apiResponseData||!apiResponseData.children)return[];let files=[],collectFilesRecursively=items=>{items.forEach(item=>{item.children&&0<item.children.length?collectFilesRecursively(item.children):item.children||files.push(item)})};return collectFilesRecursively(apiResponseData.children),files}}]),llmApp.factory("ParamsHelperService",["DataikuAPI","APIXHRService","$q","Logger",function(DataikuAPI,APIXHRService,$q,Logger){let CONNECTION_TYPES={FILESYSTEM:"Filesystem",EC2:"EC2",FTP:"FTP",SSH:"SSH",AZURE:"Azure",GCS:"GCS",HDFS:"HDFS",SHAREPOINT_ONLINE:"SharePointOnline"},service={do:function(payload,config,pluginConfig,inputs){var parameterName=payload.parameterName,projectKey=payload.projectKey;switch(parameterName){case"projects_keys":return service.listProjects();case"agents_ids":case"agent_id":return service.listAgents(payload);case"augmented_llms_ids":return service.listAugmentedLlms(payload);case"augmented_llm_id":return service.listSelectedAugmentedLlms(payload);case"tools":return service.listAgentTools(projectKey);case"stories_workspace":return service.listWorkspaces();case"default_fs_connection":return service.listConnectionsByType();case"agents_folder":return service.listProjectsFolders();case"llm_id":case"embedding_llms":case"graph_generation_llm_id":var purpose=payload.purpose||"GENERIC_COMPLETION";return service.listLlmsByConnectionsType(projectKey,purpose);case"worksspace_folder":return service.listWorkspacesFolders(payload);case"selected_agents":return service.listSelectedAgentsAndAugmentedLlms(payload);default:return $q.resolve({choices:[{value:"wrong",label:"Problem getting the name of the parameter."}]})}},getProjectAgentMapping:function(projectKey){return DataikuAPI.pretrainedModels.listAvailableLLMs(projectKey,"GENERIC_COMPLETION").then(function(response){let agentsMap={};return(response.data&&response.data.identifiers?response.data.identifiers:[]).forEach(function(llm){llm.id&&llm.id.startsWith("agent")&&(agentsMap[llm.id]=llm.friendlyName)}),agentsMap}).catch(function(error){return Logger.error("Error getting project agent mapping",error),{}})},getProjectAgents:function(projectKey){return service.getProjectAgentMapping(projectKey).then(function(agentsMap){let agents=[];return Object.keys(agentsMap).forEach(function(agentId){agents.push({value:projectKey+":"+agentId,label:agentsMap[agentId],description:""})}),agents})},listAgentsByProject:function(selectedProjects){return selectedProjects&&0!==selectedProjects.length?(selectedProjects=selectedProjects.map(function(projectKey){return service.getProjectAgents(projectKey).then(function(agents){return{projectKey:projectKey,agents:agents}}).catch(function(error){return Logger.error("Error getting agents for project: "+projectKey,error),{projectKey:projectKey,agents:[]}})}),$q.all(selectedProjects).then(function(results){let agentsByProject={};return results.forEach(function(result){result.agents&&0<result.agents.length&&(agentsByProject[result.projectKey]=result.agents)}),agentsByProject})):$q.resolve({})},mapAgentsIdName:function(selectedProjects,withProjectKey){return withProjectKey=withProjectKey||!1,service.listAgentsByProject(selectedProjects).then(function(agentsByProject){let agentsMap={};return Object.keys(agentsByProject).forEach(function(projectKey){agentsByProject[projectKey].forEach(function(agent){var label=withProjectKey?"["+projectKey+"] "+agent.label:agent.label;agentsMap[agent.value]=label})}),agentsMap})},listSelectedAgents:function(payload){let selectedAgents=payload.rootModel.agents_ids||[];payload=payload.rootModel.projects_keys||[];return service.mapAgentsIdName(payload,!0).then(function(agentsMap){return{choices:selectedAgents.map(function(agent){return{value:agent,label:agentsMap[agent]}})}})},listSelectedAugmentedLlms:function(payload){let selectedAugLlms=payload.rootModel.augmented_llms_ids||[];payload=payload.rootModel.projects_keys||[];return payload&&0!==payload.length&&selectedAugLlms&&0!==selectedAugLlms.length?service.mapAugLlmsIdName(payload,!0).then(function(augLlmsMap){return{choices:selectedAugLlms.map(function(llm){return{value:llm,label:augLlmsMap[llm]||llm}})}}):$q.resolve({choices:[]})},listAugmentedLlms:function(payload){var payload=payload.rootModel.projects_keys||[];return payload&&0!==payload.length?(payload=payload.map(function(projectKey){return DataikuAPI.savedmodels.retrievalAugmentedLLMs.list(projectKey).then(function(response){response=response.data||response||[];return{projectKey:projectKey,llms:response}}).catch(function(error){return Logger.error("Error listing augmented LLMs for project: "+projectKey,error),{projectKey:projectKey,llms:[]}})}),$q.all(payload).then(function(results){let choices=[];return results.forEach(function(result){let projectKey=result.projectKey;result.llms.forEach(function(llm){choices.push({value:projectKey+":retrieval-augmented-llm:"+(llm.value||llm.id),label:"["+projectKey+"] "+(llm.label||llm.name||llm.friendlyName),description:llm.description||""})})}),{choices:choices}})):$q.resolve({choices:[]})},listSelectedAgentsAndAugmentedLlms:function(payload){let selectedAgents=payload.rootModel.agents_ids||[],selectedAugLlms=payload.rootModel.augmented_llms_ids||[];payload=payload.rootModel.projects_keys||[];return payload&&0!==payload.length?$q.all({agentsMap:service.mapAgentsIdName(payload,!0),augLlmsMap:service.mapAugLlmsIdName(payload,!0)}).then(function(maps){var agentChoices=selectedAgents.map(function(agent){return{value:agent,label:maps.agentsMap[agent]||agent}}),augLlmChoices=selectedAugLlms.map(function(llm){return{value:llm,label:maps.augLlmsMap[llm]||llm}});return{choices:agentChoices.concat(augLlmChoices)}}):$q.resolve({choices:[]})},listWorkspaces:function(){return DataikuAPI.workspaces.list().then(function(workspaces){return{choices:(workspaces.data||[]).map(function(workspace){return{value:workspace.workspaceKey,label:workspace.displayName,description:workspace.description}})}}).catch(function(error){return Logger.error("Error listing workspaces",error),{choices:[]}})},listProjectsFolders:function(){return DataikuAPI.projectFolders.listRootContents(!0,!1,!1,!1).then(function(response){response=response.data||response;return{choices:(response.folder&&response.folder.children?response.folder.children:[]).map(function(folder){return{value:folder.id,label:folder.name}})}}).catch(function(error){return Logger.error("Error listing project folders",error),{choices:[]}})},listAgents:function(payload){payload=payload.rootModel.projects_keys||[];return service.listAgentsByProject(payload).then(function(agentsByProject){let choices=[];return Object.keys(agentsByProject).forEach(function(projectKey){agentsByProject[projectKey].forEach(function(agent){choices.push({value:agent.value,label:"["+projectKey+"] "+agent.label,description:agent.description})})}),{choices:choices}}).catch(function(error){return Logger.error("Error listing agents",error),{choices:[]}})},listProjects:function(){return DataikuAPI.projects.list().then(function(response){return{choices:(response.data||[]).map(function(project){return{value:project.projectKey,label:"["+project.projectKey+"] "+project.name}})}}).catch(function(error){return Logger.error("Error listing projects",error),{choices:[]}})},listProjectsName:function(){return DataikuAPI.projects.list().then(function(projects){return{choices:projects.map(function(project){return{value:project.name,label:project.name}})}}).catch(function(error){return Logger.error("Error listing projects by name",error),{choices:[]}})},listAgentTools:function(projectKey){return projectKey?DataikuAPI.agentTools.list(projectKey).then(function(response){return{choices:(response.data||response||[]).map(function(toolDef){return{value:toolDef.id,label:toolDef.name}})}}).catch(function(error){return Logger.error("Error listing agent tools",error),{choices:[]}}):(Logger.warn("No projectKey provided to listAgentTools"),$q.resolve({choices:[]}))},listLlmsByConnectionsType:function(projectKey,purpose){let typesToExclude=["SAVED_MODEL_AGENT","RETRIEVAL_AUGMENTED"];return DataikuAPI.pretrainedModels.listAvailableLLMs(projectKey,purpose=purpose||"GENERIC_COMPLETION").then(function(response){let llmByType={};return(response.data&&response.data.identifiers?response.data.identifiers:[]).forEach(function(llm){var llmType=llm.type;-1===typesToExclude.indexOf(llmType)&&(llmByType[llmType]||(llmByType[llmType]=[]),llmByType[llmType].push({value:llm.id,label:llm.friendlyName,type:llmType}))}),{choices:llmByType}}).catch(function(error){return Logger.error("Error listing LLMs by connection type",error),{choices:{}}})},listConnectionsByType:function(){var promises=Object.values(CONNECTION_TYPES).map(function(connectionType){return DataikuAPI.connections.getNames(connectionType).then(function(response){response=response.data||[];return{type:connectionType,connections:response}}).catch(function(error){return Logger.error("Error processing connection type "+connectionType,error),{type:connectionType,connections:[]}})});return $q.all(promises).then(function(results){let connectionMap={};return results.forEach(function(result){result.connections&&0<result.connections.length&&(connectionMap[result.type]||(connectionMap[result.type]=[]),result.connections.forEach(function(connectionName){connectionMap[result.type].push(connectionName)}))}),{choices:connectionMap}})},listWorkspacesFolders:function(payload){payload=payload.projectKey;return DataikuAPI.managedFolders.listByProject(payload).then(function(managedFolders){return{choices:managedFolders.map(function(folder){return{value:folder.id,label:folder.name}})}}).catch(function(error){return Logger.error("Error listing workspace folders",error),{choices:[]}})},mapAugLlmsIdName:function(selectedProjects,withProjectKey){return withProjectKey=withProjectKey||!1,selectedProjects&&0!==selectedProjects.length?(selectedProjects=selectedProjects.map(function(projectKey){return DataikuAPI.savedmodels.retrievalAugmentedLLMs.list(projectKey).then(function(response){response=response.data||response||[];return{projectKey:projectKey,llms:response}}).catch(function(error){return Logger.error("Error mapping augmented LLMs for project: "+projectKey,error),{projectKey:projectKey,llms:[]}})}),$q.all(selectedProjects).then(function(results){let augLlmsMap={};return results.forEach(function(result){let projectKey=result.projectKey;result.llms.forEach(function(llm){var id=projectKey+":retrieval-augmented-llm:"+(llm.value||llm.id),llm=llm.label||llm.name||llm.friendlyName,llm=withProjectKey?"["+projectKey+"] "+llm:llm;augLlmsMap[id]=llm})}),augLlmsMap})):$q.resolve({})}};return service}]),llmApp.factory("PythonService",["$q",function($q){let _registeredCallPythonDo=null;return{registerCallPythonDoFunction:function(fn){_registeredCallPythonDo="function"==typeof fn?fn:null},unregisterCallPythonDoFunction:function(){_registeredCallPythonDo=null},callPythonDo:function(params){if("function"!=typeof _registeredCallPythonDo)return $q.reject("callPythonDo function not registered in PythonService");try{return _registeredCallPythonDo(params)}catch(e){return $q.reject("Error in registered callPythonDo: "+e.message)}}}}]),llmApp.service("SharedPromiseService",function($q,PythonService){function getCacheKey(params){var keys=Object.keys(params).sort(),keyParts=[];return keys.forEach(function(key){keyParts.push(key+":"+JSON.stringify(params[key]))}),keyParts.join("|")}function fetchData(params){var cacheKey=getCacheKey(params);return PythonService.callPythonDo(params).then(function(data){return dataPromises[cacheKey]=$q.when(data),data}).catch(function(error){return delete dataPromises[cacheKey],$q.reject(error)})}var dataPromises={};this.getData=function(params){var cacheKey=getCacheKey(params);return dataPromises[cacheKey]||(dataPromises[cacheKey]=fetchData(params)),dataPromises[cacheKey]},this.refreshData=function(params){var cacheKey=getCacheKey(params),params=fetchData(params);return dataPromises[cacheKey]=params,dataPromises[cacheKey]},this.clearCache=function(params){params=getCacheKey(params);delete dataPromises[params]},this.clearAllCache=function(){dataPromises={}}}),llmApp.directive("chartsGeneration",["PLUGIN_PATHS",function(PLUGIN_PATHS,SUPPORTED_CONNECTIONS){return{restrict:"E",templateUrl:PLUGIN_PATHS.WEBAPP+"charts-generation.html",scope:{config:"=",configForm:"="},controller:["$scope","$timeout",function($scope,$timeout){$scope.config=$scope.config||{}}]}}]),llmApp.directive("endUserConfiguration",["customFileUploaderService","$timeout","PLUGIN_PATHS",function(customFileUploaderService,$timeout,PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.WEBAPP+"end-user-configuration.html",scope:{config:"=",configForm:"="},controller:["$scope","$timeout",function($scope,$timeout){$scope.config=$scope.config||{},$scope.folderChoices=[],$scope.use_examples=!0,$scope.isLogoExpanded=!1,$scope.isExampleExpanded=!1,$scope.isChatIconExpanded=!1,$scope.isFolderThemeExpanded=!1,$scope.toggleExpand=function(propertyName){$scope[propertyName]=!$scope[propertyName]},$scope.config.custom_theme_name||($scope.config.custom_theme_name="Default customization",$scope.config.use_custom_rebranding="false"),$scope.handleImageSelected=function(selectedImage,configProperty){$scope.$broadcast("imageSelectedFromSelector",{configProperty:configProperty,selectedImage:selectedImage})},$scope.$on("imageUploaded",function(event,data){$scope.$broadcast("refreshImageSelector",data)}),$scope.$on("imageDeleted",function(event,data){$scope.$broadcast("refreshImageSelector",data)}),$scope.config.use_custom_rebranding||($scope.config.use_custom_rebranding="false"),$scope.$on("folderCreated",function(){$scope.$broadcast("folderRefreshRequested")}),$scope.$watch("config.custom_theme_name",function(newVal){newVal&&"Default customization"!==newVal&&($scope.config.use_custom_rebranding=!0),""!==newVal&&null!==newVal||($scope.config.use_custom_rebranding=!1)})}]}}]),console.log("[EA] entrepriseAgents.js file loaded"),llmApp.directive("entrepriseAgents",["PLUGIN_PATHS","PythonService","ParamsHelperService","$stateParams","SharedPromiseService",function(PLUGIN_PATHS,PythonService,ParamsHelperService,$stateParams,SharedPromiseService){return{restrict:"E",templateUrl:PLUGIN_PATHS.WEBAPP+"entreprise-agents.html",scope:{config:"=",configForm:"="},controller:["$scope","$timeout",function($scope,$timeout){function makeAgentConfig(agentId){return{agent_id:agentId,agent_system_instructions:"",tool_agent_description:"",enable_stories:!1,stories_workspace:null}}function makeAugLLMConfig(llmId){return{augmented_llm_id:llmId,augmented_llm_description:"",augmented_llm_system_instructions:""}}function syncListFromIds(ids,listProp,idField,factoryFn){if(Array.isArray(ids)){var list=$scope.config[listProp]||[];ids.forEach(function(id){list.some(function(it){return it[idField]===id})||list.push(factoryFn(id))});for(var i=list.length-1;0<=i;i--)ids.includes(list[i][idField])||list.splice(i,1);$scope.config[listProp]=list}}function updateProjectsFromAgents(){var projects=new Set,augLlmIds=(($scope.config.agents_ids||[]).forEach(function(id){id=function projectOf(id){var i;return id&&"string"==typeof id&&0<(i=id.indexOf(":"))?id.slice(0,i):null}(id);id&&projects.add(id)}),$scope.config.augmented_llms_ids||[]);0<augLlmIds.length?(augLlmIds={rootModel:{augmented_llms_ids:augLlmIds,projects_keys:$scope.config.projects_keys}},ParamsHelperService.listSelectedAugmentedLlms(augLlmIds).then(function(result){(result.choices||[]).forEach(function(choice){choice=choice.label.match(/^\[([^\]]+)\]/);choice&&choice[1]&&projects.add(choice[1])}),$scope.config.projects_keys=Array.from(projects)})):$scope.config.projects_keys=Array.from(projects)}function loadCatalogForModal(){var pAgents,tempConfig;$scope.addModal.projects_keys?(tempConfig={projects_keys:[$scope.addModal.projects_keys]},pAgents=ParamsHelperService.do({parameterName:"agents_ids",rootModel:tempConfig}),tempConfig=ParamsHelperService.do({parameterName:"augmented_llms_ids",rootModel:tempConfig}),Promise.all([pAgents,tempConfig]).then(function(res){var cat=[],agentsChoices=res[0]&&res[0].choices?res[0].choices:[],res=res[1]&&res[1].choices?res[1].choices:[];agentsChoices.forEach(function(c){c&&c.value&&cat.push({value:c.value,label:c.label||c.value,type:"AGENT",selected:!1})}),res.forEach(function(c){c&&c.value&&cat.push({value:c.value,label:c.label||c.value,type:"RAG",selected:!1})}),$scope.$applyAsync(function(){$scope.addModal.catalog=cat;var taken=new Set(($scope.config.agents_ids||[]).concat($scope.config.augmented_llms_ids||[]));$scope.addModal.available=cat.filter(function(x){return!taken.has(x.value)})})}).catch(function(err){!function eaDbg(){try{console.debug.apply(console,["[EA]"].concat([].slice.call(arguments)))}catch(e){}try{console.log.apply(console,["[EA]"].concat([].slice.call(arguments)))}catch(e){}}("Error loading catalog:",err),$scope.$applyAsync(function(){$scope.addModal.catalog=[],$scope.addModal.available=[]})})):($scope.addModal.catalog=[],$scope.addModal.available=[])}$scope.config=$scope.config||{},$scope.config.projects_keys=$scope.config.projects_keys||[],$scope.config.agents_ids=$scope.config.agents_ids||[],$scope.config.augmented_llms_ids=$scope.config.augmented_llms_ids||[],$scope.config.tool_agent_configurations=$scope.config.tool_agent_configurations||[],$scope.config.augmented_llms_configurations=$scope.config.augmented_llms_configurations||[],$scope.addModal={isVisible:!1,projects_keys:null,isOpen:!1,filter:"",catalog:[],available:[],selectedItems:[],selectedCount:0,show:function(){this.isVisible=!0,this.projects_keys=null,this.filter="",this.selectedItems=[],this.selectedCount=0,this.catalog=[],this.available=[]},cancel:function(){this.isVisible=!1,this.projects_keys=null,this.filter="",this.selectedItems=[],this.catalog=[],this.available=[]},itemMatchesFilter:function(item){var f;return!$scope.addModal.filter||(f=$scope.addModal.filter.toLowerCase(),item.label&&-1!==item.label.toLowerCase().indexOf(f))||item.type&&-1!==item.type.toLowerCase().indexOf(f)},selectItem:function(item){var idx=this.selectedItems.indexOf(item.value);-1===idx?(this.selectedItems.push(item.value),item.selected=!0):(this.selectedItems.splice(idx,1),item.selected=!1),this.selectedCount=this.selectedItems.length},submit:function(){var self=this,selectedProject=this.projects_keys;this.selectedItems.forEach(function(itemValue){var item=self.catalog.find(function(x){return x.value===itemValue});item&&("AGENT"===item.type?-1===$scope.config.agents_ids.indexOf(item.value)&&$scope.config.agents_ids.push(item.value):-1===$scope.config.augmented_llms_ids.indexOf(item.value)&&$scope.config.augmented_llms_ids.push(item.value))}),selectedProject&&-1===$scope.config.projects_keys.indexOf(selectedProject)&&$scope.config.projects_keys.push(selectedProject),this.cancel()}},$scope.onRowRemoved=function(type,item){var id;item&&(id="AGENT"===type?item.agent_id:item.augmented_llm_id)&&("AGENT"===type?$scope.config.agents_ids=($scope.config.agents_ids||[]).filter(function(x){return x!==id}):$scope.config.augmented_llms_ids=($scope.config.augmented_llms_ids||[]).filter(function(x){return x!==id}),updateProjectsFromAgents())},$scope.$watchCollection("config.agents_ids",function(ids){var taken;syncListFromIds(ids||[],"tool_agent_configurations","agent_id",makeAgentConfig),$scope.addModal.isVisible&&0<$scope.addModal.catalog.length&&(taken=new Set((ids||[]).concat($scope.config.augmented_llms_ids||[])),$scope.addModal.available=$scope.addModal.catalog.filter(function(x){return!taken.has(x.value)}))}),$scope.$watchCollection("config.augmented_llms_ids",function(ids){var taken;syncListFromIds(ids||[],"augmented_llms_configurations","augmented_llm_id",makeAugLLMConfig),$scope.addModal.isVisible&&0<$scope.addModal.catalog.length&&(taken=new Set(($scope.config.agents_ids||[]).concat(ids||[])),$scope.addModal.available=$scope.addModal.catalog.filter(function(x){return!taken.has(x.value)}))}),$scope.$watch("addModal.projects_keys",function(newVal){newVal&&loadCatalogForModal()}),updateProjectsFromAgents()}]}}]),llmApp.directive("userAgents",["PLUGIN_PATHS",function(PLUGIN_PATHS,SUPPORTED_CONNECTIONS){return{restrict:"E",templateUrl:PLUGIN_PATHS.WEBAPP+"user-agents.html",scope:{config:"=",configForm:"="},controller:["$scope","$timeout",function($scope,$timeout){$scope.config=$scope.config||{}}]}}]),llmApp.directive("webApplication",["PLUGIN_PATHS",function(PLUGIN_PATHS,SUPPORTED_CONNECTIONS){return{restrict:"E",templateUrl:PLUGIN_PATHS.WEBAPP+"web-application.html",scope:{config:"=",configForm:"="},controller:["$scope","$timeout",function($scope,$timeout){$scope.config=$scope.config||{}}]}}]),llmApp.directive("autoResize",["$timeout",function($timeout){return{restrict:"A",require:"ngModel",link:function(scope,element,attrs,ngModel){var span=document.createElement("span");function updateWidth(){var text=element.val()||element.attr("placeholder")||"",computedStyles=window.getComputedStyle(element[0]),paddingLeft=(span.style.display="inline-block",span.style.whiteSpace="pre",span.style.direction=computedStyles.direction,span.style.fontFamily=computedStyles.fontFamily,span.style.fontSize=computedStyles.fontSize,span.style.fontWeight=computedStyles.fontWeight,span.style.fontStyle=computedStyles.fontStyle,span.style.letterSpacing=computedStyles.letterSpacing,span.style.textTransform=computedStyles.textTransform,span.style.lineHeight=computedStyles.lineHeight,computedStyles.fontVariant&&(span.style.fontVariant=computedStyles.fontVariant),parseFloat(computedStyles.paddingLeft)||0),computedStyles=parseFloat(computedStyles.paddingRight)||0,text=(span.textContent=text,span.offsetWidth+paddingLeft+computedStyles+10);element[0].style.width=text+"px"}span.style.position="absolute",span.style.visibility="hidden",span.style.whiteSpace="pre",document.body.appendChild(span),element.on("input",updateWidth),ngModel.$render=function(){element.val(ngModel.$viewValue),$timeout(updateWidth,0)},$timeout(updateWidth,0),scope.$on("$destroy",function(){span.remove()})}}}]),llmApp.directive("bsArray",["DescParamsService","PLUGIN_PATHS",function(DescParamsService,PLUGIN_PATHS){return{restrict:"E",scope:{config:"=",configProperty:"@",description:"@",allowWrap:"<",width:"@",labelButton:"@",fieldRequired:"<",formName:"=",labelText:"@",validationMessage:"@"},templateUrl:PLUGIN_PATHS.WEBAPP+"bs-array-template.html",controller:["$scope",function($scope){var defaultValue;$scope.isDragging={},$scope.isArrayEmpty=function(){return!$scope.config[$scope.configProperty]||0===$scope.config[$scope.configProperty].length||$scope.config[$scope.configProperty].every(function(item){return!item||""===item.trim()})},$scope.config[$scope.configProperty]||(defaultValue=DescParamsService.getDefaultValue($scope.configProperty),$scope.config[$scope.configProperty]=defaultValue?angular.copy(defaultValue):[]),$scope.arrayValidationModel=$scope.isArrayEmpty()?"":"valid",$scope.$watch(function(){return $scope.config?$scope.config[$scope.configProperty]:void 0},function(){$scope.arrayValidationModel=$scope.isArrayEmpty()?"":"valid"},!0),$scope.addItem=function(){$scope.config[$scope.configProperty]||($scope.config[$scope.configProperty]=[]),$scope.config[$scope.configProperty].push("")},$scope.removeItem=function(index){$scope.config[$scope.configProperty].splice(index,1)}}]}}]),llmApp.directive("bsCheckbox",["$timeout","DescParamsService","PLUGIN_PATHS",function($timeout,DescParamsService,PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.WEBAPP+"bs-checkbox-template.html",scope:{configProperty:"@",elementId:"@",config:"=",descriptionText:"@"},link:function(scope,element){scope.config[scope.configProperty]||(DescParamsService.getDefaultValue(scope.configProperty)?scope.config[scope.configProperty]=DescParamsService.getDefaultValue(scope.configProperty):scope.config[scope.configProperty]=!1)}}}]),llmApp.directive("bsConnectionCreate",["PythonService","SharedPromiseService","PLUGIN_PATHS",function(PythonService,SharedPromiseService,PLUGIN_PATHS){return{restrict:"E",scope:{config:"=",formName:"@",infoText:"@",labelText:"@",configProperty:"@",context:"@",onSuccess:"&",onDatasetCreated:"&"},templateUrl:PLUGIN_PATHS.WEBAPP+"bs-connection-create-template.html",controller:["$scope","$timeout","$element",function($scope,$timeout,$element){$scope.isConnectionDropdownOpen=!1,$scope.isDropdownHovered=!1,$scope.connectionFilter="",$scope.connections=[],$scope.connectionsByType={},$scope.selectedConnectionObj=null,$scope.datasetNameInput="",$scope.showTooltip=!1,$scope.filterActive=!1,$scope.isConnectionFocused=!1;function connectionDocumentClickHandler(event){$scope.isConnectionDropdownOpen&&!$element[0].contains(event.target)&&$scope.$apply(function(){$scope.closeConnectionDropdownAndRevertText()})}var connectionBlurTimeout=null;$scope.isNameInputFocused=!1,$scope.initConnectionData=function(){SharedPromiseService.getData("connection_selector").then(function(data){data&&data.choices?($scope.connectionsByType={},$scope.connections=[],Object.keys(data.choices).forEach(function(connType){$scope.connectionsByType[connType]=[],data.choices[connType].forEach(function(connName){connName={id:connName,connectionName:connName,connectionDisplayName:connName,connectionType:connType,isHovered:!1};$scope.connections.push(connName),$scope.connectionsByType[connType].push(connName)})}),0<$scope.connections.length?$scope.selectedConnectionObj?$scope.connectionFilter&&$scope.connectionFilter===$scope.selectedConnectionObj.connectionDisplayName||($scope.connectionFilter=$scope.selectedConnectionObj.connectionDisplayName):($scope.selectedConnectionObj=$scope.connections[0],$scope.connectionFilter=$scope.selectedConnectionObj.connectionDisplayName):($scope.selectedConnectionObj=null,$scope.connectionFilter="")):($scope.connections=[],$scope.connectionsByType={})},function(error){$scope.connections=[],$scope.connectionsByType={}})};$scope.closeConnectionDropdownAndRevertText=function(){$scope.isConnectionDropdownOpen=!1,$scope.isConnectionFocused=!1,angular.element(document).off("click",connectionDocumentClickHandler),$scope.selectedConnectionObj&&($scope.connectionFilter=$scope.selectedConnectionObj.connectionDisplayName),$scope.filterActive=!1},$scope.openConnectionDropdown=function(clearFilterOnOpen){connectionBlurTimeout&&$timeout.cancel(connectionBlurTimeout),$scope.isConnectionDropdownOpen?$scope.closeConnectionDropdownAndRevertText():(clearFilterOnOpen&&($scope.connectionFilter=""),$scope.isConnectionDropdownOpen=!0,$scope.filterActive=!1,$timeout(function(){angular.element(document).on("click",connectionDocumentClickHandler)},0))},$scope.selectConnection=function(connection){connectionBlurTimeout&&$timeout.cancel(connectionBlurTimeout),$scope.selectedConnectionObj=connection,$scope.connectionFilter=connection.connectionDisplayName,$scope.isConnectionDropdownOpen=!1,$scope.isConnectionFocused=!1,angular.element(document).off("click",connectionDocumentClickHandler)},$scope.clearConnectionSelection=function(){$scope.connectionFilter="",$scope.selectedConnectionObj=null,$scope.openConnectionDropdown(!0),$element[0].querySelector('input[ng-model="connectionFilter"]').focus()},$scope.handleConnectionInputChange=function(){$scope.selectedConnectionObj&&$scope.connectionFilter!==$scope.selectedConnectionObj.connectionDisplayName&&($scope.selectedConnectionObj=null),$scope.filterActive=!0,!$scope.isConnectionDropdownOpen&&$scope.connectionFilter&&$scope.openConnectionDropdown(!1)},$scope.handleConnectionInputBlur=function(){connectionBlurTimeout=$timeout(function(){$scope.isConnectionDropdownOpen&&$scope.closeConnectionDropdownAndRevertText()},200)},$scope.handleInputFocus=function(){$scope.isConnectionDropdownOpen||$scope.openConnectionDropdown(!1)},$scope.connectionMatchesFilter=function(connection){var filter;return!$scope.filterActive||!$scope.connectionFilter||(filter=$scope.connectionFilter.toLowerCase(),connection.connectionDisplayName.toLowerCase().includes(filter))||connection.connectionType.toLowerCase().includes(filter)},$scope.typeHasMatchingConnections=function(type){return!!$scope.connectionsByType[type]&&$scope.connectionsByType[type].some(c=>$scope.connectionMatchesFilter(c))},$scope.hasMatchingConnections=function(){return 0!==$scope.connections.length&&(!$scope.connectionFilter||$scope.connections.some(c=>$scope.connectionMatchesFilter(c)))},$scope.createDataset=function(){$scope.datasetNameInput&&$scope.selectedConnectionObj&&PythonService.callPythonDo({parameterName:"create_dataset",arguments:{name:$scope.datasetNameInput,connection:$scope.selectedConnectionObj}}).then(function(response){response.success&&($scope.config[$scope.configProperty]=response.dataset.datasetName,$scope.datasetNameInput="",$scope.$emit("datasetCreated"),$timeout(function(){$scope.onDatasetCreated&&$scope.onDatasetCreated(),$scope.onSuccess&&$scope.onSuccess({dataset:response.dataset,property:$scope.configProperty})}))})},$scope.resetForm=function(){$scope.datasetNameInput="",$scope.selectedConnectionObj=null,$scope.connectionFilter="",$scope.isConnectionDropdownOpen=!1,$scope.isConnectionFocused=!1,$scope.isNameInputFocused=!1,angular.element(document).off("click",connectionDocumentClickHandler)},$scope.$on("$destroy",function(){$scope.resetForm(),angular.element(document).off("click",connectionDocumentClickHandler)}),$scope.initConnectionData()}]}}]),llmApp.directive("bsConnectionSelect",["PythonService","ParamsHelperService","$stateParams","PLUGIN_PATHS",function(PythonService,ParamsHelperService,$stateParams,PLUGIN_PATHS){return{restrict:"E",scope:{config:"=",formName:"=",infoText:"@",labelText:"@",description:"@",configProperty:"@",context:"@",onSuccess:"&",onDatasetCreated:"&",fieldRequired:"="},templateUrl:PLUGIN_PATHS.WEBAPP+"bs-connection-select-template.html",controller:["$scope","$timeout","$element",function($scope,$timeout,$element){$scope.isConnectionDropdownOpen=!1,$scope.isDropdownHovered=!1,$scope.connectionFilter="",$scope.connections=[],$scope.connectionsByType={},$scope.selectedConnectionObj=null,$scope.filterActive=!1,$scope.isConnectionFocused=!1;function connectionDocumentClickHandler(event){$scope.isConnectionDropdownOpen&&!$element[0].contains(event.target)&&$scope.$apply(function(){$scope.closeConnectionDropdownAndRevertText()})}let connectionBlurTimeout=null,projectKey=($scope.isNameInputFocused=!1,$stateParams.projectKey);$scope.initConnectionData=function(){var payload={parameterName:$scope.configProperty,projectKey:projectKey};ParamsHelperService.do(payload,$scope.config,{},{}).then(function(data){var connectionName,foundConnection;data&&data.choices?($scope.connectionsByType={},$scope.connections=[],Object.keys(data.choices).forEach(function(connType){$scope.connectionsByType[connType]=[],data.choices[connType].forEach(function(connName){connName={id:connName,connectionName:connName,connectionDisplayName:connName,connectionType:connType,isHovered:!1};$scope.connections.push(connName),$scope.connectionsByType[connType].push(connName)})}),$scope.config[$scope.configProperty]&&(connectionName=$scope.config[$scope.configProperty],(foundConnection=$scope.connections.find(function(d){return d.connectionName===connectionName}))?($scope.selectedConnectionObj=foundConnection,$scope.connectionFilter=foundConnection.connectionDisplayName):($scope.config[$scope.configProperty]=null,$scope.selectedConnectionObj=null,$scope.connectionFilter=""))):($scope.connections=[],$scope.connectionsByType={})},function(error){$scope.connections=[],$scope.connectionsByType={}})};$scope.closeConnectionDropdownAndRevertText=function(){$scope.isConnectionDropdownOpen=!1,$scope.isConnectionFocused=!1,angular.element(document).off("click",connectionDocumentClickHandler),$scope.selectedConnectionObj?$scope.connectionFilter=$scope.selectedConnectionObj.connectionDisplayName:$scope.connectionFilter="",$scope.filterActive=!1},$scope.openConnectionDropdown=function(clearFilterOnOpen){connectionBlurTimeout&&$timeout.cancel(connectionBlurTimeout),$scope.isConnectionDropdownOpen||(clearFilterOnOpen&&($scope.connectionFilter=""),$scope.isConnectionDropdownOpen=!0,$scope.filterActive=!1,$timeout(function(){angular.element(document).on("click",connectionDocumentClickHandler)},0))},$scope.selectConnection=function(connection){connectionBlurTimeout&&$timeout.cancel(connectionBlurTimeout),$scope.selectedConnectionObj=connection,$scope.config[$scope.configProperty]=connection.connectionName,$scope.connectionFilter=connection.connectionDisplayName,$scope.isConnectionDropdownOpen=!1,$scope.isConnectionFocused=!1,angular.element(document).off("click",connectionDocumentClickHandler)},$scope.clearConnectionSelection=function(){$scope.connectionFilter="",$scope.selectedConnectionObj=null,$scope.config[$scope.configProperty]=null,$scope.openConnectionDropdown(!0),$element[0].querySelector('input[ng-model="connectionFilter"]').focus()},$scope.handleConnectionInputChange=function(){$scope.selectedConnectionObj&&$scope.connectionFilter!==$scope.selectedConnectionObj.connectionDisplayName&&($scope.selectedConnectionObj=null,$scope.config[$scope.configProperty]=null),$scope.filterActive=!0,!$scope.isConnectionDropdownOpen&&$scope.connectionFilter&&$scope.openConnectionDropdown(!1)},$scope.handleInputFocus=function(){$scope.isConnectionDropdownOpen||$scope.openConnectionDropdown(!1)},$scope.handleConnectionInputBlur=function(){connectionBlurTimeout=$timeout(function(){$scope.isConnectionDropdownOpen&&$scope.closeConnectionDropdownAndRevertText()},200)},$scope.connectionMatchesFilter=function(connection){var filter;return!$scope.filterActive||!$scope.connectionFilter||(filter=$scope.connectionFilter.toLowerCase(),connection.connectionDisplayName.toLowerCase().includes(filter))||connection.connectionType.toLowerCase().includes(filter)},$scope.typeHasMatchingConnections=function(type){return!!$scope.connectionsByType[type]&&$scope.connectionsByType[type].some(c=>$scope.connectionMatchesFilter(c))},$scope.hasMatchingConnections=function(){return 0!==$scope.connections.length&&(!$scope.connectionFilter||$scope.connections.some(c=>$scope.connectionMatchesFilter(c)))},$scope.resetForm=function(){$scope.datasetNameInput="",$scope.selectedConnectionObj=null,$scope.connectionFilter="",$scope.isConnectionDropdownOpen=!1,$scope.isConnectionFocused=!1,$scope.isNameInputFocused=!1,angular.element(document).off("click",connectionDocumentClickHandler)},$scope.$on("$destroy",function(){$scope.resetForm(),angular.element(document).off("click",connectionDocumentClickHandler)}),$scope.initConnectionData()}]}}]),llmApp.directive("datasetSelector",["PythonService","SharedPromiseService","PLUGIN_PATHS",function(PythonService,SharedPromiseService,PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.WEBAPP+"bs-dataset-select-template.html",scope:{config:"=",formName:"=",labelText:"@",fieldRequired:"=",configProperty:"@",context:"@"},controller:["$scope","$timeout","$element",function($scope,$timeout,$element){$scope.isDropdownHovered=!1,$scope.isDatasetDropdownOpen=!1,$scope.datasetFilter="",$scope.datasets=[],$scope.datasetsByType={},$scope.selectedDataset=null,$scope.filterActive=!1;function documentClickHandler(event){$scope.isDatasetDropdownOpen&&!$element[0].contains(event.target)&&$scope.$apply(function(){$scope.closeDropdownAndRevertText()})}var blurTimeout=null,dataRefreshNeededListener=$scope.$on("dataNeedsRefresh",function(event,payload){SharedPromiseService.refreshData("datasets_names").then(function(updatedData){$scope.initDatasetData()}).catch(function(error){})});$scope.$on("$destroy",function(){dataRefreshNeededListener()}),$scope.initDatasetData=function(){SharedPromiseService.getData("datasets_names").then(function(data){var datasetName,foundDataset;data&&data.choices?($scope.datasetsByType={},$scope.datasets=[],Object.keys(data.choices).forEach(function(datasetType){$scope.datasetsByType[datasetType]=[],data.choices[datasetType].forEach(function(datasetName){datasetName={id:datasetName,datasetName:datasetName,datasetDisplayName:datasetName,datasetType:datasetType,isHovered:!1};$scope.datasets.push(datasetName),$scope.datasetsByType[datasetType].push(datasetName)})}),$scope.config[$scope.configProperty]&&(datasetName=$scope.config[$scope.configProperty],(foundDataset=$scope.datasets.find(function(d){return d.datasetName===datasetName}))?($scope.selectedDataset=foundDataset,$scope.datasetFilter=foundDataset.datasetDisplayName):($scope.config[$scope.configProperty]=null,$scope.selectedDataset=null,$scope.datasetFilter=""))):($scope.datasets=[],$scope.datasetsByType={})},function(error){$scope.datasets=[],$scope.datasetsByType={}})};$scope.closeDropdownAndRevertText=function(){$scope.isDatasetDropdownOpen=!1,angular.element(document).off("click",documentClickHandler),$scope.selectedDataset&&($scope.datasetFilter=$scope.selectedDataset.datasetDisplayName),$scope.filterActive=!1},$scope.openDatasetDropdown=function(clearFilterOnOpen){blurTimeout&&$timeout.cancel(blurTimeout),$scope.isDatasetDropdownOpen?$scope.closeDropdownAndRevertText():(clearFilterOnOpen&&($scope.datasetFilter=""),$scope.isDatasetDropdownOpen=!0,$scope.filterActive=!1,$timeout(function(){angular.element(document).on("click",documentClickHandler)},0))},$scope.selectDataset=function(dataset){blurTimeout&&$timeout.cancel(blurTimeout),$scope.selectedDataset=dataset,$scope.config[$scope.configProperty]=dataset.datasetName,$scope.datasetFilter=dataset.datasetDisplayName,$scope.isDatasetDropdownOpen=!1,angular.element(document).off("click",documentClickHandler)},$scope.clearSelection=function(){$scope.datasetFilter="",$scope.selectedDataset=null,$scope.config[$scope.configProperty]=null,$scope.openDatasetDropdown(),$element[0].querySelector("input").focus()},$scope.handleInputChange=function(){$scope.selectedDataset&&$scope.datasetFilter!==$scope.selectedDataset.datasetDisplayName&&($scope.selectedDataset=null,$scope.config[$scope.configProperty]=null),$scope.filterActive=!0,!$scope.isDatasetDropdownOpen&&$scope.datasetFilter&&$scope.openDatasetDropdown(!1)},$scope.handleInputBlur=function(){blurTimeout=$timeout(function(){$scope.isDatasetDropdownOpen&&$scope.closeDropdownAndRevertText()},200)},$scope.handleInputFocus=function(){$scope.isDatasetDropdownOpen||$scope.openDatasetDropdown(!1)},$scope.datasetMatchesFilter=function(dataset){var filter;return!$scope.filterActive||(filter=$scope.datasetFilter.toLowerCase(),dataset.datasetDisplayName.toLowerCase().includes(filter))||dataset.datasetType.toLowerCase().includes(filter)},$scope.typeHasMatchingDatasets=function(type){return!!$scope.datasetsByType[type]&&$scope.datasetsByType[type].some(d=>$scope.datasetMatchesFilter(d))},$scope.hasMatchingDatasets=function(){return 0!==$scope.datasets.length&&(!$scope.datasetFilter||$scope.datasets.some(d=>$scope.datasetMatchesFilter(d)))},$scope.initDatasetData()}]}}]),llmApp.directive("bsFileUpload",["$q","$timeout","customFileUploaderService","PLUGIN_PATHS",function($q,$timeout,fileService,PLUGIN_PATHS){return{restrict:"E",scope:{config:"=",configProperty:"@",labelText:"@",buttonText:"@",acceptedMimeTypes:"@",uploadTargetType:"@",uploadTargetPath:"@",showPreview:"@",onUploadComplete:"&?",uploadType:"@",expectedFileName:"@",description:"@"},templateUrl:PLUGIN_PATHS.WEBAPP+"bs-file-upload.html",link:function(scope,element,attrs){scope.isDragOver=!1,scope.isUploading=!1,scope.uploadSuccess=null,scope.clientErrorMessage=null,scope.uploadStatusMessage=null,scope.uploadedFiles=[],scope.fileName=null,scope.previewSrc=fileService.getDefaultIconUrl(),scope.shouldShowPreview="false"!==scope.showPreview,scope.uploadType=scope.uploadType||"file",scope.config[scope.configProperty]=scope.config[scope.configProperty]||"",scope.showDeleteTooltip=!1;let fileInputElement=element.find('input[type="file"]')[0],isInitialized=(fileInputElement.multiple="multiple-files"===scope.uploadType||"folder"===scope.uploadType,!1);function getThemeName(){return scope.config=scope.config||{},scope.config.custom_theme_name||(scope.config.custom_theme_name="Default customization"),scope.config.custom_theme_name}function refreshComponentState(shouldClearMessages=!1){if(scope.fileName=null,scope.previewSrc=fileService.getDefaultIconUrl(),scope.uploadedFiles=[],shouldClearMessages&&clearMessages(),scope.config){let themeName=getThemeName();if(themeName)if("Default customization"===themeName&&scope.shouldShowPreview){let file={};"custom_logo_file_name"==scope.configProperty?(file={name:"custom_logo_file_name.png"},scope.previewSrc=window.location.origin+"/plugins/agent-hub/resource/custom-ui-settings/images/custom_logo_file_name.png"):(file={name:"custom_icon_file_name.png"},scope.previewSrc=window.location.origin+"/plugins/agent-hub/resource/custom-ui-settings/images/custom_icon_file_name.png"),void(scope.uploadedFiles=[file])}else fileService.fetchUploadedFiles(scope.uploadTargetType).then(response=>{var response=fileService.getAllFilesForTheme(response.data,themeName);let foundFile=null;if(scope.expectedFileName)foundFile=response.find(file=>file.name===scope.expectedFileName);else{let storedFileName=scope.config[scope.configProperty];storedFileName&&(foundFile=response.find(file=>file.name===storedFileName))}foundFile?(response=foundFile.name,scope.config[scope.configProperty]=response,scope.fileName=response,scope.shouldShowPreview&&fileService.isImageFileByName(response)&&(scope.previewSrc=`${window.location.origin}/local/static/answers/${themeName}/images/${response}?v=`+(new Date).getTime()),scope.uploadedFiles=[foundFile]):(scope.fileName=null,scope.previewSrc=fileService.getDefaultIconUrl(),scope.uploadedFiles=[])}).catch(error=>{scope.config[scope.configProperty]=null,scope.fileName=null,scope.previewSrc=fileService.getDefaultIconUrl(),scope.uploadedFiles=[]});else scope.config[scope.configProperty]=null}}function clearMessages(){$timeout(()=>{scope.clientErrorMessage=null,scope.uploadStatusMessage=null,scope.uploadSuccess=null},0)}function updateUploadStatus(message){$timeout(()=>{scope.uploadStatusMessage=message},0)}function hideMessageAfterDelay(){$timeout(()=>{scope.uploadStatusMessage=null,scope.uploadSuccess=null},5e3)}scope.triggerFileInput=function(){scope.isUploading||fileInputElement.click()},scope.handleFileSelect=function(files){if(files&&files.length&&!scope.isUploading){scope.isUploading=!0,scope.clientErrorMessage=null,updateUploadStatus("Validating files...");let{validFiles,errors,previewFile}=function validateFiles(files){files=Array.from(files);let defaultAllowedFiles=fileService.getDefaultAllowedFiles(),result={validFiles:[],errors:[],previewFile:null};return files.forEach(file=>{var{name:fileName,type:fileType}=file,lowerCaseFileName=fileName.toLowerCase(),lowerCaseFileName=fileService.isImageFile(file)?defaultAllowedFiles.image:defaultAllowedFiles[lowerCaseFileName];scope.acceptedMimeTypes?.includes("image/")&&!fileService.isImageFile(file)?result.errors.push("Unsupported file type. Please upload a file in .png, .jpg, or .jpeg format."):scope.expectedFileName&&scope.expectedFileName!==fileName?result.errors.push(`Invalid file.Please upload a file named ${scope.expectedFileName} in .css format.`):fileService.isImageFile(file)&&!fileService.isAcceptedImageType(fileType)?result.errors.push(`Invalid image type: ${fileType}. Only JPG, JPEG and PNG are supported.`):lowerCaseFileName?(result.validFiles.push({file:file,folder:lowerCaseFileName.folder||""}),"multiple-files"!==scope.uploadType&&scope.shouldShowPreview&&fileService.isImageFile(file)&&!result.previewFile&&(result.previewFile=file)):result.errors.push(`Invalid file name: ${fileName}.`)}),result}(files);0<errors.length?$timeout(()=>{scope.isUploading=!1,scope.clientErrorMessage=errors.join("; "),$timeout(()=>{scope.uploadStatusMessage=""},0)},0):(previewFile&&((files=new FileReader).onload=e=>scope.$applyAsync(()=>scope.previewSrc=e.target.result),files.readAsDataURL(previewFile)),function performUpload(validFiles,themeName){if(0===validFiles.length)scope.isUploading=!1,updateUploadStatus("No valid files to upload.");else{var primaryFile=validFiles[0].file;let fileNameToRegister,newFolderName=(fileNameToRegister=scope.expectedFileName||primaryFile.name,updateUploadStatus("Ensuring folder structure exists..."),fileService.generateAppFilename());updateUploadStatus("Creating new folder..."),fileService.createFolder("LOCAL_STATIC",newFolderName,"").then(()=>(scope.config.custom_theme_name=newFolderName,scope.$emit("folderCreated"),newFolderName)).catch(error=>{if(error.data?.detailedMessage?.includes("already exists"))return scope.$emit("folderCreated"),newFolderName;throw error}).then(actualThemeName=>(scope.config.custom_theme_name=actualThemeName,fileService.ensureThemeFolderExists(scope.uploadTargetType,actualThemeName,"answers").then(themePath=>{var folderPromises=[...new Set(validFiles.map(vf=>vf.folder).filter(Boolean))].map(folder=>fileService.ensureSubFolderExists(scope.uploadTargetType,themePath,folder));return $q.all(folderPromises).then(()=>themePath)}))).then(themePath=>{updateUploadStatus(`Uploading ${validFiles.length} file(s)...`);var uploadPromises=validFiles.map(({file,folder},index)=>{let fileForUpload=file;return 0!==index||scope.expectedFileName||(fileForUpload=new File([file],fileNameToRegister,{type:file.type})),fileService.uploadFile(scope.uploadTargetType,folder?themePath+"/"+folder:themePath,fileForUpload)});return $q.all(uploadPromises)}).then(results=>{scope.uploadSuccess=!0,updateUploadStatus("Upload successful!"),scope.config[scope.configProperty]=fileNameToRegister,refreshComponentState(),scope.$emit("imageUploaded",{configProperty:scope.configProperty,fileName:fileNameToRegister,themeName:getThemeName()}),scope.onUploadComplete&&scope.onUploadComplete({success:!0,results:results}),hideMessageAfterDelay()}).catch(error=>{scope.uploadSuccess=!1,updateUploadStatus("Upload failed: "+(error.data?.detailedMessage||error.message||"Unknown error")),scope.onUploadComplete&&scope.onUploadComplete({success:!1,error:error})}).finally(()=>{scope.isUploading=!1})}}(validFiles,getThemeName()),fileInputElement.value=null)}},scope.removeFile=function(fileNameToRemove){var file=scope.uploadedFiles.find(f=>f.name===fileNameToRemove);file&&confirm(`Are you sure you want to delete "${fileNameToRemove}"?`)&&(scope.isUploading=!0,updateUploadStatus(`Deleting ${fileNameToRemove}...`),fileService.deleteFile(scope.uploadTargetType,file.path).then(()=>{scope.uploadSuccess=!0,updateUploadStatus(`"${fileNameToRemove}" deleted.`),refreshComponentState(),scope.$emit("imageDeleted",{configProperty:scope.configProperty,fileName:fileNameToRemove,themeName:getThemeName()}),scope.onUploadComplete&&scope.onUploadComplete({success:!0,deletedFileName:fileNameToRemove}),hideMessageAfterDelay()}).catch(error=>{scope.uploadSuccess=!1,updateUploadStatus("Error deleting file: "+(error.message||"Unknown error"))}).finally(()=>{scope.isUploading=!1}))},scope.clearMessages=clearMessages,scope.$watch("config.custom_theme_name",function(newThemeName,oldThemeName){newThemeName!==oldThemeName&&refreshComponentState(!0)}),function initializeComponent(){isInitialized||(!function setupDragAndDrop(){let dropArea=element.find(".drag-drop-area");dropArea.on("dragover dragenter",e=>{e.preventDefault(),scope.isDragOver||scope.$apply(()=>scope.isDragOver=!0)}),dropArea.on("dragleave drop",e=>{e.preventDefault(),scope.isDragOver&&scope.$apply(()=>scope.isDragOver=!1)}),dropArea.on("drop",e=>scope.handleFileSelect(e.originalEvent.dataTransfer.files)),element.on("$destroy",()=>dropArea.off("dragover dragenter dragleave drop"))}(),refreshComponentState(),isInitialized=!0)}(),scope.$on("imageSelectedFromSelector",function(event,data){data.configProperty===scope.configProperty&&$timeout(function(){refreshComponentState(!0)},100)})}}}]),llmApp.directive("bsImageSelect",["customFileUploaderService","$timeout","PLUGIN_PATHS",function(customFileUploaderService,$timeout,PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.WEBAPP+"bs-image-select.html",scope:{config:"=",configProperty:"@",labelText:"@",onImageSelected:"&?"},link:function(scope,element){function getThemeName(){return scope.config?.custom_theme_name||"Default customization"}function updateScrollButtons(){var carousel=element.find("#imageCarousel")[0];carousel&&(scope.canScrollLeft=0<carousel.scrollLeft,scope.canScrollRight=carousel.scrollLeft<carousel.scrollWidth-carousel.clientWidth)}function updateScrollDots(){var carousel=element.find("#imageCarousel")[0];if(!carousel||scope.availableImages.length<=4)scope.scrollDots=[];else{var scrollLeft=carousel.scrollLeft,carousel=carousel.scrollWidth-carousel.clientWidth;if(carousel<=0)scope.scrollDots=[];else{var numDots=Math.min(5,Math.max(3,Math.ceil(scope.availableImages.length/3))),segmentSize=carousel/(numDots-1);let activeDotIndex=0;for(let i=0;i<numDots;i++){var segmentStart=i*segmentSize,segmentEnd=(i+1)*segmentSize;if(segmentStart<=scrollLeft&&(scrollLeft<segmentEnd||i===numDots-1)){activeDotIndex=i;break}}scope.scrollDots=[];for(let i=0;i<numDots;i++)scope.scrollDots.push({active:i===activeDotIndex,index:i})}}}function refreshAvailableImages(silent=!1){let themeName=getThemeName();themeName&&"Default customization"!==themeName?(silent||(scope.isLoading=!0),customFileUploaderService.fetchUploadedFiles("LOCAL_STATIC").then(response=>{response=customFileUploaderService.getAllFilesForTheme(response.data,themeName).filter(file=>{var pathParts=file.path.split("/");return 4<=pathParts.length&&"answers"===pathParts[0]&&pathParts[1]===themeName&&"images"===pathParts[2]&&customFileUploaderService.isImageFileByName(file.name)}).map(file=>({name:file.name,url:window.location.origin+`/local/static/${file.path}?v=`+(new Date).getTime(),path:file.path}));scope.availableImages=response,$timeout(function(){updateScrollButtons(),updateScrollDots()},100)}).catch(error=>{scope.availableImages=[]}).finally(()=>{scope.isLoading=!1})):(scope.availableImages=[],scope.isLoading=!1)}scope.availableImages=[],scope.isLoading=!1,scope.selectedImageName=null,scope.canScrollLeft=!1,scope.canScrollRight=!1,scope.scrollDots=[],scope.shouldShowSelector=function(){var themeName=getThemeName();return!(!themeName||"Default customization"===themeName||!scope.isLoading&&0===scope.availableImages.length)},scope.scrollLeft=function(){var carousel=element.find("#imageCarousel")[0];carousel&&(carousel.scrollLeft-=120,$timeout(function(){updateScrollButtons(),updateScrollDots()},100))},scope.scrollRight=function(){var carousel=element.find("#imageCarousel")[0];carousel&&(carousel.scrollLeft+=120,$timeout(function(){updateScrollButtons(),updateScrollDots()},100))},scope.selectImage=function(image){scope.selectedImageName=image.name,scope.config[scope.configProperty]=image.name,scope.onImageSelected&&scope.onImageSelected({selectedImage:image,configProperty:scope.configProperty})},scope.isImageSelected=function(image){return scope.config[scope.configProperty]===image.name},scope.$watch("config.custom_theme_name",function(newTheme,oldTheme){newTheme!==oldTheme&&refreshAvailableImages()}),scope.$on("refreshImageSelector",function(event,data){var currentTheme=getThemeName();data.themeName&&data.themeName!==currentTheme||$timeout(function(){refreshAvailableImages(!0)},500)}),scope.$on("folderRefreshRequested",function(){$timeout(function(){refreshAvailableImages()},1e3)}),function initialize(){refreshAvailableImages();var currentValue=scope.config[scope.configProperty];currentValue&&(scope.selectedImageName=currentValue),$timeout(function(){var carousel=element.find("#imageCarousel")[0];carousel&&carousel.addEventListener("scroll",function(){scope.$apply(function(){updateScrollButtons(),updateScrollDots()})})},500)}()}}}]),llmApp.directive("bsKeyValueList",["PLUGIN_PATHS",function(PLUGIN_PATHS){return{restrict:"E",scope:{config:"=",mappingsArray:"@",description:"@",labelText:"@",buttonLabel:"@",keyPlaceholder:"@",valuePlaceholder:"@"},templateUrl:PLUGIN_PATHS.WEBAPP+"bs-key-value-list.html",link:function(scope,element){scope.languageMappings||(scope.languageMappings=scope.config&&scope.config[scope.mappingsArray]?scope.config[scope.mappingsArray]:[]),scope.isArray=Array.isArray(scope.languageMappings);var container=element[0].querySelector(".language-mappings-container"),draggedItem=null,draggedIndex=null;function initDragHandlers(){container.querySelectorAll(".language-mapping-item").forEach(function(item,index){item.addEventListener("dragstart",function(e){draggedItem=item,draggedIndex=index,e.dataTransfer.setData("text/plain",index),e.dataTransfer.effectAllowed="move",setTimeout(function(){item.classList.add("dragging"),item.style.opacity="0.5"},0)}),item.addEventListener("dragend",function(){cleanupStyling(),draggedIndex=draggedItem=null}),item.addEventListener("dragover",function(e){var rect;e.preventDefault(),e.dataTransfer.dropEffect="move",item!==draggedItem&&(function cleanupIndicators(){container.querySelectorAll(".language-mapping-item").forEach(function(item){item.classList.remove("drop-before"),item.classList.remove("drop-after")})}(),rect=item.getBoundingClientRect(),e.clientY<rect.top+rect.height/2?item.classList.add("drop-before"):item.classList.add("drop-after"))}),item.addEventListener("drop",function(e){var sourceIndex,targetIndex,rect,dropIndex;e.preventDefault(),e.stopPropagation(),null!==draggedItem&&(sourceIndex=draggedIndex,targetIndex=index,rect=item.getBoundingClientRect(),dropIndex=e.clientY<rect.top+rect.height/2?targetIndex:targetIndex+1,scope.$applyAsync(function(){moveItem(sourceIndex,dropIndex)}),cleanupStyling())})})}function cleanupStyling(){container.querySelectorAll(".language-mapping-item").forEach(function(item){item.classList.remove("drop-before"),item.classList.remove("drop-after"),item.classList.remove("dragging"),item.style.opacity="1"})}function moveItem(fromIndex,toIndex){var itemToMove,newMappings;fromIndex!==toIndex&&(itemToMove=scope.languageMappings[fromIndex],(newMappings=scope.languageMappings.slice()).splice(fromIndex,1),fromIndex<toIndex&&toIndex--,newMappings.splice(toIndex,0,itemToMove),scope.languageMappings=newMappings)}scope.$watch("config[mappingsArray]",function(newValue){newValue&&Array.isArray(newValue)&&(scope.languageMappings=newValue)}),container.addEventListener("dragover",function(e){e.preventDefault(),e.dataTransfer.dropEffect="move"}),container.addEventListener("drop",function(e){e.target===container&&(e.preventDefault(),e.stopPropagation(),null!==draggedItem)&&(scope.$applyAsync(function(){moveItem(draggedIndex,scope.languageMappings.length)}),cleanupStyling())}),scope.$watchCollection("languageMappings",function(){setTimeout(function(){initDragHandlers()},0)}),setTimeout(function(){initDragHandlers()},0)},controller:["$scope",function($scope){$scope.addMapping=function(){$scope.isArray?$scope.languageMappings.push({from:"",to:""}):$scope.languageMappings[""]=""},$scope.removeMapping=function(indexOrKey){$scope.isArray?$scope.languageMappings.splice(indexOrKey,1):delete $scope.languageMappings[indexOrKey]},$scope.updateKey=function(oldKey,newKey){var value;oldKey!==newKey&&(newKey&&""!==newKey.trim()?(newKey=newKey.trim(),$scope.languageMappings.hasOwnProperty(newKey)&&newKey!==oldKey||(value=$scope.languageMappings[oldKey],delete $scope.languageMappings[oldKey],$scope.languageMappings[newKey]=value)):""!==oldKey&&delete $scope.languageMappings[oldKey])}}]}}]),llmApp.directive("bsLlmSelect",["ParamsHelperService","PLUGIN_PATHS","$stateParams",function(ParamsHelperService,PLUGIN_PATHS,$stateParams){return{restrict:"E",templateUrl:PLUGIN_PATHS.WEBAPP+"bs-llm-select-template.html",scope:{config:"=",formName:"=",labelText:"@",fieldRequired:"=",configProperty:"@",context:"@",description:"@",purpose:"@"},controller:["$scope","$timeout","$element",function($scope,$timeout,$element){$scope.isDropdownHovered=!1,$scope.isLLMDropdownOpen=!1,$scope.llmFilter="",$scope.llms=[],$scope.llmsByType={},$scope.selectedLLM=null,$scope.filterActive=!1,$scope.showCopyTooltip=!1,$scope.isLLMFocused=!1;function llmDocumentClickHandler(event){$scope.isLLMDropdownOpen&&!$element[0].contains(event.target)&&$scope.$apply(function(){$scope.closeLLMDropdownAndRevertText()})}var llmBlurTimeout=null,projectKey=($scope.selectedLLM=null,$stateParams.projectKey);$scope.copyLLMValue=function(){if($scope.selectedLLM&&$scope.selectedLLM.llmId){var textArea=document.createElement("textarea");textArea.value=$scope.selectedLLM.llmId,document.body.appendChild(textArea),textArea.select();try{document.execCommand("copy")}catch(err){}document.body.removeChild(textArea)}},$scope.initLLMData=function(){var payload={parameterName:"llm_id",projectKey:projectKey};$scope.purpose&&(payload.purpose=$scope.purpose),ParamsHelperService.do(payload,$scope.config,{},{}).then(function(data){var configProp,llmId,foundLLM;data&&data.choices?($scope.llmsByType={},$scope.llms=[],Object.keys(data.choices).forEach(function(llmType){$scope.llmsByType[llmType]=[],data.choices[llmType].forEach(function(llm){llm={id:llm.value,llmId:llm.value,llmDisplayName:llm.label,llmType:llmType,connection:llm.connection,model:llm.model,isHovered:!1};$scope.llms.push(llm),$scope.llmsByType[llmType].push(llm)})}),configProp=$scope.configProperty||"llm_id",$scope.config[configProp]?(llmId=$scope.config[configProp],(foundLLM=$scope.llms.find(function(l){return l.llmId===llmId}))?($scope.selectedLLM=foundLLM,$scope.llmFilter=foundLLM.llmDisplayName):($scope.config[configProp]=null,$scope.selectedLLM=null,$scope.llmFilter="")):0<$scope.llms.length||($scope.llmFilter="")):($scope.llms=[],$scope.llmsByType={},$scope.selectedLLM=null,$scope.llmFilter="")},function(error){console.error("Error loading LLMs:",error),$scope.llms=[],$scope.llmsByType={},$scope.selectedLLM=null,$scope.llmFilter=""})};$scope.closeLLMDropdownAndRevertText=function(){$scope.isLLMDropdownOpen=!1,$scope.isLLMFocused=!1,angular.element(document).off("click",llmDocumentClickHandler),$scope.selectedLLM&&($scope.llmFilter=$scope.selectedLLM.llmDisplayName),$scope.filterActive=!1},$scope.openLLMDropdown=function(clearFilter){llmBlurTimeout&&$timeout.cancel(llmBlurTimeout),$scope.isLLMDropdownOpen?$scope.closeLLMDropdownAndRevertText():(clearFilter&&($scope.llmFilter=""),$scope.isLLMDropdownOpen=!0,$scope.filterActive=!1,$timeout(function(){angular.element(document).on("click",llmDocumentClickHandler)},0))},$scope.selectLLM=function(llm){llmBlurTimeout&&$timeout.cancel(llmBlurTimeout),$scope.selectedLLM=llm,$scope.config[$scope.configProperty||"llm_id"]=llm.llmId,$scope.llmFilter=llm.llmDisplayName,$scope.isLLMDropdownOpen=!1,$scope.isLLMFocused=!1,angular.element(document).off("click",llmDocumentClickHandler)},$scope.clearLLMSelection=function(){$scope.llmFilter="",$scope.selectedLLM=null,$scope.config[$scope.configProperty||"llm_id"]=null,$scope.openLLMDropdown(null,!0),$element[0].querySelector("input").focus()},$scope.handleLLMInputChange=function(){$scope.selectedLLM&&$scope.llmFilter!==$scope.selectedLLM.llmDisplayName&&($scope.selectedLLM=null,$scope.config[$scope.configProperty||"llm_id"]=null),$scope.filterActive=!0,!$scope.isLLMDropdownOpen&&$scope.llmFilter&&$scope.openLLMDropdown(null,!1)},$scope.handleLLMInputBlur=function(){llmBlurTimeout=$timeout(function(){$scope.isLLMDropdownOpen&&$scope.closeLLMDropdownAndRevertText()},200)},$scope.handleInputFocus=function(){$scope.isLLMDropdownOpen||$scope.openLLMDropdown(!1)},$scope.llmMatchesFilter=function(llm){var filter;return!$scope.filterActive||!$scope.llmFilter||(filter=$scope.llmFilter.toLowerCase(),llm.llmDisplayName.toLowerCase().includes(filter))||llm.llmType.toLowerCase().includes(filter)||llm.connection&&llm.connection.toLowerCase().includes(filter)||llm.model&&llm.model.toLowerCase().includes(filter)},$scope.typeHasMatchingLLMs=function(type){return!!$scope.llmsByType[type]&&$scope.llmsByType[type].some(l=>$scope.llmMatchesFilter(l))},$scope.hasMatchingLLMs=function(){return 0!==$scope.llms.length&&(!$scope.llmFilter||$scope.llms.some(l=>$scope.llmMatchesFilter(l)))},$scope.$on("$destroy",function(){angular.element(document).off("click",llmDocumentClickHandler)}),$scope.initLLMData()}]}}]),llmApp.directive("bsMultiselect",["PythonService","ParamsHelperService","$stateParams","PLUGIN_PATHS",function(PythonService,ParamsHelperService,$stateParams,PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.WEBAPP+"bs-multiselect-template.html",scope:{config:"=",formName:"@",labelText:"@",configProperty:"@",description:"@",folderChoices:"=?",triggerParameter:"=",width:"@?",maxHeightThreshold:"@?",rootModel:"="},controller:["$scope","$timeout","$element",function($scope,$timeout,$element){$scope.maxHeightThreshold=$scope.maxHeightThreshold||82,$scope.isDropdownOpen=!1,$scope.folders=[],$scope.config=$scope.config||{},$scope.selectedItems=[],$scope.showAllItems=!1,$scope.exceedsMaxHeight=!1,$scope.visibleItemCount=0,$scope.remainingItemCount=0,$scope.searchFilter="",$scope.filterActive=!1,$scope.isSearchFocused=!1,$scope.isDropdownHovered=!1;let searchBlurTimeout=null;$scope.toggleShowAll=function(){$scope.showAllItems=!$scope.showAllItems};var projectKey=$stateParams.projectKey;$scope.openDropdownWithSearch=function(clearFilter){searchBlurTimeout&&$timeout.cancel(searchBlurTimeout),clearFilter&&($scope.searchFilter=""),$scope.isDropdownOpen||($scope.isDropdownOpen=!0,$scope.filterActive=!1,addDocumentClickHandler())},$scope.handleSearchInputFocus=function(){searchBlurTimeout&&($timeout.cancel(searchBlurTimeout),searchBlurTimeout=null),$scope.isSearchFocused=!0,$scope.isDropdownOpen||$scope.openDropdownWithSearch(!1)},$scope.handleSearchInputChange=function(){$scope.filterActive=!0,!$scope.isDropdownOpen&&$scope.searchFilter&&$scope.openDropdownWithSearch(!1)},$scope.handleSearchInputBlur=function(){$scope.isSearchFocused=!1,searchBlurTimeout=$timeout(()=>{!$scope.isDropdownHovered&&$scope.isDropdownOpen&&closeDropdownAndRevertText()},150)},$scope.clearSearchFilter=function(){$scope.searchFilter="",$scope.filterActive=!1,$timeout(()=>{var input=angular.element(`#${$scope.configProperty}-search-input`);input.length&&input[0].focus()},0)},$scope.folderFilterFn=function(folder){return!$scope.filterActive||!!folder?.label&&(!$scope.searchFilter||folder.label.toLowerCase().includes($scope.searchFilter.toLowerCase()))},$scope.typeHasMatchingFolders=function(type){return!!$scope.foldersByType[type]&&$scope.foldersByType[type].some($scope.folderFilterFn)};let closeDropdownAndRevertText=function(){$scope.isDropdownOpen&&($scope.isDropdownOpen=!1,$scope.isSearchFocused=!1,removeDocumentClickHandler(),$scope.searchFilter="",$scope.filterActive=!1)};function documentClickHandler(event){$scope.isDropdownOpen&&!$element[0].contains(event.target)&&$scope.$apply(function(){closeDropdownAndRevertText()})}let addDocumentClickHandler=function(){$timeout(()=>angular.element(document).on("click",documentClickHandler),0)},removeDocumentClickHandler=function(){angular.element(document).off("click",documentClickHandler)};function normalizeDataFormat(data){if(Array.isArray(data))return{General:data.map(item=>({value:item.value,label:item.label,type:"General"}))};if(data&&"object"==typeof data){let normalized={};return Object.keys(data).forEach(function(type){Array.isArray(data[type])&&(normalized[type]=data[type].map(item=>"string"==typeof item?{value:item,label:item,type:type}:item&&"object"==typeof item&&item.value&&item.label?{value:item.value,label:item.label,type:type}:null).filter(item=>null!==item))}),normalized}return{}}function initializeSelectedFolders(){var folderIds;$scope.selectedItems=[],$scope.config[$scope.configProperty]&&Array.isArray($scope.config[$scope.configProperty])?((folderIds=$scope.config[$scope.configProperty]).forEach(function(folderId){var foundFolder=$scope.folders.find(function(folder){return folder.value===folderId});foundFolder&&$scope.selectedItems.push(foundFolder)}),0<folderIds.length&&0===$scope.selectedItems.length&&($scope.config[$scope.configProperty]=[])):$scope.config[$scope.configProperty]||($scope.config[$scope.configProperty]=[]),checkContentHeight()}function checkContentHeight(){var retries=0;$timeout(function attemptMeasurement(){var container=document.getElementById($scope.configProperty+"-items-container");if(container){var children=container.children;if(0===children.length)retries<20&&$timeout(attemptMeasurement,100*++retries);else if(0===children[0].offsetHeight&&retries<20)$timeout(attemptMeasurement,100*++retries);else{var visibleCount=children.length;for(let i=0;i<children.length;i++){var item=children[i];if(item.offsetTop+item.offsetHeight>$scope.maxHeightThreshold){visibleCount=i;break}}$scope.visibleItemCount=visibleCount,$scope.exceedsMaxHeight=visibleCount<children.length,$scope.remainingItemCount=children.length-visibleCount,$scope.exceedsMaxHeight||($scope.showAllItems=!1)}}else retries<20&&$timeout(attemptMeasurement,100*++retries)},0)}function updateConfigValue(){$scope.config[$scope.configProperty]=$scope.selectedItems.map(function(item){return item.value})}$scope.getVisibleItems=function(){return $scope.selectedItems.length<=3||$scope.showAllItems?$scope.selectedItems:$scope.selectedItems.slice(0,3)},$scope.initFolderData=function(){var normalizedData;$scope.folderChoices?(normalizedData=normalizeDataFormat($scope.folderChoices),$scope.foldersByType=normalizedData,$scope.folders=[],Object.keys($scope.foldersByType).forEach(function(type){$scope.folders=$scope.folders.concat($scope.foldersByType[type])}),initializeSelectedFolders()):(normalizedData={parameterName:$scope.configProperty,projectKey:projectKey,rootModel:$scope.rootModel||$scope.config},ParamsHelperService.do(normalizedData).then(function(data){data&&data.choices?(data=normalizeDataFormat(data.choices),$scope.foldersByType=data,$scope.folders=[],Object.keys($scope.foldersByType).forEach(function(type){$scope.folders=$scope.folders.concat($scope.foldersByType[type])}),initializeSelectedFolders()):($scope.foldersByType={},$scope.folders=[])},function(error){$scope.foldersByType={},$scope.folders=[]}))},$scope.toggleDropdown=function(event){event&&(event.stopPropagation(),event.preventDefault()),searchBlurTimeout&&($timeout.cancel(searchBlurTimeout),searchBlurTimeout=null),$scope.isDropdownOpen?closeDropdownAndRevertText():($scope.openDropdownWithSearch(!1),$timeout(()=>{var input=$element[0].querySelector("input");input&&input.focus()},0))},$scope.isItemSelected=function(item){return $scope.selectedItems.some(function(selectedItem){return selectedItem.value===item.value})},$scope.toggleItemSelection=function(item){searchBlurTimeout&&$timeout.cancel(searchBlurTimeout),$scope.isItemSelected(item)?$scope.removeItem(item):($scope.selectedItems.push(item),updateConfigValue())},$scope.removeItem=function(item,event){event&&event.stopPropagation(),$scope.selectedItems=$scope.selectedItems.filter(function(selectedItem){return selectedItem.value!==item.value}),updateConfigValue()},$scope.clearAllItems=function(){$scope.selectedItems=[],updateConfigValue(),checkContentHeight()},$scope.$watch("triggerParameter",function(newValue,oldValue){newValue!==oldValue&&$scope.initFolderData()},!0),$scope.$on("$destroy",function(){angular.element(window).off("resize"),removeDocumentClickHandler(),searchBlurTimeout&&$timeout.cancel(searchBlurTimeout)}),$scope.initFolderData(),$scope.$watch("selectedItems",function(newValue,oldValue){newValue!==oldValue&&checkContentHeight()},!0)}]}}]),llmApp.directive("bsNumber",["PLUGIN_PATHS","$timeout",function(PLUGIN_PATHS,$timeout){return{restrict:"E",scope:{modelValue:"=",labelText:"@",minValue:"@",maxValue:"@",placeholder:"@",zeroMessage:"@",warningMessage:"@",description:"@",numberType:"@",subLabel:"@",defaultValue:"@",fieldRequired:"=?",configProperty:"@",formName:"="},templateUrl:PLUGIN_PATHS.WEBAPP+"bs-number-template.html",controller:["$scope","$interval","$timeout",function($scope,$interval,$timeout){var intervalPromise,parsedDefault;$scope.inputFocused=!1,$scope.minValueNum=parseFloat($scope.minValue)||0,$scope.maxValueNum=parseFloat($scope.maxValue)||100,$scope.numberType||($scope.numberType="DOUBLE"),$scope.step="INT"===$scope.numberType?"1":"any",null!=$scope.modelValue&&!isNaN($scope.modelValue)||(void 0===$scope.defaultValue||isNaN(parseFloat($scope.defaultValue))?$scope.modelValue="INT"===$scope.numberType?Math.round($scope.minValueNum):$scope.minValueNum:(parsedDefault=parseFloat($scope.defaultValue),$scope.modelValue="INT"===$scope.numberType?Math.round(parsedDefault):parsedDefault)),$scope.isValidValue=function(){return!$scope.fieldRequired||null!=$scope.modelValue&&!isNaN($scope.modelValue)&&""!==$scope.modelValue},$scope.incrementValue=function(){var step="INT"===$scope.numberType?1:.1,step=(parseFloat($scope.modelValue)||0)+step;(!$scope.maxValue||step<=parseFloat($scope.maxValue))&&($scope.modelValue="INT"===$scope.numberType?Math.round(step):parseFloat(step.toFixed(1)))},$scope.decrementValue=function(){var step="INT"===$scope.numberType?1:.1,step=(parseFloat($scope.modelValue)||0)-step;(!$scope.minValue||step>=parseFloat($scope.minValue))&&($scope.modelValue="INT"===$scope.numberType?Math.round(step):parseFloat(step.toFixed(1)))},$scope.startIncrementing=function(){$scope.stopActions(),$scope.incrementValue(),intervalPromise=$interval($scope.incrementValue,100)},$scope.startDecrementing=function(){$scope.stopActions(),$scope.decrementValue(),intervalPromise=$interval($scope.decrementValue,100)},$scope.stopActions=function(){$interval.cancel(intervalPromise)},$scope.onInputChange=function(){$timeout(function(){"INT"===$scope.numberType&&null!=$scope.modelValue&&($scope.modelValue=Math.round(parseFloat($scope.modelValue)))},0)},$scope.$watch("modelValue",function(newVal){var newVal=parseFloat(newVal),belowMin=$scope.minValue&&newVal<parseFloat($scope.minValue),aboveMax=$scope.maxValue&&newVal>parseFloat($scope.maxValue),newVal=isNaN(newVal);$scope.invalidInput=!!(newVal||belowMin||aboveMax)}),$scope.$on("$destroy",function(){$scope.stopActions()})}]}}]),llmApp.directive("bsObjectList",["PythonService","ParamsHelperService","DescParamsService","PLUGIN_PATHS","SharedPromiseService",function(PythonService,ParamsHelperService,DescParamsService,PLUGIN_PATHS,SharedPromiseService){return{restrict:"E",templateUrl:PLUGIN_PATHS.WEBAPP+"bs-object-list-template.html",scope:{config:"=",formName:"=",configProperty:"@",rootModel:"=",collapsableContentIds:"=",headerParam:"@?",hideHeaderField:"=?",anchorPrefix:"@?",collapsible:"=?",collapseByDefault:"=?",onRemove:"&?",buttonLabel:"@?",description:"@?",headerLabel:"@?"},controller:["$scope","$compile",function($scope,$compile){$scope.fieldConfig=DescParamsService.getParamConfigByName($scope.configProperty),$scope.anchorPrefix=$scope.anchorPrefix||$scope.configProperty||"row",$scope.collapsible=!!$scope.collapsible,$scope.collapseByDefault=!!$scope.collapseByDefault,$scope._collapsed=[],$scope.getCollapsableContentDivs=function(param,item){let ids=$scope.collapsableContentIds;var visibleHeaderFields,headerIndex;return!(ids&&Array.isArray(ids)&&ids.includes(param.name))||0===(visibleHeaderFields=$scope.fieldConfig.subParams.filter(p=>ids.includes(p.name)&&$scope.isFieldVisible(p,item))).length||-1===(headerIndex=visibleHeaderFields.findIndex(p=>p.name===param.name))?{}:{"!bg-zinc-50":!0,"!p-4":!0,"!rounded-t-lg":0===headerIndex,"!rounded-b-lg":headerIndex===visibleHeaderFields.length-1}};let _headerChoicesByValue={};function loadHeaderChoicesIfNeeded(){var headerDef;$scope.headerParam&&(headerDef=$scope.fieldConfig.subParams.find(p=>p.name===$scope.headerParam))&&headerDef.getChoicesFromPython&&ParamsHelperService.do({parameterName:$scope.headerParam,rootModel:$scope.rootModel||$scope.config}).then(function(res){(res&&res.choices?res.choices:[]).forEach(function(c){c&&c.value&&(_headerChoicesByValue[c.value]=c.label||c.value)})}).catch(function(){})}$scope.getHeaderLabel=function(item){return!$scope.headerParam||null==(item=item&&item[$scope.headerParam])?null:_headerChoicesByValue[item]||""+item},$scope.rowAnchorId=function(index){return($scope.anchorPrefix||"row")+"-"+index},$scope.isRowCollapsed=function(index){return!!$scope._collapsed[index]},$scope.toggleRow=function(index){$scope.collapsible&&($scope._collapsed[index]=!$scope._collapsed[index])};let FIELD_TYPE_MAPPING={SELECT:"bs-select",TEXTAREA:"bs-textarea",LLM:"bs-llm-select",ARRAY:"bs-array",SEPARATOR:null};$scope.getDirectiveName=function(fieldType){return FIELD_TYPE_MAPPING[fieldType]},$scope.initializeTriggerParameters=function(){$scope.fieldConfig.triggerParameters&&0<$scope.fieldConfig.triggerParameters.length?($scope.triggerParametersArray=[],$scope.fieldConfig.triggerParameters.forEach(function(param){let sourceModel=$scope.rootModel||$scope.config;$scope.triggerParametersArray.push({get value(){return sourceModel[param]}})})):$scope.triggerParametersArray=null},$scope.isFieldVisible=function(param,item){param=param.visibilityCondition;if(!param)return!0;try{return $scope.$eval(param,{model:item})}catch(e){return console.warn("Visibility error:",e),!1}},$scope.initializeList=function(){$scope.config[$scope.configProperty]||($scope.config[$scope.configProperty]=[])},$scope.createNewObject=function(){let newObject={};return $scope.fieldConfig.subParams.forEach(function(param){if("SEPARATOR"!==param.type)switch(param.type){case"STRING":newObject[param.name]="";break;case"SELECT":case"LLM":newObject[param.name]=null;break;case"TEXTAREA":newObject[param.name]="";break;case"BOOLEAN":newObject[param.name]=!1;break;case"ARRAY":newObject[param.name]=[];break;default:newObject[param.name]=null}}),$scope.collapsible&&$scope._collapsed.push($scope.collapseByDefault),newObject},$scope.addModel=function(){$scope.config[$scope.configProperty].push($scope.createNewObject())},$scope.removeModel=function(index){var removed=$scope.config[$scope.configProperty][index];if($scope.config[$scope.configProperty].splice(index,1),$scope.collapsible&&$scope._collapsed.splice(index,1),$scope.onRemove)try{$scope.onRemove({item:removed,index:index})}catch(e){}},$scope.hasValidationErrors=function(){var list=$scope.config[$scope.configProperty];return!(!list||0===list.length)&&list.some(function(item){return $scope.fieldConfig.subParams.some(function(param){var value;return!!param.mandatory&&(value=item[param.name],"ARRAY"===param.type?!value||0===value.length:!value||"string"==typeof value&&""===value.trim())})})},$scope.getValidationMessage=function(){return $scope.hasValidationErrors()?"Please fill in all required fields: "+$scope.fieldConfig.subParams.filter(p=>p.mandatory).map(p=>p.label).join(", "):""},$scope.isVisible=function(){if(!$scope.fieldConfig.visibilityCondition)return!0;try{return $scope.$eval($scope.fieldConfig.visibilityCondition,{model:$scope.rootModel||$scope.config})}catch(e){return console.warn("Visibility condition error:",e),!0}},$scope.getFieldAttributes=function(param){var triggerArray,attributes={config:"item","form-name":"formName","config-property":param.name,"label-text":param.label,"field-required":param.mandatory||!1};switch(param.description&&(attributes.description=param.description),$scope.fieldConfig.triggerParameters&&0<$scope.fieldConfig.triggerParameters.length&&(triggerArray=$scope.fieldConfig.triggerParameters.map(function(t){return"config."+t}),attributes["trigger-parameter"]=triggerArray),param.type){case"SELECT":param.getChoicesFromPython&&(attributes["get-choices-from-python"]="true"),attributes["root-model"]="rootModel || config";break;case"TEXTAREA":attributes["initial-width"]="100%",attributes["initial-height"]="120px",param.placeholder&&(attributes.placeholder=param.placeholder)}return attributes},$scope.getTriggerParameters=function(){return $scope.fieldConfig.triggerParameters&&0<$scope.fieldConfig.triggerParameters.length?$scope.fieldConfig.triggerParameters.map(function(param){return"config."+param}):null},$scope.fieldConfig.triggerParameters&&$scope.fieldConfig.triggerParameters.forEach(function(param){$scope.$watch(function(){return($scope.rootModel||$scope.config)[param]},function(newValue,oldValue){newValue!==oldValue&&($scope.$broadcast("triggerParameterChanged",param,newValue),loadHeaderChoicesIfNeeded())},!0)}),$scope.initializeList(),$scope.initializeTriggerParameters(),loadHeaderChoicesIfNeeded(),$scope.collapsible&&$scope.config[$scope.configProperty]&&($scope._collapsed=$scope.config[$scope.configProperty].map(function(){return $scope.collapseByDefault}))}]}}]),llmApp.directive("bsSelect",["PythonService","ParamsHelperService","DescParamsService","customFileUploaderService","PLUGIN_PATHS","$stateParams",function(PythonService,ParamsHelperService,DescParamsService,customFileUploaderService,PLUGIN_PATHS,$stateParams){return{restrict:"E",templateUrl:PLUGIN_PATHS.WEBAPP+"bs-select-template.html",scope:{config:"=",formName:"=",labelText:"@",fieldRequired:"=",configProperty:"@",description:"@",defaultValue:"@",folderChoices:"=?",customMargin:"@?",isLanguageMappingsArray:"=?",getChoicesFromPython:"@",writePermission:"@",triggerParameter:"=",validationMessage:"@",rootModel:"=",isFolder:"@"},link:function(scope){scope.config=scope.config||{}},controller:["$scope","$timeout","$element",function($scope,$timeout,$element){$scope.isFolderDropdownOpen=!1,$scope.isDropdownHovered=!1,$scope.isFolderFocused=!1,$scope.isCreatingFolder=!1,$scope.folders=[],$scope.folderFilter="",$scope.selectedFolder=null,$scope.folderCreationError="",$scope.filterActive=!1;let folderBlurTimeout=null;var projectKey=$stateParams.projectKey;function setAndProcessFolders(rawChoices){let processedChoices;var languageMappings;if(processedChoices=$scope.isLanguageMappingsArray?(languageMappings=$scope.isLanguageMappingsArray,Array.isArray(languageMappings)?languageMappings.filter(mapping=>mapping&&mapping.to).map(mapping=>({label:mapping.to,value:mapping.to})):[]):(choices=>{if(!Array.isArray(choices))return[];if("custom_theme_name"===$scope.configProperty&&$scope.config){let defaultFolder={value:"",label:"Default customization"};var defaultItem=(choices=choices.some(f=>f.value===defaultFolder.value&&f.label===defaultFolder.label)?choices:[...choices,defaultFolder]).find(choice=>"Default customization"===choice.label),otherItems=choices.filter(choice=>"Default customization"!==choice.label);return otherItems.sort((a,b)=>a.label.localeCompare(b.label)),defaultItem?[defaultItem,...otherItems]:otherItems}return choices.filter(choice=>""!==choice.value&&"none"!==choice.label.toLowerCase())})(rawChoices),$scope.folderHoverStates=processedChoices.reduce((acc,folder)=>(acc[folder.value]=!1,acc),{}),$scope.folders=processedChoices,"custom_theme_name"!==$scope.configProperty||!$scope.config||"Default customization"!==$scope.config.custom_theme_name&&$scope.config.custom_theme_name){let folderId=$scope.config[$scope.configProperty];folderId?(languageMappings=$scope.folders.find(f=>f.value===folderId))?$scope.selectFolder(languageMappings):$scope.defaultValue?$scope.selectFolder({label:$scope.defaultValue,value:$scope.defaultValue}):$scope.selectFolder(null):$scope.selectFolder(null)}else{let defaultFolder={value:"",label:"Default customization"};$scope.folders.some(f=>f.value===defaultFolder.value&&f.label===defaultFolder.label)||($scope.folders=[...$scope.folders,defaultFolder]),void($scope.selectedFolder&&$scope.selectedFolder.value===defaultFolder.value||$scope.selectFolder(defaultFolder))}}function removeDocumentClickHandler(){angular.element(document).off("click",handleDocumentClick)}function initialize(){var choices;"false"===$scope.getChoicesFromPython?(choices=DescParamsService.getSelectChoices($scope.configProperty)||[],setAndProcessFolders(choices)):$scope.isLanguageMappingsArray?setAndProcessFolders($scope.isLanguageMappingsArray):$scope.writePermission?customFileUploaderService.listSubFolders().then(response=>setAndProcessFolders(response)).catch(error=>{setAndProcessFolders([])}):(choices={parameterName:$scope.configProperty,projectKey:projectKey,rootModel:$scope.rootModel||$scope.config},"true"!==$scope.isFolder&&!0!==$scope.isFolder||(pythonCallParams.projectKey=$stateParams.projectKey),ParamsHelperService.do(choices).then(data=>setAndProcessFolders(data.choices||[])).catch(error=>{setAndProcessFolders([])}))}let handleDocumentClick=function(event){$scope.isFolderDropdownOpen&&!$element[0].contains(event.target)&&$scope.$apply(()=>closeFolderDropdownAndRevertText())},closeFolderDropdownAndRevertText=function(){$scope.isFolderDropdownOpen&&($scope.isFolderDropdownOpen=!1,$scope.isFolderFocused=!1,removeDocumentClickHandler(),$scope.folderFilter=$scope.selectedFolder?$scope.selectedFolder.label:"",$scope.filterActive=!1)};$scope.openFolderDropdown=function(clearFilter){folderBlurTimeout&&$timeout.cancel(folderBlurTimeout),$scope.isFolderDropdownOpen?closeFolderDropdownAndRevertText():(clearFilter&&($scope.folderFilter=""),$scope.isFolderDropdownOpen||($scope.isFolderDropdownOpen=!0,$scope.filterActive=!1,$timeout(()=>angular.element(document).on("click",handleDocumentClick),0)))},$scope.selectFolder=function(folder){folderBlurTimeout&&$timeout.cancel(folderBlurTimeout),$scope.selectedFolder=folder,$scope.config[$scope.configProperty]=folder?folder.value:null,$scope.folderFilter=folder?folder.label:"",$scope.isFolderDropdownOpen=!1,$scope.isFolderFocused=!1,removeDocumentClickHandler()},$scope.clearFolderSelection=function(){$scope.selectFolder(null),$scope.openFolderDropdown(null,!1),$element[0].querySelector("input").focus()},$scope.createNewFolder=function(){if(!$scope.isCreatingFolder){$scope.isCreatingFolder=!0,$scope.folderCreationError="";let newFolderName=customFileUploaderService.generateAppFilename();$scope.folders.some(f=>f.label.toLowerCase()===newFolderName.toLowerCase())?($timeout(()=>{$scope.folderCreationError="A folder with this name already exists.",$scope.isCreatingFolder=!1},0),$timeout(()=>{$scope.folderCreationError=null},5e3)):customFileUploaderService.createFolder("LOCAL_STATIC",newFolderName,"").then(function(newFolder){$scope.$applyAsync(()=>{$scope.folders.push(newFolder),$scope.selectFolder(newFolder)})}).catch(function(error){$scope.folderCreationError="Failed to create folder: "+(error.data?.detailedMessage||"Unknown error")}).finally(function(){$scope.isCreatingFolder=!1})}},$scope.handleFolderInputChange=function(){$scope.selectedFolder&&$scope.folderFilter!==$scope.selectedFolder.label&&($scope.selectedFolder=null,$scope.config[$scope.configProperty]=null),$scope.filterActive=!0,!$scope.isFolderDropdownOpen&&$scope.folderFilter&&$scope.openFolderDropdown(null,!1)},$scope.handleFolderInputBlur=function(){folderBlurTimeout=$timeout(()=>{closeFolderDropdownAndRevertText()},200)},$scope.handleInputFocus=function(){$scope.isFolderDropdownOpen||$scope.openFolderDropdown(!1)},$scope.folderFilterFn=function(folder){return!$scope.filterActive||!!folder?.label&&(!$scope.folderFilter||folder.label.toLowerCase().includes($scope.folderFilter.toLowerCase()))};$scope.isLanguageMappingsArray&&$scope.$watch("isLanguageMappingsArray",function(newVal,oldVal){angular.equals(newVal,oldVal)||setAndProcessFolders(newVal)},!0),$scope.$on("$destroy",function(){removeDocumentClickHandler(),folderBlurTimeout&&$timeout.cancel(folderBlurTimeout)}),initialize(),$scope.$on("folderRefreshRequested",function(){initialize()}),$scope.triggerParameter&&Array.isArray($scope.triggerParameter)?$scope.triggerParameter.forEach(function(param){$scope.$watch(param,function(newValue,oldValue){newValue!==oldValue&&initialize()},!0)}):$scope.triggerParameter&&$scope.$watch("triggerParameter",function(newValue,oldValue){newValue!==oldValue&&initialize()},!0),$scope.$watch("config[configProperty]",function(newVal,oldVal){null===newVal&&null!==oldVal&&($scope.selectedFolder=null,$scope.folderFilter="")})}]}}]),llmApp.directive("bsTextarea",["PLUGIN_PATHS",function(PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.WEBAPP+"bs-textarea.html",scope:{config:"=",labelText:"@",configProperty:"@",initialWidth:"@?",initialHeight:"@?",placeholder:"@?",description:"@",fieldRequired:"=",formName:"=",customMargin:"@?"},link:function(scope,element,attrs){scope.initialWidth=scope.initialWidth||"100%",scope.initialHeight=scope.initialHeight||"80px";element=element.find("textarea")[0];element&&(element.style.width=scope.initialWidth,element.style.height=scope.initialHeight)},controller:["$scope","$timeout",function($scope,$timeout){$scope.config[$scope.configProperty]||($scope.config[$scope.configProperty]=""),$scope.$watch("config."+$scope.configProperty,function(newVal){void 0===newVal&&($scope.config[$scope.configProperty]="")}),$scope.isFieldEmpty=function(){return null==$scope.config[$scope.configProperty]||""===$scope.config[$scope.configProperty].trim()}}]}}]),llmApp.directive("bsToggleSwitch",["$timeout","DescParamsService","PLUGIN_PATHS",function($timeout,DescParamsService,PLUGIN_PATHS){return{restrict:"E",templateUrl:PLUGIN_PATHS.WEBAPP+"bs-toggle-switch.html",scope:{configProperty:"@?",elementId:"@",config:"=",labelText:"@",descriptionText:"@?",clearArrayName:"@?",inputId:"@",customModel:"=?",disabled:"=?",disabledText:"@"},controller:["$scope",function($scope){let useConfigProperty=$scope.configProperty&&""!==$scope.configProperty.trim();$scope.internalModel=useConfigProperty?$scope.config[$scope.configProperty]||!1:void 0!==$scope.customModel&&$scope.customModel,$scope.$watch("internalModel",function(newValue,oldValue){newValue!==oldValue&&(useConfigProperty?$scope.config[$scope.configProperty]=newValue:($scope.customModel=newValue,!0===oldValue&&!1===newValue&&$scope.clearArrayName&&$scope.config&&$scope.config[$scope.clearArrayName]&&($scope.config[$scope.clearArrayName]=[])))}),useConfigProperty?$scope.$watch(function(){return $scope.config[$scope.configProperty]},function(newValue){$scope.internalModel=newValue}):$scope.$watch("customModel",function(newValue){$scope.internalModel=newValue})}]}}]),llmApp.directive("contenteditable",function(){return{require:"ngModel",link:function(scope,element,attrs,ngModel){ngModel.$render=function(){element.html(ngModel.$viewValue||"")},element.on("paste",function(e){e.preventDefault();var selection,range,e=(e.originalEvent||e).clipboardData;e&&(e=e.getData("text/plain"),(selection=window.getSelection()).rangeCount)&&((range=selection.getRangeAt(0)).deleteContents(),e=document.createTextNode(e),range.insertNode(e),range.setStartAfter(e),range.collapse(!0),selection.removeAllRanges(),selection.addRange(range))}),element.on("blur keyup change",function(){scope.$apply(function(){ngModel.$setViewValue(element.html())})})}}}),llmApp.directive("dndSortable",[function(){return{restrict:"A",scope:{dndList:"=dndSortable"},link:function(scope,element,attrs){var container,draggedItem,observer,itemSelector=attrs.dndSortableItemSelector;function getElementIndex(item){return Array.from(container.querySelectorAll(itemSelector)).indexOf(item)}itemSelector&&(container=element[0],draggedItem=null,container.addEventListener("dragstart",function(e){var sourceIndex,targetItem=e.target.closest(itemSelector);targetItem&&(sourceIndex=getElementIndex(draggedItem=targetItem),e.dataTransfer.setData("text/plain",sourceIndex),e.dataTransfer.effectAllowed="move",setTimeout(function(){draggedItem.classList.add("dragging"),draggedItem.style.opacity="0.5",scope.$apply(function(){scope.$parent.isDragging||(scope.$parent.isDragging={}),scope.$parent.isDragging[sourceIndex]=!0})},0))}),container.addEventListener("dragover",function(e){e.preventDefault(),e.dataTransfer.dropEffect="move";var rect,targetItem=e.target.closest(itemSelector);targetItem&&targetItem!==draggedItem&&(container.querySelectorAll(itemSelector).forEach(function(item){item.classList.remove("drop-before","drop-after")}),rect=targetItem.getBoundingClientRect(),e=e.clientY<rect.top+rect.height/2,targetItem.classList.add(e?"drop-before":"drop-after"))}),container.addEventListener("drop",function(e){var sourceIndex,targetIndex,targetElement,dropIndex;e.preventDefault(),draggedItem&&(sourceIndex=parseInt(e.dataTransfer.getData("text/plain")),targetElement=e.target.closest(itemSelector))&&(targetIndex=getElementIndex(targetElement),targetElement=targetElement.getBoundingClientRect(),dropIndex=e.clientY<targetElement.top+targetElement.height/2?targetIndex:targetIndex+1,scope.$apply(function(){!function moveItem(fromIndex,toIndex){var list;fromIndex!==toIndex&&(list=scope.dndList,fromIndex<toIndex&&toIndex--,fromIndex=list.splice(fromIndex,1)[0],list.splice(toIndex,0,fromIndex))}(sourceIndex,dropIndex)}))}),container.addEventListener("dragend",function(e){!function cleanupStyling(){container.querySelectorAll(itemSelector).forEach(function(item){item.classList.remove("drop-before","drop-after","dragging"),item.style.opacity="1"})}(),setTimeout(function(){scope.$apply(function(){scope.$parent.isDragging&&(scope.$parent.isDragging={})})},50),draggedItem=null}),(observer=new MutationObserver(function(mutations){mutations.forEach(function(mutation){mutation.addedNodes.forEach(function(node){1===node.nodeType&&node.matches(itemSelector)&&node.setAttribute("draggable","true")})})})).observe(container,{childList:!0}),function initializeDraggableItems(){container.querySelectorAll(itemSelector).forEach(function(item){item.setAttribute("draggable","true")})}(),scope.$on("$destroy",function(){observer.disconnect()}))}}}]);