llmApp.directive('endUserConfiguration', ['customFileUploaderService', '$timeout','PLUGIN_PATHS',
    function (customFileUploaderService, $timeout,PLUGIN_PATHS) {
        return {
            restrict: 'E',
            templateUrl: PLUGIN_PATHS.WEBAPP +'end-user-configuration.html',
            scope: {
                config: '=', configForm: '='
            },
            controller: ['$scope', '$timeout', function ($scope, $timeout) {
                $scope.config = $scope.config || {};
                $scope.folderChoices = [];  // Initialize as empty array
                $scope.use_examples = true;
                $scope.isLogoExpanded = false;
                $scope.isExampleExpanded = false;
                $scope.isChatIconExpanded = false;
                $scope.isFolderThemeExpanded = false;
                $scope.toggleExpand = function(propertyName) {
                    $scope[propertyName] = !$scope[propertyName];
                };

                if(!$scope.config['custom_theme_name'])
                {
                    $scope.config['custom_theme_name'] = "Default customization";
                    $scope.config['use_custom_rebranding'] = "false";
                }

                // Single handler for all image selections
                $scope.handleImageSelected = function(selectedImage, configProperty) {

                    // The config is already updated by the bs-image-select directive
                    // Broadcast event to refresh file uploaders
                    $scope.$broadcast('imageSelectedFromSelector', {
                        configProperty: configProperty,
                        selectedImage: selectedImage
                    });
                };


                // Relay upload/delete events to image selectors
                $scope.$on('imageUploaded', function(event, data) {

                    $scope.$broadcast('refreshImageSelector', data);
                });

                $scope.$on('imageDeleted', function(event, data) {

                    $scope.$broadcast('refreshImageSelector', data);
                });




                if(!$scope.config['use_custom_rebranding'])
                {
                    $scope.config['use_custom_rebranding'] = "false";
                }
                // Listen for 'folderCreated' from children and rebroadcast
                // Relay events from children to siblings
                $scope.$on('folderCreated', function() {
                    $scope.$broadcast('folderRefreshRequested');
                });

                $scope.$watch('config.custom_theme_name', function(newVal) {
                    if (newVal && newVal !== 'Default customization') {
                        $scope.config.use_custom_rebranding = true;
                    }
                    if (newVal === "" || newVal === null) {
                        $scope.config.use_custom_rebranding = false;
                    }
                });




            }]
        };
    }]);
