llmApp.factory('PythonService', ['$q', function ($q) {
    let _registeredCallPythonDo = null;

    return {
        registerCallPythonDoFunction: function (fn) {
            if (typeof fn === 'function') {
                _registeredCallPythonDo = fn;

            } else {

                _registeredCallPythonDo = null; // Ensure it's null if registration fails
            }
        },

        unregisterCallPythonDoFunction: function () {
            _registeredCallPythonDo = null;

        },

        callPythonDo: function (params) {
            if (typeof _registeredCallPythonDo === 'function') {
                try {
                    // Directly call the registered function.
                    // If it needs a specific 'this', it should have been bound
                    // before being passed to registerCallPythonDoFunction.
                    return _registeredCallPythonDo(params);
                } catch (e) {

                    return $q.reject("Error in registered callPythonDo: " + e.message);
                }
            } else {

                return $q.reject("callPythonDo function not registered in PythonService");
            }
        }
    };
}]);
