
from typing import Any, Dict, List, Optional, TypedDict


class Artifact(TypedDict):
  name: str
  description: str
  parts: List[Dict[str, Any]]
  preview: Optional[bool]  # True if this is a preview (not full data)


class ArtifactsMetadata(TypedDict):
    size_mb: float
    artifacts_id: str
    agentName: str
    query: str
    has_records: bool
    artifacts: Optional[List[Artifact]]  # TODO change this to non optional when data model updated
    preview: bool = False # True if artifacts is a preview (not full data)
