# Vue 3 + TypeScript + Vite

This template should help get you started developing with Vue 3 and TypeScript in Vite. The template uses Vue 3 `<script setup>` SFCs, check out the [script setup docs](https://v3.vuejs.org/api/sfc-script-setup.html#sfc-script-setup) to learn more.

Learn more about the recommended Project Setup and IDE Support in the [Vue Docs TypeScript Guide](https://vuejs.org/guide/typescript/overview.html#project-setup).

 ## Node & Yarn versions

This project uses Node 20 and Yarn 1.x.

* CI installs Node 20 automatically (see `.github/workflows`).
* Local development: run `nvm use` (or `fnm use`) in `/resource/frontend`, the command reads `.nvmrc` and switches to Node 20 for you.
* If you don’t have a version manager, install Node 20 manually before running `yarn install`.

---

## Formatting & CI checks

Prettier enforces a consistent code style on the **Vue / TS / JS** sources (all CSS files are excluded via `.prettierignore`). Every pull-request triggers the `static-checks` workflow (job **frontend-format**) which runs:

```bash
yarn run format:check   # verify formatting only – fails on diff
```

If the job turns red 🔴, fix the files locally with 👇:

```bash
yarn run format         # writes fixes in place
```

Commit the changes and push – the workflow will turn green.

---

## Dev notes 📝

In `ToolCard.vue` a const `AGENT_TOOL_TYPES_UI_DATA` represents a mapping of tool types to icons from https://github.com/dataiku/dip/blob/873e6936362ffeb93b5bf74fee125f49f2b48811/src/main/platypus/static/dataiku/js/services.js#L6006-L6106

---
