export const AGENTS_LIBRARY_TEST_IDS = {
  AGENT_CARD: {
    CONTAINER: 'agent-card',
    NAME: 'agent-card-name',
    DESCRIPTION: 'agent-card-description',
    OWNER: 'agent-card-owner',
    DATE: 'agent-card-date',
    SHARE_COUNT: 'agent-card-share-count',
    ICON: 'agent-card-icon',
    STATUS_BADGE: 'agent-card-status-badge',
    DATAIKU_ICON: 'agent-card-dataiku-icon',
  },

  // AgentsLibrary component
  AGENTS_LIBRARY: {
    CONTAINER: 'agents-library',
    LOGO: 'agents-library-logo',
    TITLE: 'agents-library-title',
    SUBTITLE: 'agents-library-subtitle',

    // Tabs
    TABS_CONTAINER: 'agents-library-tabs',
    TAB_ENTERPRISE: 'agents-library-tab-enterprise',
    TAB_MY_AGENTS: 'agents-library-tab-my-agents',
    TAB_SHARED: 'agents-library-tab-shared',
    TAB_FAVORITES: 'agents-library-tab-favorites',

    // Tab content
    ENTERPRISE_SECTION: 'agents-library-enterprise-section',
    MY_AGENTS_SECTION: 'agents-library-my-agents-section',
    SHARED_SECTION: 'agents-library-shared-section',
    FAVORITES_SECTION: 'agents-library-favorites-section',

    // Create agent
    CREATE_AGENT_CARD: 'agents-library-create-agent-card',
    CREATE_AGENT_ICON: 'agents-library-create-agent-icon',
    CREATE_AGENT_TEXT: 'agents-library-create-agent-text',

    // Profile upgrade alert
    PROFILE_UPGRADE_ALERT: 'agents-library-profile-upgrade-alert',
    PROFILE_UPGRADE_TITLE: 'agents-library-profile-upgrade-title',
    PROFILE_UPGRADE_DESCRIPTION: 'agents-library-profile-upgrade-description',

    // Empty states
    EMPTY_ENTERPRISE: 'agents-library-empty-enterprise',
    EMPTY_SHARED: 'agents-library-empty-shared',
    EMPTY_ALL: 'agents-library-empty-all',
    EMPTY_FAVORITES: 'agents-library-empty-favorites',

    // Agent counts
    ENTERPRISE_COUNT: 'agents-library-enterprise-count',
    MY_AGENTS_COUNT: 'agents-library-my-agents-count',
    SHARED_COUNT: 'agents-library-shared-count',
    FAVORITES_COUNT: 'agents-library-favorites-count',
  },

  // Mobile specific
  MOBILE: {
    ENTERPRISE_HEADER: 'mobile-enterprise-header',
    MY_AGENTS_HEADER: 'mobile-my-agents-header',
    SHARED_HEADER: 'mobile-shared-header',
    FAVORITES_HEADER: 'mobile-favorites-header',
  },
} as const

// Helper function to generate test IDs with dynamic values
export const generateTestId = (baseId: string, suffix?: string | number): string => {
  return suffix ? `${baseId}-${suffix}` : baseId
}

// Helper function to generate agent card test IDs
export const generateAgentCardTestIds = (agentId: string) => ({
  container: generateTestId(AGENTS_LIBRARY_TEST_IDS.AGENT_CARD.CONTAINER, agentId),
  name: generateTestId(AGENTS_LIBRARY_TEST_IDS.AGENT_CARD.NAME, agentId),
  description: generateTestId(AGENTS_LIBRARY_TEST_IDS.AGENT_CARD.DESCRIPTION, agentId),
  owner: generateTestId(AGENTS_LIBRARY_TEST_IDS.AGENT_CARD.OWNER, agentId),
  date: generateTestId(AGENTS_LIBRARY_TEST_IDS.AGENT_CARD.DATE, agentId),
  shareCount: generateTestId(AGENTS_LIBRARY_TEST_IDS.AGENT_CARD.SHARE_COUNT, agentId),
  icon: generateTestId(AGENTS_LIBRARY_TEST_IDS.AGENT_CARD.ICON, agentId),
  statusBadge: generateTestId(AGENTS_LIBRARY_TEST_IDS.AGENT_CARD.STATUS_BADGE, agentId),
  dataikuIcon: generateTestId(AGENTS_LIBRARY_TEST_IDS.AGENT_CARD.DATAIKU_ICON, agentId),
})
