import { createApp } from 'vue'
import { createPinia } from 'pinia'
import './style.css'
import './assets/dku-icons.css'
import App from './App.vue'
import router from '@/router'
import { usePrefStore } from '@/store/prefStore'
import { useUserStore } from '@/store/userStore'
import { useSocket } from '@/composables/useSocket'

const app = createApp(App)
const pinia = createPinia()
app.use(pinia)
app.use(router)
useSocket()

// Initialize stores and fetch user profile on app load
const pref = usePrefStore()
const userStore = useUserStore()

// Load preferences and user profile in parallel, then mount the app
Promise.all([pref.load(), userStore.fetchUserProfile()]).finally(() => app.mount('#app'))
