import { defineStore } from 'pinia'
import { ref } from 'vue'
import type { PromptTemplate } from '@/types/prompt'
import { PROMPT_TEMPLATES } from '@/constants/promptTemplates'

export const usePromptStore = defineStore('prompt', () => {
  const promptTemplates = ref<PromptTemplate[]>(PROMPT_TEMPLATES)

  function getTemplatesByCategory(category: string): PromptTemplate[] {
    return promptTemplates.value?.filter((template) => template.category === category) || []
  }

  function searchTemplates(query: string): PromptTemplate[] {
    if (!promptTemplates.value) return []

    if (!query.trim()) {
      return promptTemplates.value
    }

    const searchTerm = query.toLowerCase()
    return promptTemplates.value.filter(
      (template) =>
        template.name.toLowerCase().includes(searchTerm) ||
        template.description.toLowerCase().includes(searchTerm) ||
        template.prompt.toLowerCase().includes(searchTerm)
    )
  }

  function getTemplateById(id: string): PromptTemplate | undefined {
    return promptTemplates.value?.find((template) => template.id === id)
  }

  return {
    promptTemplates,
    getTemplatesByCategory,
    searchTemplates,
    getTemplateById,
  }
})
