import { defineStore } from 'pinia'
import { computed } from 'vue'
import { ref } from 'vue'
import { API } from '@/Api'

interface ToolBrief {
  id: string
  name: string
  description: string
  type: string
  configured?: boolean
  error?: string
}

export const useToolsStore = defineStore('tools', () => {
  const tools = ref<ToolBrief[]>([])
  const loading = ref(false)
  const loaded = ref(false)

  async function load() {
    if (loading.value || loaded.value) return
    loading.value = true
    try {
      tools.value = (await API.getTools()).data.tools
      loaded.value = true
    } finally {
      loading.value = false
    }
  }

  async function refresh() {
    loaded.value = false
    await load()
  }

  // Helper computed to get configured and unconfigured tools
  const configuredTools = computed(() => tools.value.filter((tool) => tool.configured !== false))
  const unconfiguredTools = computed(() => tools.value.filter((tool) => tool.configured === false))

  return {
    tools,
    loading,
    loaded,
    configuredTools,
    unconfiguredTools,
    load,
    refresh,
  }
})
