import type { ChartPlan } from '@/lib/plan'

export type Role = 'user' | 'assistant'

/* Event-log panel */
export type EventLogEntry = {
  eventKind: string
  eventData: Record<string, any>
}
export interface ActionsChart {
  chart_plan: { chart_type: string; chart_data?: ChartPlan; justification?: string }
  source_name: string
  artifacts_id: string
  artifact_index: number
  records_index: number
  records?: Array<any>
}
export interface Actions {
  chart_plans?: ActionsChart[]
  stories?: {
    enable_stories?: boolean
    stories_id?: string
    stories_workspace?: string
    tables?: string[]
    agent_id?: string
    agent_short_example_queries?: string[]
    agent_example_queries?: string[]
  }
}
export interface Artifact {
  name: string
  description: string
  parts: Array<any>
}
export interface Message {
  id?: string
  role: Role
  content: string
  hasEventLog?: boolean
  actions?: Actions
  eventLog?: Array<EventLogEntry>
  artifactsMetadata?: Record<
    string,
    {
      artifacts: Artifact[]
      artifacts_id: string
      agentName: string
      agentId: string
      query: string
      size_mb: number
      has_records: boolean
      preview: boolean
    }
  >
}

export interface InitialDraft {
  id: string
  messages: Message[]
  agentIds: string[]
}
