#!/bin/bash
set -e

PATCH_FILE="dev.patch"

if [ ! -f "$PATCH_FILE" ]; then
  echo "dev.patch not found."
  exit 1
fi

# --reject so you see if it doesn't apply
git apply "$PATCH_FILE" || {
  echo "❗ Could not apply cleanly. Try: git apply dev.patch"
  exit 1
}

echo "✅ dev patch applied and staged."