llmApp
    .directive('autoResize', ['$timeout', function($timeout) {
        return {
            restrict: 'A',
            require: 'ngModel', // Require ngModel to catch programmatic changes
            link: function(scope, element, attrs, ngModel) {
                // Create a hidden span for measuring text width
                var span = document.createElement('span');
                span.style.position = 'absolute';
                span.style.visibility = 'hidden';
                span.style.whiteSpace = 'pre';
                document.body.appendChild(span);

                function updateWidth() {
                    // Get the input's current value (or use its placeholder if empty)
                    var text = element.val() || element.attr('placeholder') || '';

                    // Get the computed styles from the input element
                    var computedStyles = window.getComputedStyle(element[0]);

                    // Copy key styling to the hidden span
                    span.style.display = 'inline-block';
                    span.style.whiteSpace = 'pre';  // preserve whitespace
                    // Also copy the direction so it renders right-to-left if needed
                    span.style.direction = computedStyles.direction;

                    // Copy the font and text styling properties
                    span.style.fontFamily    = computedStyles.fontFamily;
                    span.style.fontSize      = computedStyles.fontSize;        // For text-base (e.g. 16px)
                    span.style.fontWeight    = computedStyles.fontWeight;
                    span.style.fontStyle     = computedStyles.fontStyle;
                    span.style.letterSpacing = computedStyles.letterSpacing;
                    span.style.textTransform = computedStyles.textTransform;
                    span.style.lineHeight    = computedStyles.lineHeight;
                    // In some cases, extra settings (like font-variant) might also help
                    if (computedStyles.fontVariant) {
                        span.style.fontVariant = computedStyles.fontVariant;
                    }

                    // If your input has padding that affects its total width, add it
                    var paddingLeft  = parseFloat(computedStyles.paddingLeft) || 0;
                    var paddingRight = parseFloat(computedStyles.paddingRight) || 0;

                    // Set the text content of the span (this might be Arabic text)
                    span.textContent = text;

                    // Add some extra space to account for the caret or minor discrepancies
                    var extraSpace = 10;

                    // Calculate the new width based on the span's measured width, plus padding and extra space
                    var newWidth = span.offsetWidth + paddingLeft + paddingRight + extraSpace;


                    // Set the calculated width on the input element
                    element[0].style.width = newWidth + 'px';
                }



                // Listen for input events in case the user types directly
                element.on('input', updateWidth);

                // Override the Angular ngModel.$render function to catch programmatic changes,
                // such as when the input is pre-populated from an API.
                ngModel.$render = function() {
                    element.val(ngModel.$viewValue);
                    // Use $timeout to ensure DOM updates, then update the width.
                    $timeout(updateWidth, 0);
                };

                // Initial update in case the value is already populated
                $timeout(updateWidth, 0);

                // Clean up the hidden span when the directive is destroyed
                scope.$on('$destroy', function() {
                    span.remove();
                });
            }
        };
    }]);