llmApp.service('SharedPromiseService', function ($q, PythonService) {
    var dataPromises = {}; // Our cache

    // Helper function to create a cache key from params object
    var getCacheKey = function(params) {
        // Create a consistent key from all parameters
        // Sort keys to ensure consistent ordering
        var keys = Object.keys(params).sort();
        var keyParts = [];
        keys.forEach(function(key) {
            keyParts.push(key + ':' + JSON.stringify(params[key]));
        });
        return keyParts.join('|');
    };

    // Helper method to fetch data and store it in cache
    var fetchData = function (params) {
        var cacheKey = getCacheKey(params);
        
        var fetchPromise = PythonService.callPythonDo(params).then(function (data) {
            // Store the fresh data in the cache immediately upon successful fetch
            dataPromises[cacheKey] = $q.when(data); // Wrap data in a resolved promise
            return data; // Resolve the promise with the fetched data
        }).catch(function (error) {
            // If fetch fails, we might want to remove it from cache or resolve with an error state
            delete dataPromises[cacheKey]; // Remove from cache on error
            return $q.reject(error); // Reject the promise
        });
        return fetchPromise;
    };

    this.getData = function (params) {
        var cacheKey = getCacheKey(params);
        
        if (!dataPromises[cacheKey]) {
            dataPromises[cacheKey] = fetchData(params); // Initiate fetch and store the promise
        }
        return dataPromises[cacheKey]; // Return the promise (either cached or newly created)
    };

    // Method to invalidate cache entry and immediately start a refresh
    this.refreshData = function (params) {
        var cacheKey = getCacheKey(params);
        
        // Store the refresh promise immediately to prevent race conditions
        var refreshPromise = fetchData(params);
        dataPromises[cacheKey] = refreshPromise;  // Cache the new promise right away
        // Fetch the data and update the cache entry directly
        return dataPromises[cacheKey];
    };

    // Keep clearCache for explicit manual cache clearing if needed elsewhere
    this.clearCache = function (params) {
        var cacheKey = getCacheKey(params);
        delete dataPromises[cacheKey];
    };
    
    this.clearAllCache = function() {
        dataPromises = {};
    };
});
