from __future__ import annotations

import os

from dataiku.core import workload_local_folder

from backend.utils.local_dev_utils import load_local_config


def is_local_dev() -> bool:
    """Check if we're running in local development mode."""
    return os.getenv("LOCAL_DEV", "false").lower() in ['true', '"true"']


def get_workload_folder_path() -> str:
    """Get the path to the workload folder."""
    if is_local_dev():
        # Import here to avoid circular imports
        # TODO:  For local development, use a fixed path
        return load_local_config()["db_folder_path"]
    else:
        return workload_local_folder.get_workload_local_folder_path()