
def compare_versions(version1: str, version2: str) -> int:
    try:
        v1 = (version1 or "").strip()
        v2 = (version2 or "").strip()

        # Dev versions are always considered greater than any other version
        is_dev1 = v1.startswith("dev/")
        is_dev2 = v2.startswith("dev/")

        if is_dev1 and is_dev2:
            return 0
        if is_dev1:
            return 1
        if is_dev2:
            return -1

        # Strip pre-release identifiers (alpha, beta, rc, etc.)
        def strip_pre_release(v):
            return v.split("-")[0].split("+")[0]

        clean1 = strip_pre_release(v1)
        clean2 = strip_pre_release(v2)

        # Split and convert to numbers
        def to_int_list(s):
            return [int(x) if x.isdigit() else 0 for x in s.split(".")]

        parts1 = to_int_list(clean1)
        parts2 = to_int_list(clean2)

        max_length = max(len(parts1), len(parts2))
        for i in range(max_length):
            num1 = parts1[i] if i < len(parts1) else 0
            num2 = parts2[i] if i < len(parts2) else 0

            if num1 > num2:
                return 1
            if num1 < num2:
                return -1

        return 0
    except Exception as error:
        print("Error comparing versions:", error)
        return 0
