import functools

import dataiku


def add_history_to_completion(
    completion,
    messages,
):
    for msg in messages:
        completion.with_message(message=msg["content"], role=msg["role"])
    return completion

@functools.lru_cache(maxsize=128)
def get_llm_friendly_name(llm_id: str, project_key: str) -> str:
    project = dataiku.api_client().get_project(project_key)
    llms = project.list_llms()

    for llm in llms:
        if llm.get('id') == llm_id:
            return llm.get('friendlyName', llm_id)
    return ""