import type { AgentBrief } from '@/store/agentCatalogStore'

export type AgentType = 'enterprise' | 'shared' | 'user'

export function getAgentType(agent: AgentBrief): AgentType {
  if (agent.isEnterprise) {
    return 'enterprise'
  } else if (agent.isShared) {
    return 'shared'
  }
  return 'user'
}

export function getAgentTypeIcon(agent: AgentBrief, size: number = 16): string {
  switch (getAgentType(agent)) {
    case 'enterprise':
      return `dku-icon-briefcase-${size}`
    case 'shared':
      return `dku-icon-share-${size}`
    case 'user':
      return `dku-icon-user-${size}`
  }
}
