/**
 * ChartPlan is what LLM returns.
 * It is a *plan* (metadata + column mappings), not directly renderable.
 */
export type ChartPlan = {
  kind: 'line' | 'pie'
  title?: string

  // Optional flags the LLM may set
  donut?: boolean // pie
  smooth?: boolean // line
  stacked?: boolean // line

  /**
   * Mapping tells FE how to derive the actual series from a {columns, rows} table.
   * - For line charts, either provide:
   *   A) groupBy: one series per distinct keyCol over x, using valueCol
   *   B) seriesCols: one series per listed numeric column over x
   * - For pie charts:
   *   provide labelCol (category) and valueCol (numeric metric)
   */
  mapping:
    | {
        // LINE (grouped long format)
        x: string // x-axis column (category or date)
        groupBy: {
          keyCol: string // grouping column (series names)
          valueCol: string // numeric values
          xIsDate?: boolean
          xOrder?: string[]
          sortKeys?: string[]
        }
      }
    | {
        // LINE (wide format with multiple numeric columns)
        x: string // x-axis column (category or date)
        seriesCols: string[] // numeric columns, one series per column
        xIsDate?: boolean
        xOrder?: string[]
      }
    | {
        // PIE (single breakdown)
        labelCol: string // category column
        valueCol: string // numeric metric column
        aggregate?: 'sum' | 'avg' // how to combine duplicates; default "sum"
      }
    // BAR (grouped/stacked)
    | {
        bar: true
        x: string // category axis column
        groupCol: string // one series per distinct value here
        valueCol: string // numeric
        xOrder?: string[]
      }
    // HEATMAP (matrix)
    | {
        heatmap: true
        xCol: string // x categories
        yCol: string // y categories
        valueCol: string // numeric in the cell
        xOrder?: string[]
        yOrder?: string[]
      }
}
