import { createApp } from 'vue'
import { createPinia } from 'pinia'
import './style.css'
import './admin-styles.css'
import './assets/dku-icons.css'
import App from './App.vue'
import router from '@/router'
import { usePrefStore } from '@/store/prefStore'
import { useUserStore } from '@/store/userStore'
import { useToolsStore } from '@/store/toolsStore'
import { useSocket } from '@/composables/useSocket'
import md5 from 'blueimp-md5'
;(window as any).md5 = md5

const app = createApp(App)
const pinia = createPinia()
app.use(pinia)
app.use(router)
useSocket()

// Initialize stores and fetch user profile on app load
const pref = usePrefStore()
const userStore = useUserStore()
const toolsStore = useToolsStore()

// Load preferences, tools, and user profile in parallel, then mount the app
Promise.all([pref.load(), toolsStore.load(), userStore.fetchUserProfile()]).finally(() =>
  app.mount('#app')
)
