import type { AdminConfig } from './admin-config'

export interface Prompt {
  id: string
  name: string
  description: string
  prompt: string
  category: string
  tags: string[]
  isDefault: boolean
  createdAt: string
  updatedAt: string
  createdBy?: string
}

export const isPromptEnabled = (cfg: AdminConfig | undefined, id: string) =>
  cfg?.promptsAttributesById?.[id]?.enabled === false ? false : true
