"""
Parameter provider for Agent Hub export recipe.
"""

from backend.params_helpers import get_project_choices, get_table_choices, get_webapp_choices


def do(payload, config, plugin_config, inputs):
    """Main entry point for recipe parameter choices."""
    param_name = payload.get("parameterName")

    if param_name == "project_key":
        return get_project_choices()
    elif param_name == "webapp_id":
        return get_webapp_choices(config)
    elif param_name == "table_name":
        parent_config = payload.get("rootModel", config)
        return get_table_choices(parent_config)

    return {"choices": []}
