class DSSSelectorChoices(object):
    def __init__(self):
        self.choices = []

    def append(self, label, value):
        self.choices.append(
            {
                "label": label,
                "value": value
            }
        )

    def append_manual_select(self):
        self.choices.append(
            {
                "label": "✍️ Enter manually",
                "value": "_dku_manual_select"
            }
        )

    def _build_select_choices(self, choices=None):
        if not choices:
            return {"choices": []}
        if isinstance(choices, str):
            return {"choices": [{"label": "{}".format(choices)}]}
        if isinstance(choices, list):
            return {"choices": choices}
        if isinstance(choices, dict):
            returned_choices = []
            for choice_key in choices:
                returned_choices.append({
                    "label": choice_key,
                    "value": choices.get(choice_key)
                })

    def text_message(self, text_message):
        ret = self._build_select_choices(text_message)
        return ret

    def to_dss(self):
        return self._build_select_choices(self.choices)


class RecordsLimit():
    def __init__(self, records_limit=-1):
        self.has_no_limit = (records_limit == -1)
        self.records_limit = records_limit
        self.counter = 0

    def is_reached(self):
        if self.has_no_limit:
            return False
        self.counter += 1
        return self.counter > self.records_limit


def get_api_key_from_config(config):
    # The token's key name is changed according to the auth type
    # to make it less confusing in the "Parameter name" column
    # of the Credentials page
    TOKEN_KEY_NAME = {
        "oauth_app": "oauth_token",
        "user_account": "personal_access_token",
        "service_accounts": "personal_access_token",
    }
    authentication_type = config.get("authentication_type")
    api_key = None
    if not authentication_type or authentication_type == "api_key":
        api_key = config.get("key")
    else:
        key_name = TOKEN_KEY_NAME.get(authentication_type)
        api_key = config.get(authentication_type, {}).get(key_name)
    return api_key
