from airtable import safe_airtable_api
from airtable_common import get_api_key_from_config, DSSSelectorChoices


def do(payload, config, plugin_config, inputs):
    parameter_name = payload.get('parameterName')
    choices = DSSSelectorChoices()
    api_key = get_api_key_from_config(config)

    if not api_key:
        return choices.text_message("Select an authentication preset")

    if parameter_name == "base_select":
        json_response, error = safe_airtable_api("meta", "bases", api_key, "")
        if error:
            choices.append(error, None)
            choices.append_manual_select()
            return choices.to_dss()
        bases = json_response.get("bases", [])
        for base in bases:
            choices.append(base.get("name"), base.get("id"))
        choices.append_manual_select()

    if parameter_name == "table_select":
        base_id = config.get("base_select")
        if not base_id or base_id == "_dku_manual_select":
            base_id = config.get("base")
        if not base_id:
            return choices.text_message("Pick a base")
        json_response, error = safe_airtable_api("meta", "bases", api_key, "{}/tables".format(base_id))
        if error:
            return choices.text_message(error)
        tables = json_response.get("tables")
        for table in tables:
            choices.append(table.get("name"), table.get("id"))
        choices.append_manual_select()

    return choices.to_dss()
