llmApp.directive('advancedLlmSettings',['PLUGIN_PATHS', function (PLUGIN_PATHS) {
    return {
        restrict: 'E',
        scope: {
            config: '=', llmLabel: '@', llmMaxTokens: '=', llmTemperature: '=',
            minLlmTemperature: '@', minLlmTokens: '@'
        },
        templateUrl: PLUGIN_PATHS.DOCUMENT_QA +'advanced-llm-settings.html',
        controller: ['$scope', function ($scope) {
            //initialize data
            if (!$scope.llmLabel) {
                $scope.llmLabel = "";
            }
            if (!$scope.llmMaxTokens) {
                $scope.llmMaxTokens = null;
            }
            if (!$scope.llmTemperature) {
                $scope.llmTemperature = null;
            }
            // Initialize the expanded state (collapsed by default)
            $scope.isExpanded = false;

            // Function to toggle expansion
            $scope.toggleExpand = function() {
                $scope.isExpanded = !$scope.isExpanded;
            };


        }]

    };
}]);
