llmApp.directive('checkboxDirective', ['$timeout', 'DescParamsService','PLUGIN_PATHS', function ($timeout, DescParamsService,PLUGIN_PATHS) {
    return {
        restrict: 'E',
        templateUrl: PLUGIN_PATHS.DOCUMENT_QA +'checkbox-template.html',
        scope: {
            configProperty: '@',
            elementId: '@',
            config: '=',
            descriptionText: '@'
        },
        link: function (scope, element) {
            // Initialize scope properties
            //get default array from params
            if (!scope.config[scope.configProperty]) {
                //if we've found a default value
                if (DescParamsService.getDefaultValue(scope.configProperty)) {
                    scope.config[scope.configProperty] = DescParamsService.getDefaultValue(scope.configProperty);
                } else {
                    scope.config[scope.configProperty] = false
                }
            }
        }
    };
}]);
