llmApp.directive('contenteditable', function() {
        return {
            require: 'ngModel',
            link: function(scope, element, attrs, ngModel) {
                // Render the model value into the view
                ngModel.$render = function() {
                    element.html(ngModel.$viewValue || '');
                };

                // Listen for change events to update the model
                element.on('blur keyup change', function() {
                    scope.$apply(function() {
                        ngModel.$setViewValue(element.html());
                    });
                });
            }
        };
    });