llmApp.directive('customToggleSwitch', ['$timeout', 'DescParamsService','PLUGIN_PATHS', function ($timeout, DescParamsService,PLUGIN_PATHS) {
    return {
        restrict: 'E',
        templateUrl: PLUGIN_PATHS.DOCUMENT_QA +'custom-toggle-switch.html',
        scope: {
            configProperty: '@?',
            elementId: '@',
            config: '=',
            labelText: '@',
            descriptionText: '@?',
            clearArrayName: '@?',
            inputId: '@',
            customModel: '=?',
            disabled: '=?',
            disabledText: '@'
        },
        controller: ['$scope', function ($scope) {
            // Determine which model to use
            const useConfigProperty = $scope.configProperty && $scope.configProperty.trim() !== '';

            // Create an internal model that the template will bind to
            $scope.internalModel = useConfigProperty
                ? ($scope.config[$scope.configProperty] || false)
                : ($scope.customModel !== undefined ? $scope.customModel : false);

            // Watch changes to the internal model and update the appropriate external model
            $scope.$watch('internalModel', function (newValue, oldValue) {
                if (newValue !== oldValue) {
                    if (useConfigProperty) {
                        $scope.config[$scope.configProperty] = newValue;
                    } else {
                        $scope.customModel = newValue;

                        // Handle clearing the array if toggle turned off
                        if (oldValue === true && newValue === false && $scope.clearArrayName) {
                            if ($scope.config && $scope.config[$scope.clearArrayName]) {
                                $scope.config[$scope.clearArrayName] = [];

                            }
                        }
                    }
                }
            });

            // Watch changes to the external model and update the internal model
            if (useConfigProperty) {
                $scope.$watch(function () {
                    return $scope.config[$scope.configProperty];
                }, function (newValue) {
                    $scope.internalModel = newValue;
                });
            } else {
                $scope.$watch('customModel', function (newValue) {
                    $scope.internalModel = newValue;
                });
            }
        }]
    };
}]);
