llmApp.directive('feedbackChoices', ['DescParamsService','PLUGIN_PATHS', function (DescParamsService,PLUGIN_PATHS) {
    return {
        restrict: 'E',
        scope: {
            config: '=', choicesArray: '@', description: '@',
            allowWrap: '<',
            width: '@',
            labelButton: '@'
        },
        templateUrl: PLUGIN_PATHS.DOCUMENT_QA +'feedbackChoices.html',
        // The link function is no longer needed. All drag-and-drop DOM logic
        // has been migrated to the `dndSortable` directive, which is applied
        // in the template.
        controller: ['$scope', function ($scope) {

            $scope.isDragging= {}

            //get default array from params
            if (!$scope.config[$scope.choicesArray]) {
                //if we've found a default value
                if (DescParamsService.getDefaultValue($scope.choicesArray)) {
                    $scope.config[$scope.choicesArray] = DescParamsService.getDefaultValue($scope.choicesArray);
                } else {
                    $scope.config[$scope.choicesArray] = [];
                }
            }

            // Add a new empty feedback option
            $scope.addItem = function () {
                //Fallback option
                if (!$scope.config[$scope.choicesArray]) {
                    $scope.config[$scope.choicesArray] = [];
                }
                $scope.config[$scope.choicesArray].push('');
            };

            // Remove a feedback option
            $scope.removeItem = function (index) {
                $scope.config[$scope.choicesArray].splice(index, 1);
            };
        }]
    };
}]);