llmApp.directive('folderMultiSelector', ['PythonService', 'ParamsHelperService', 'PLUGIN_PATHS', function (PythonService, ParamsHelperService, PLUGIN_PATHS) {
    return {
        restrict: 'E',
        templateUrl: PLUGIN_PATHS.DOCUMENT_QA +'folder-multiselect-template.html',
        scope: {
            config: '=',
            formName: '@',
            labelText: '@',
            configProperty: '@',
            description: '@',
            folderChoices: '=?',
            triggerParameter: '=',
            width: '@?',
            maxHeightThreshold :'@?',
        },
        controller: ['$scope', '$timeout', function ($scope, $timeout) {


            $scope.maxHeightThreshold = $scope.maxHeightThreshold || 82; // Default height for ~2 rows
            $scope.isDropdownOpen = false;
            $scope.folders = [];
            $scope.config = $scope.config || {};
            $scope.selectedItems = [];

            // --- NEW/MODIFIED PROPERTIES FOR EXPAND/COLLAPSE LOGIC ---
            $scope.showAllItems = false;      // Tracks if the user wants to see all items
            $scope.exceedsMaxHeight = false;  // True if selected items overflow the threshold
            $scope.visibleItemCount = 0;      // The number of items that fit in the threshold
            $scope.remainingItemCount = 0;    // The number of items that are hidden

            $scope.toggleShowAll = function () {
                $scope.showAllItems = !$scope.showAllItems;
            };

            $scope.itemFilter = '';


            // Function to get visible items based on collapse state
            $scope.getVisibleItems = function() {
                if ($scope.selectedItems.length <= 3 || $scope.showAllItems) {
                    return $scope.selectedItems;
                } else {
                    return $scope.selectedItems.slice(0, 3);
                }
            };

            // Internal State
            let projectKey = $stateParams.projectKey;


            // Helper function to normalize data format
            // Helper function to normalize data format
            function normalizeDataFormat(data) {
                // Check if data is an array (second format)
                if (Array.isArray(data)) {
                    return {
                        "General": data.map(item => ({
                            value: item.value,
                            label: item.label,
                            type: "General"
                        }))
                    };
                }

                // Check if data is an object with arrays as values (first format)
                if (data && typeof data === 'object') {
                    const normalized = {};
                    Object.keys(data).forEach(function (type) {
                        if (Array.isArray(data[type])) {
                            // Check if items in array are strings or objects
                            normalized[type] = data[type].map(item => {
                                if (typeof item === 'string') {
                                    // First format: array of strings
                                    return {
                                        value: item,
                                        label: item,
                                        type: type
                                    };
                                } else if (item && typeof item === 'object' && item.value && item.label) {
                                    // Second format: array of objects (but grouped by type)
                                    return {
                                        value: item.value,
                                        label: item.label,
                                        type: type
                                    };
                                }
                                return null;
                            }).filter(item => item !== null);
                        }
                    });
                    return normalized;
                }

                // Invalid format
                return {};
            }

            // Initialize folder data
            $scope.initFolderData = function () {

                // If folder choices are provided directly, use those
                if ($scope.folderChoices) {
                    const normalizedData = normalizeDataFormat($scope.folderChoices);
                    $scope.foldersByType = normalizedData;
                    $scope.folders = [];

                    Object.keys($scope.foldersByType).forEach(function (type) {
                        $scope.folders = $scope.folders.concat($scope.foldersByType[type]);
                    });

                    initializeSelectedFolders();

                    return;
                }

                let parameterName = $scope.configProperty; 
                let payload = {
                    parameterName: parameterName,
                    projectKey: projectKey,
                };
                ParamsHelperService.do(payload, $scope.config)
                .then(function (data) {
                if (data && data.choices) {
                    const normalizedData = normalizeDataFormat(data.choices);
                    $scope.foldersByType = normalizedData;
                    $scope.folders = [];

                    Object.keys($scope.foldersByType).forEach(function (type) {
                        $scope.folders = $scope.folders.concat($scope.foldersByType[type]);
                    });

                    initializeSelectedFolders();
                } else {

                    $scope.foldersByType = {};
                    $scope.folders = [];
                }
            }, function (error) {

                $scope.foldersByType = {};
                $scope.folders = [];
            });                
            };

            // Add helper to check for folders in a type
            $scope.typeHasMatchingFolders = (type) =>
                $scope.foldersByType[type]?.length > 0;

            // Helper function to set selected folders based on config
            function initializeSelectedFolders() {
                $scope.selectedItems = [];

                // If config already has folder IDs array, find and set the corresponding folder objects
                if ($scope.config[$scope.configProperty] && Array.isArray($scope.config[$scope.configProperty])) {
                    var folderIds = $scope.config[$scope.configProperty];

                    folderIds.forEach(function (folderId) {
                        var foundFolder = $scope.folders.find(function (folder) {
                            return folder.value === folderId;
                        });

                        if (foundFolder) {
                            $scope.selectedItems.push(foundFolder);
                        }
                    });

                    // If the config had values but none were found in available folders, clear it
                    if (folderIds.length > 0 && $scope.selectedItems.length === 0) {
                        $scope.config[$scope.configProperty] = [];
                    }
                }
                // Initialize the config array if it doesn't exist
                else if (!$scope.config[$scope.configProperty]) {
                    $scope.config[$scope.configProperty] = [];
                }
                checkContentHeight()
            }

            // Toggle dropdown visibility
            $scope.toggleDropdown = function (event) {

                if (event) {
                    event.stopPropagation();

                }

                $scope.isDropdownOpen = !$scope.isDropdownOpen;

                // Close dropdown when clicking outside
                if ($scope.isDropdownOpen) {

                    $timeout(function () {
                        angular.element(document).one('click', function () {

                            $scope.$apply(function () {
                                $scope.isDropdownOpen = false;
                            });
                        });
                    }, 0);
                }
            };

            // Check if a folder is selected
            $scope.isItemSelected = function (item) {
                return $scope.selectedItems.some(function (selectedItem) {
                    return selectedItem.value === item.value;
                });
            };

            // Toggle selection of a folder
            $scope.toggleItemSelection = function (item) {

                if ($scope.isItemSelected(item)) {
                    $scope.removeItem(item);
                } else {
                    $scope.selectedItems.push(item);
                    updateConfigValue();
                }
            };


            // Remove a folder from selection
            $scope.removeItem = function (item, event) {

                if (event) {
                    event.stopPropagation();
                }

                $scope.selectedItems = $scope.selectedItems.filter(function (selectedItem) {
                    return selectedItem.value !== item.value;
                });

                updateConfigValue();
            };

            // Clear all selected items
            $scope.clearAllItems = function() {

                $scope.selectedItems = [];
                updateConfigValue();
                checkContentHeight();
            };

            // This is the core of the new logic. It calculates exactly how many items fit.
            function checkContentHeight() {
                var retries = 0;
                var maxRetries = 20; // Max attempts before giving up (only done during initialization)

                function attemptMeasurement() {
                    var container = document.getElementById($scope.configProperty + '-items-container');

                    // If container doesn't exist after retries, exit
                    if (!container) {
                        if (retries < maxRetries) {
                            retries++;
                            $timeout(attemptMeasurement, 100 * retries);
                        }
                        return;
                    }

                    var children = container.children;

                    // If no children after retries, exit
                    if (children.length === 0) {
                        if (retries < maxRetries) {
                            retries++;
                            $timeout(attemptMeasurement, 100 * retries);
                        }
                        return;
                    }

                    // First child missing dimensions? Schedule retry
                    if (children[0].offsetHeight === 0) {
                        if (retries < maxRetries) {
                            retries++;
                            $timeout(attemptMeasurement, 100 * retries);
                            return;
                        }
                    }

                    // Proceed with measurements
                    var visibleCount = children.length;
                    for (let i = 0; i < children.length; i++) {
                        const item = children[i];
                        const itemBottom = item.offsetTop + item.offsetHeight;
                        if (itemBottom > $scope.maxHeightThreshold) {
                            visibleCount = i;
                            break;
                        }
                    }

                    // Update scope properties
                    $scope.visibleItemCount = visibleCount;
                    $scope.exceedsMaxHeight = visibleCount < children.length;
                    $scope.remainingItemCount = children.length - visibleCount;

                    if (!$scope.exceedsMaxHeight) {
                        $scope.showAllItems = false;
                    }
                }

                // Initial measurement attempt
                $timeout(attemptMeasurement, 0);
            }

            // Update the config value with current selections
            function updateConfigValue() {
                $scope.config[$scope.configProperty] = $scope.selectedItems.map(function (item) {
                    return item.value;
                });

            }

            $scope.$watch('triggerParameter', function(newValue, oldValue) {

                // Only re-initialize if the value actually changed and it's not the initial watch call
                if (newValue !== oldValue) {

                    $scope.initFolderData();
                }
            }, true); // Use deep watch (true) to detect changes in object properties

            // Listen for scope destruction and reset the config property
            $scope.$on('$destroy', function() {
                angular.element(window).off('resize');


            });

            // Initialize data when directive loads
            $scope.initFolderData();

            // 1. WATCHER: This handles all subsequent changes to the selected items.
            $scope.$watch('selectedItems', function(newValue, oldValue) {
                if (newValue !== oldValue) {
                    checkContentHeight();
                }
            }, true);

        }]
    };
}]);
