llmApp.directive('inputWithLabel', ['PLUGIN_PATHS',function (PLUGIN_PATHS) {
    return {
        restrict: 'E',
        templateUrl: PLUGIN_PATHS.DOCUMENT_QA +'input-with-label.html',
        scope: {
            config: '=',
            labelText: '@',
            configProperty: '@',
            initialWidth: '@?',
            initialHeight: '@?',
            placeholder: '@?',
            description: '@',
            fieldRequired: '=',
            formName: '=',
            customMargin: '@?'
        },
        link: function (scope, element, attrs) {
            // Set default dimensions if not provided
            scope.initialWidth = scope.initialWidth || '100%';
            scope.initialHeight = scope.initialHeight || '80px';
            var textarea = element.find('textarea')[0];

            if (textarea) {
                textarea.style.width = scope.initialWidth;
                textarea.style.height = scope.initialHeight;
            }

        },
        controller: ['$scope', '$timeout', function ($scope, $timeout) {
            if (!$scope.config[$scope.configProperty]) {
                $scope.config[$scope.configProperty] = "";
            }

            // Watch for changes to detect if something sets it to undefined
            //While debugging, we noticed that the property was set to undefined
            // This is dangerous because we need the value to be present in the config object (if it set to undefined, the serialization of the config object dont save the configproperty )
            $scope.$watch('config.' + $scope.configProperty, function (newVal) {
                if (newVal === undefined) {

                    $scope.config[$scope.configProperty] = "";
                }
            });

            $scope.isFieldEmpty = function () {
                // Check if the field is undefined, null, or an empty string
                return $scope.config[$scope.configProperty] === undefined || $scope.config[$scope.configProperty] === null || $scope.config[$scope.configProperty].trim() === "";
            };

        }]

    };
}]);
