// uniqueLlmSelector => unique-llm-selector
llmApp.directive('uniqueLlmSelector', ['PythonService', 'ParamsHelperService', 'PLUGIN_PATHS', '$stateParams', function (PythonService, ParamsHelperService, PLUGIN_PATHS, stateParams) {
    return {
        restrict: 'E',
        templateUrl: PLUGIN_PATHS.DOCUMENT_QA + 'llm-selector-template.html',
        scope: {
            config: '=',
            formName: '=',
            labelText: '@',
            fieldRequired: '=',
            configProperty: '@',
            context: '@',
            description: '@'
        },
        controller: ['$scope', '$timeout', '$element', function ($scope, $timeout, $element) {
            $scope.isDropdownHovered = false;
            $scope.isLLMDropdownOpen = false;
            $scope.llmFilter = ''; // Model for the main LLM input field
            $scope.llms = [];
            $scope.llmsByType = {};
            $scope.selectedLLM = null;
            //Flag to control when filtering is applied (starts false to show all on open)
            $scope.filterActive = false;
            $scope.showCopyTooltip = false;


            $scope.isLLMFocused = false; // For ng-class styling
            var llmBlurTimeout = null; // For managing blur event

            // Internal state to track the selected LLM object
            $scope.selectedLLM = null;
            let projectKey = $stateParams.projectKey;


            // Wrapper function to call the callPythonDo function from the correct scope
            function executeCallPythonDo(params) {

                if ($scope.context) {
                    return $scope.$parent.$parent.callPythonDo(params);
                } else {
                    return $scope.$parent.callPythonDo(params)
                }
            }

            $scope.copyLLMValue = function() {
                if ($scope.selectedLLM && $scope.selectedLLM.llmId) {
                    // Create a temporary textarea element to copy the text
                    var textArea = document.createElement('textarea');
                    textArea.value = $scope.selectedLLM.llmId;
                    document.body.appendChild(textArea);
                    textArea.select();

                    try {
                        document.execCommand('copy');
                    } catch (err) {
                    }

                    document.body.removeChild(textArea);
                }
            };


            $scope.initLLMData = function () {
                let llmParam = $scope.configProperty; // `llmParam` is in  ['llm_id', 'title_llm_id', 'json_decision_llm_id', 'image_generation_llm_id']
                const subCompletionLLMs = ["title_llm_id", "json_decision_llm_id"] ;
                let purpose = "GENERIC_COMPLETION";
                let typesToExclude = [];
                if (llmParam === "image_generation_llm_id"){
                    purpose = "IMAGE_GENERATION";
                };

                if (subCompletionLLMs.includes(llmParam)) {
                    typesToExclude = ["SAVED_MODEL_AGENT", "RETRIEVAL_AUGMENTED"];
                }

                let payload = {
                    parameterName: llmParam,
                    projectKey: projectKey,
                    purpose: purpose,
                    typesToExclude: typesToExclude
                };

                ParamsHelperService.do(payload, $scope.config, {}, {}).then(function (data) {
                    if (data && data.choices) {
                        $scope.llmsByType = {};
                        $scope.llms = [];
                        Object.keys(data.choices).forEach(function (llmType) {
                            $scope.llmsByType[llmType] = [];
                            data.choices[llmType].forEach(function (llm) {
                                var llmObj = {
                                    id: llm.value,
                                    llmId: llm.value,
                                    llmDisplayName: llm.label,
                                    llmType: llmType,
                                    //connection: llm.connection, // Note: Not in the response
                                    //model: llm.model, // Note: Not in the response
                                    isHovered: false
                                };
                                $scope.llms.push(llmObj);
                                $scope.llmsByType[llmType].push(llmObj);
                            });
                        });

                        var configProp = $scope.configProperty || 'llm_id';
                        if ($scope.config[configProp]) {
                            var llmId = $scope.config[configProp];
                            var foundLLM = $scope.llms.find(function (l) {
                                return l.llmId === llmId;
                            });
                            if (foundLLM) {
                                $scope.selectedLLM = foundLLM;
                                $scope.llmFilter = foundLLM.llmDisplayName; // Set input text
                            } else {
                                $scope.config[configProp] = null;
                                $scope.selectedLLM = null;
                                $scope.llmFilter = '';
                            }
                        } else if ($scope.llms.length > 0) {
                            /*        if (!$scope.selectedLLM) { // Only set default if nothing is selected already
                                        $scope.selectedLLM = $scope.llms[0];
                                        $scope.config[configProp] = $scope.selectedLLM.llmId;
                                        $scope.llmFilter = $scope.selectedLLM.llmDisplayName; // Set input text

                                    }*/
                        } else {
                            $scope.llmFilter = '';
                        }
                    } else {

                        $scope.llms = [];
                        $scope.llmsByType = {};
                        $scope.selectedLLM = null;
                        $scope.llmFilter = '';
                    }
                }, function (error) {

                    $scope.llms = [];
                    $scope.llmsByType = {};
                    $scope.selectedLLM = null;
                    $scope.llmFilter = '';
                });
            };

            var llmDocumentClickHandler = function (event) {
                if ($scope.isLLMDropdownOpen && !$element[0].contains(event.target)) {
                    $scope.$apply(function () {
                        $scope.closeLLMDropdownAndRevertText();
                    });
                }
            };

            $scope.closeLLMDropdownAndRevertText = function () {
                $scope.isLLMDropdownOpen = false;
                $scope.isLLMFocused = false;
                angular.element(document).off('click', llmDocumentClickHandler);
                if ($scope.selectedLLM) {
                    $scope.llmFilter = $scope.selectedLLM.llmDisplayName;
                } else {
                    //$scope.llmFilter = ''; // Optionally clear if no valid selection
                }
                //Reset filterActive on close
                $scope.filterActive = false;
            };

            $scope.openLLMDropdown = function (clearFilter) {
                if (llmBlurTimeout) $timeout.cancel(llmBlurTimeout);

                if ($scope.isLLMDropdownOpen) {
                    // Close the dropdown and revert the input text
                    $scope.closeLLMDropdownAndRevertText();
                } else {
                    if (clearFilter) {
                        $scope.llmFilter = ''; // Clear filter when opening via arrow click
                    }
                    $scope.isLLMDropdownOpen = true;
                    //Disable filtering initially (show all, even if datasetFilter has text)
                    $scope.filterActive = false;
                    $timeout(function () {
                        angular.element(document).on('click', llmDocumentClickHandler);
                    }, 0);

                }

            };


            $scope.selectLLM = function (llm) {
                if (llmBlurTimeout) $timeout.cancel(llmBlurTimeout);
                $scope.selectedLLM = llm;
                $scope.config[$scope.configProperty || 'llm_id'] = llm.llmId;
                $scope.llmFilter = llm.llmDisplayName;
                $scope.isLLMDropdownOpen = false;
                $scope.isLLMFocused = false;
                angular.element(document).off('click', llmDocumentClickHandler);
            };

            // Update clearLLMSelection to use new open signature
            $scope.clearLLMSelection = function () {
                $scope.llmFilter = '';
                $scope.selectedLLM = null;
                $scope.config[$scope.configProperty || 'llm_id'] = null;
                $scope.openLLMDropdown(null, true); // Open with cleared filter
                $element[0].querySelector('input').focus();
            };


            $scope.handleLLMInputChange = function () {
                if ($scope.selectedLLM && $scope.llmFilter !== $scope.selectedLLM.llmDisplayName) {
                    $scope.selectedLLM = null;
                    $scope.config[$scope.configProperty || 'llm_id'] = null;
                }
                //Activate filtering now that the user is typing
                $scope.filterActive = true;

                // Automatically open dropdown when typing starts
                if (!$scope.isLLMDropdownOpen && $scope.llmFilter) {
                    $scope.openLLMDropdown(null, false); // Don't clear filter
                }
            };

            $scope.handleLLMInputBlur = function () {
                llmBlurTimeout = $timeout(function () {
                    if ($scope.isLLMDropdownOpen) {
                        $scope.closeLLMDropdownAndRevertText();
                    }
                }, 200);
            };

            //Handle input focus logic (open only if not already open)
            $scope.handleInputFocus = function () {
                if (!$scope.isLLMDropdownOpen) {
                    $scope.openLLMDropdown(false);
                }
            };

            // Filter functions
            $scope.llmMatchesFilter = function (llm) {
                //If filter not active, show all
                if (!$scope.filterActive) return true;
                if (!$scope.llmFilter) return true;
                const filter = $scope.llmFilter.toLowerCase();
                return llm.llmDisplayName.toLowerCase().includes(filter) || llm.llmType.toLowerCase().includes(filter) || (llm.connection && llm.connection.toLowerCase().includes(filter)) || (llm.model && llm.model.toLowerCase().includes(filter));
            };

            $scope.typeHasMatchingLLMs = function (type) {
                if (!$scope.llmsByType[type]) return false;
                return $scope.llmsByType[type].some(l => $scope.llmMatchesFilter(l));
            };

            $scope.hasMatchingLLMs = function () {
                if ($scope.llms.length === 0) return false;
                if (!$scope.llmFilter) return true;
                return $scope.llms.some(l => $scope.llmMatchesFilter(l));
            };

            $scope.$on('$destroy', function () {
                angular.element(document).off('click', llmDocumentClickHandler);
            });

            $scope.initLLMData();
        }]
    };
}]);
