llmApp.directive('generalFeedback', ['PLUGIN_PATHS','SUPPORTED_CONNECTIONS', function (PLUGIN_PATHS,SUPPORTED_CONNECTIONS) {
    return {
        restrict: 'E',
        templateUrl: PLUGIN_PATHS.DOCUMENT_QA +'general-feedback.html',
        scope: {
            config: '=', configForm: '='
        },
        controller: ['$scope', '$timeout', function ($scope, $timeout) {
            $scope.config = $scope.config || {};
            $scope.isGeneralFeedbackSettingsExpanded = false;
            $scope.supportedConnections = SUPPORTED_CONNECTIONS;

            $scope.toggleExpand = function(propertyName) {
                $scope[propertyName] = !$scope[propertyName];
            };

            // Initialize as object property
            $scope.state = {
                newGeneralFeedbackDataset: false
            };

            $scope.toggleFlag = function (name) {
                if (name === "GeneralFeedback") {
                    $scope.state.newGeneralFeedbackDataset = !$scope.state.newGeneralFeedbackDataset;
                }
            };
            if (!$scope.config.allow_general_feedback) {
                $scope.config.allow_general_feedback = false;
            }

        }]
    };
}]);
