llmApp.service('SharedPromiseService', function ($q, PythonService, ParamsHelperService, SharedDataService) {
    var dataPromises = {}; // Our cache

    // Helper method to fetch data and store it in cache
    var fetchData = function (param) {
        //const projectKey = SharedDataService.getprojectKey();
        const payload = {
            //projectKey: projectKey,
            parameterName: param
        };
        var fetchPromise = ParamsHelperService.do(payload).then(function (data) {
            // Store the fresh data in the cache immediately upon successful fetch
            dataPromises[param] = $q.when(data); // Wrap data in a resolved promise
            return data; // Resolve the promise with the fetched data
        }).catch(function (error) {

            // If fetch fails, we might want to remove it from cache or resolve with an error state
            delete dataPromises[param]; // Remove from cache on error
            return $q.reject(error); // Reject the promise
        });
        return fetchPromise;
    };

    this.getData = function (param) {
        if (!dataPromises[param]) {

            dataPromises[param] = fetchData(param); // Initiate fetch and store the promise
        } else {

        }
        return dataPromises[param]; // Return the promise (either cached or newly created)
    };

    // Method to invalidate cache entry and immediately start a refresh
    this.refreshData = function (param) {

        // Store the refresh promise immediately to prevent race conditions
        var refreshPromise = fetchData(param);
        dataPromises[param] = refreshPromise;  // Cache the new promise right away
        // Fetch the data and update the cache entry directly
        return dataPromises[param];
    };

    // Keep clearCache for explicit manual cache clearing if needed elsewhere
    this.clearCache = function (param) {

        delete dataPromises[param];
    };
});
