import logging

from answers.backend.utils.version import log_current_version
from common.backend.utils.dataiku_api import dataiku_api
from flask import Flask
from flask_cors import CORS
from flask_socketio import SocketIO


class NoParsingFilter(logging.Filter):
    def filter(self, record):
        message = record.getMessage()            
        return not message.endswith('AssertionError: write() before start_response')


def run_create_app(app: Flask):
    # Prevent Assertion error logging from Werkeug
    logging.getLogger("werkzeug").addFilter(NoParsingFilter())

    from answers.backend.routes import api, setup_socketio_answer_event_handlers
    CORS(app)
    # Handle WebSockets for streaming
    socketio = SocketIO(app, cors_allowed_origins='*', path="/stream")
    setup_socketio_answer_event_handlers(socketio)
    # socketio.init_app(app)
    app.register_blueprint(api)

    log_current_version()

    @app.after_request
    def apply_security_headers(response):
        config = dataiku_api.webapp_config
        http_headers = config.get("http_headers", [])
        for header in http_headers:
            response.headers[header["from"]] = header["to"]
        return response
    return app, socketio
