

from typing import Any, Dict, List, TypeVar, Union


class VecOperator:
    EQ = "$eq"
    NE = "$ne"
    GT = "$gt"
    GTE = "$gte"
    LT = "$lt"
    LTE = "$lte"
    IN = "$in"
    NIN = "$nin"
    AND = "$and"
    OR = "$or"

T = TypeVar("T", bound="VecOperator")

ListConditional = List[Union[str, int, float]]
ValueConditional = Union[str, int, float]
NumericConditional = Union[int, float]
ConditionalExpression = Union[ValueConditional, ListConditional, NumericConditional]
ConditionDictType = Dict[str, Dict[str, Union[ValueConditional, ListConditional, List[Any]]]]
RawExpression = Union[ConditionalExpression, ConditionDictType]
ExpressionList = Union[ConditionalExpression, ConditionDictType, List[ConditionDictType]]


