
from answers.solutions.vector_search.generic_vector_search import ConditionDictType, GenericVectorQuery, ListConditional
from answers.solutions.vector_search.models import VecOperator


class QdrantOperator(VecOperator):
    EXISTS = "$exists"

class PineConeVectorQuery(GenericVectorQuery):
    def __init__(self):
        super().__init__(QdrantOperator)
        self.operator_methods.update({"exists": self.exists_cond})

    def exists_cond(self, field: str, values: ListConditional) -> ConditionDictType:
        if isinstance(values, str) or isinstance(values, int) or isinstance(values, float):
            raise ValueError("Values must be a list for IN operator")
        return {field: {self.vec_operator.EXISTS: values}}
