from flask import abort


# Example of validator not used now
def validate_ui_settings(data):
    """
    Validate uiSettings payload beyond schema-level validation.
    Example: Check for specific files or other external constraints.
    """
    # Example: Check that logoFileName and iconFileName match a specific pattern
    if not data["logoFileName"].endswith((".png", ".jpg", ".jpeg")):
        abort(400, description="Invalid file format for logoFileName. Use .png, .jpg, or .jpeg.")
    
    if not data["iconFileName"].endswith((".ico", ".png")):
        abort(400, description="Invalid file format for iconFileName. Use .ico or .png.")

    # Add other validation rules as needed
    return True