# Project Documentation for AngularJS Codebase

## Introduction
This documentation is created to support the redesign of the legacy Settings page, which currently uses an outdated UI and needs modernization. The goal is detail how the current system works in order to refactor or rebuild it effectively during the redesign process.

## Code Structure Overview
The AngularJS codebase consists of several components and directives that manage user settings and configurations. Below is a detailed description of each relevant file and directive.

### Directives Overview
The following directives are used throughout the application:

1. **`<language-mappings>`**
   - **Role**: Manages the list of language mappings for user profiles.
   - **Structure**:
     - **Attributes**:
       - `config`: Configuration object passed to the directive.
       - `mappings-array`: Array containing the language mappings.
       - `description`: Descriptive text for the mappings section.
   - **Interactions**: Allows users to dynamically add or remove language mappings.

2. **`<folder-selector>`**
   - **Role**: Provides a UI for selecting folders.
   - **Structure**:
     - **Attributes**:
       - `config`: Configuration object.
       - `label-text`: Text label for the folder selector.
       - `config-property`: Property in the configuration object that stores the selected folder.
   - **Interactions**: Integrates with the user profile settings to allow selection of a default language folder.

3. **`<unique-llm-selector>`**
   - **Role**: Allows users to select a specific LLM (Language Model).
   - **Structure**:
     - **Attributes**:
       - `config`: Configuration object.
       - `form-name`: Name of the form for validation.
       - `label-text`: Label for the selector.
       - `config-property`: Property in the configuration object that stores the selected LLM.
   - **Interactions**: Fetches available LLMs from the backend and updates the configuration accordingly.

4. **`<dataset-selector>`**
   - **Role**: Manages the selection of datasets for conversation history and user profiles.
   - **Structure**:
     - **Attributes**:
       - `config`: Configuration object.
       - `form-name`: Name of the form for validation.
       - `label-text`: Label for the dataset selector.
       - `config-property`: Property in the configuration object that stores the selected dataset.
   - **Interactions**: Updates the configuration based on user selection and validates dataset requirements.

5. **`<conversation-store-config>`**
   - **Role**: Configures settings related to conversation history storage.
   - **Structure**: Contains various input fields and options for managing conversation data.
   - **Interactions**: Integrates with the main form to ensure conversation history is properly logged.

6. **`<document-upload-config>`**
   - **Role**: Manages document upload settings.
   - **Structure**: Provides options for users to upload documents related to their profiles.
   - **Interactions**: Ensures that uploaded documents are linked to the user's profile settings.

7. **`<retrieval-knowledge>`**
   - **Role**: Configures knowledge retrieval settings for the application.
   - **Structure**: Contains input fields for specifying retrieval parameters.
   - **Interactions**: Works with the main configuration to ensure knowledge retrieval is set up correctly.

8. **`<filters-metadata>`**
   - **Role**: Manages filters and metadata settings for the application.
   - **Structure**: Provides options for defining filters that affect data retrieval.
   - **Interactions**: Integrates with the main configuration to apply filters during data queries.

9. **`<answers-api-configuration>`**
   - **Role**: Configures settings for the Answers API integration.
   - **Structure**: Contains input fields for API keys and endpoint configurations.
   - **Interactions**: Ensures that the application can communicate with the Answers API effectively.

10. **`<end-user-configuration>`**
    - **Role**: Manages settings related to end-user configurations.
    - **Structure**: Provides options for users to customize their profiles.
    - **Interactions**: Updates the user profile settings based on user input.

11. **`<user-profile-settings>`**
    - **Role**: Configures user profile settings.
    - **Structure**: Contains input fields for user-specific configurations.
    - **Interactions**: Integrates with the main form to ensure user profiles are updated correctly.

12. **`<backend-dir>`**
    - **Role**: Manages backend directory settings.
    - **Structure**: Provides options for configuring backend connections.
    - **Interactions**: Ensures that the application can connect to the backend services.

13. **`<web-app-configuration>`**
    - **Role**: Configures settings for the web application.
    - **Structure**: Contains input fields for web app-specific configurations.
    - **Interactions**: Integrates with the main configuration to ensure web app settings are applied.

### Code Structure Details
The AngularJS codebase consists of several components and directives that manage user settings and configurations. Below is a detailed description of each relevant file and directive.

### 1. User Profile Settings (`user-profile-settings.html`)
This file contains the configuration for user profiles, including:
- **Language Mappings**: Utilizes the `<language-mappings>` directive to configure the list of languages available to users. This directive allows for dynamic addition and removal of language mappings, which are essential for personalizing user experiences.

### 2. Language Mappings (`language-mappings.html`)
This component provides a user interface for managing language mappings, including:
- Dynamic rendering of language items using `ng-repeat`, which allows for real-time updates as users add or remove mappings.
- Functionality to add, edit, and remove language mappings with drag-and-drop support, enhancing user interaction.

### 3. Folder Selector (`folder-selector-template.html`)
This directive allows users to select folders with a dropdown menu that includes:
- Search functionality to filter folder options, making it easier for users to find the desired folder.
- Validation to ensure a folder is selected, providing feedback if the selection is missing.

### 4. LLM Configuration Form (`form.html`)
The main structure for the LLM configuration, featuring:
- A navigation panel for different configuration sections, allowing users to switch between settings easily.
- Conditional rendering of various components based on the selected section.

### 5. Controller and Services
The application likely includes controllers and services that manage the data flow between components. For example:
- **LLMConfigController**: Manages the state of the LLM configuration form, handling user interactions and data binding.
- **Services**: May include API services for fetching available datasets or LLMs, ensuring that the UI is populated with current data.

### 6. Params Helper Script (`params_helper.py`)
The `params_helper.py` script is accessed using the `callPython` directive and plays a crucial role in the AngularJS components by providing functionality to retrieve form data. 
- **Purpose**: This script is designed to handle data processing and retrieval tasks that are essential for the AngularJS components to function correctly.
- **Interactions**: It interacts with the AngularJS application by providing endpoints that the components can call to fetch or manipulate data. This is particularly important for ensuring that the form data is accurately retrieved and processed.

## Limitations Faced
During the redesign process, several limitations were encountered:
- **Backend Coupling**: The backend is tightly coupled with `app.params.backendEnabled`. Initially, there was an attempt to disable this option by accessing the `app` scope. However, this caused the backend logs tabs in the settings to disappear, which is not ideal. As a result, the backend of the application cannot be started.
- **Button Functionality**: The "save and view app" button cannot be disabled, which prevents the redesign of this element.

These limitations have consequences, resulting in both the original backend view and the original "save and view app" button being displayed below the custom UI settings.
