import { useToast } from "@/components/ui/toast"

export function useNotification() {
  const { toast } = useToast()

  function createNotification(type: 'positive' | 'negative', msg: string) {
    const config = {
      positive: {
        title: 'Success',
        variant: 'success',
        icon: 'check',
      },
      negative: {
        title: 'Error',
        variant: 'destructive',
        icon: 'warning',
      },
    }[type]

    toast({
      title: config.title,
      description: msg,
      variant: config.variant as 'success' | 'destructive',
      duration: 3000,
      class: "w-48 mx-auto md:w-full"
    })
  }

  return { createNotification }
}
